/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

abstract class DisposableBulkhead<T>
extends AtomicReference<Disposable>
implements Disposable {
    private final Bulkhead bulkhead;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    DisposableBulkhead(Bulkhead bulkhead) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
    }

    public final void dispose() {
        if (DisposableHelper.dispose((AtomicReference)this)) {
            this.releaseBulkhead();
        }
    }

    public final boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }

    protected void onSubscribeInner(Disposable disposable) {
    }

    protected final void onSubscribeWithPermit(Disposable disposable) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)disposable)) {
            if (this.acquireCallPermit()) {
                this.onSubscribeInner(this);
            } else {
                this.dispose();
                this.onSubscribeInner(this);
                this.permittedOnError(this.bulkheadFullException());
            }
        }
    }

    protected void permittedOnError(Throwable e) {
    }

    protected final void onErrorInner(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.permittedOnError(e);
        }
    }

    protected void permittedOnComplete() {
    }

    protected final void onCompleteInner() {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.permittedOnComplete();
        }
    }

    protected void permittedOnSuccess(T value) {
    }

    protected final void onSuccessInner(T value) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.permittedOnSuccess(value);
        }
    }

    protected void permittedOnNext(T value) {
    }

    protected final void onNextInner(T value) {
        if (this.isInvocationPermitted()) {
            this.permittedOnNext(value);
        }
    }

    private boolean isInvocationPermitted() {
        return !this.isDisposed() && this.wasCallPermitted();
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.bulkhead.isCallPermitted())) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private Exception bulkheadFullException() {
        return new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName()));
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    private void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }
}

