/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.operator.DisposableBulkhead;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

final class BulkheadSingleObserver<T>
extends DisposableBulkhead
implements SingleObserver<T> {
    private final SingleObserver<? super T> childObserver;

    BulkheadSingleObserver(Bulkhead bulkhead, SingleObserver<? super T> childObserver) {
        super(bulkhead);
        this.childObserver = Objects.requireNonNull(childObserver);
    }

    public void onSubscribe(Disposable disposable) {
        this.setDisposable(disposable);
        if (this.acquireCallPermit()) {
            this.childObserver.onSubscribe((Disposable)this);
        } else {
            this.dispose();
            this.childObserver.onSubscribe((Disposable)this);
            this.childObserver.onError((Throwable)this.bulkheadFullException());
        }
    }

    public void onError(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childObserver.onError(e);
        }
    }

    public void onSuccess(T value) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childObserver.onSuccess(value);
        }
    }
}

