/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.timelimiter.configuration;

import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CommonTimeLimiterConfigurationProperties
extends CommonProperties {
    private static final String DEFAULT = "default";
    private final Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private final Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    @Nullable
    public InstanceProperties getInstanceProperties(String backend) {
        InstanceProperties instanceProperties = this.instances.get(backend);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get(DEFAULT);
        } else if (this.configs.get(DEFAULT) != null) {
            ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
        }
        return instanceProperties;
    }

    public TimeLimiterConfig createTimeLimiterConfig(String backendName, @Nullable InstanceProperties instanceProperties, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        if (instanceProperties == null) {
            return this.buildDefaultConfig();
        }
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, instanceProperties, compositeTimeLimiterCustomizer, backendName);
        }
        if (this.configs.get(DEFAULT) != null) {
            return CommonTimeLimiterConfigurationProperties.buildTimeLimiterConfig(TimeLimiterConfig.from((TimeLimiterConfig)this.buildDefaultConfig()), instanceProperties, compositeTimeLimiterCustomizer, backendName);
        }
        return CommonTimeLimiterConfigurationProperties.buildTimeLimiterConfig(TimeLimiterConfig.custom(), instanceProperties, compositeTimeLimiterCustomizer, backendName);
    }

    private TimeLimiterConfig buildDefaultConfig() {
        return CommonTimeLimiterConfigurationProperties.buildTimeLimiterConfig(TimeLimiterConfig.custom(), this.configs.get(DEFAULT), new CompositeCustomizer<TimeLimiterConfigCustomizer>(Collections.emptyList()), DEFAULT);
    }

    private TimeLimiterConfig buildConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer, String backendName) {
        ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
        TimeLimiterConfig baseConfig = this.createTimeLimiterConfig(backendName, baseProperties, compositeTimeLimiterCustomizer);
        return CommonTimeLimiterConfigurationProperties.buildTimeLimiterConfig(TimeLimiterConfig.from((TimeLimiterConfig)baseConfig), instanceProperties, compositeTimeLimiterCustomizer, backendName);
    }

    private static TimeLimiterConfig buildTimeLimiterConfig(TimeLimiterConfig.Builder builder, @Nullable InstanceProperties instanceProperties, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer, String backendName) {
        if (instanceProperties == null) {
            return builder.build();
        }
        if (instanceProperties.getTimeoutDuration() != null) {
            builder.timeoutDuration(instanceProperties.getTimeoutDuration());
        }
        if (instanceProperties.getCancelRunningFuture() != null) {
            builder.cancelRunningFuture(instanceProperties.getCancelRunningFuture().booleanValue());
        }
        compositeTimeLimiterCustomizer.getCustomizer(backendName).ifPresent(timeLimiterConfigCustomizer -> timeLimiterConfigCustomizer.customize(builder));
        return builder.build();
    }

    public TimeLimiterConfig createTimeLimiterConfig(String limiter) {
        return this.createTimeLimiterConfig(limiter, this.getInstanceProperties(limiter), new CompositeCustomizer<TimeLimiterConfigCustomizer>(Collections.emptyList()));
    }

    public static class InstanceProperties {
        private Duration timeoutDuration;
        private Boolean cancelRunningFuture;
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private String baseConfig;

        public Duration getTimeoutDuration() {
            return this.timeoutDuration;
        }

        public InstanceProperties setTimeoutDuration(Duration timeoutDuration) {
            Objects.requireNonNull(timeoutDuration);
            if (timeoutDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("timeoutDuration must be greater than or equal to 0.");
            }
            this.timeoutDuration = timeoutDuration;
            return this;
        }

        public Boolean getCancelRunningFuture() {
            return this.cancelRunningFuture;
        }

        public InstanceProperties setCancelRunningFuture(Boolean cancelRunningFuture) {
            this.cancelRunningFuture = cancelRunningFuture;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(@Nullable String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

