/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolProperties;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;

public class ThreadPoolBulkheadConfigurationProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(String backend) {
        return this.createThreadPoolBulkheadConfig(this.getBackendProperties(backend));
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(InstanceProperties instanceProperties) {
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildThreadPoolConfigFromBaseConfig(baseProperties, instanceProperties);
        }
        return this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.custom(), instanceProperties);
    }

    private ThreadPoolBulkheadConfig buildThreadPoolConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties) {
        ThreadPoolBulkheadConfig baseConfig = this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.custom(), baseProperties);
        return this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.from((ThreadPoolBulkheadConfig)baseConfig), instanceProperties);
    }

    public ThreadPoolBulkheadConfig buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.Builder builder, InstanceProperties properties) {
        if (properties == null) {
            return ThreadPoolBulkheadConfig.custom().build();
        }
        if (properties.getThreadPoolProperties() != null) {
            if (properties.getThreadPoolProperties().getQueueCapacity() > 0) {
                builder.queueCapacity(properties.getThreadPoolProperties().getQueueCapacity());
            }
            if (properties.getThreadPoolProperties().getCoreThreadPoolSize() > 0) {
                builder.coreThreadPoolSize(properties.getThreadPoolProperties().getCoreThreadPoolSize());
            }
            if (properties.getThreadPoolProperties().getMaxThreadPoolSize() > 0) {
                builder.maxThreadPoolSize(properties.getThreadPoolProperties().getMaxThreadPoolSize());
            }
            if (properties.getThreadPoolProperties().getKeepAliveTime() > 0L) {
                builder.keepAliveTime(properties.getThreadPoolProperties().getKeepAliveTime());
            }
            if (properties.getThreadPoolProperties().getKeepAliveDuration() != null && properties.getThreadPoolProperties().getKeepAliveDuration().toMillis() > 0L) {
                builder.keepAliveTime(properties.getThreadPoolProperties().getKeepAliveDuration().toMillis());
            }
        }
        return builder.build();
    }

    public static class InstanceProperties {
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer eventConsumerBufferSize;
        @Nullable
        private String baseConfig;
        @Nullable
        private ThreadPoolProperties threadPoolProperties;

        @Nullable
        public ThreadPoolProperties getThreadPoolProperties() {
            return this.threadPoolProperties;
        }

        public InstanceProperties setThreadPoolProperties(@Nullable ThreadPoolProperties threadPoolProperties) {
            this.threadPoolProperties = threadPoolProperties;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public void setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
        }
    }
}

