/*
 * Decompiled with CFR 0.152.
 */
package com.smh_digitalassistant_library.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.smh_digitalassistant_library.R;
import com.smh_digitalassistant_library.models.MessageViewModel;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002\u0015\u0016B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001c\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001c\u0010\u0011\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/smh_digitalassistant_library/adapters/ChatAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/smh_digitalassistant_library/adapters/ChatAdapter$ViewHolder;", "messageList", "Ljava/util/ArrayList;", "Lcom/smh_digitalassistant_library/models/MessageViewModel;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "add", "", "message", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "ViewHolder", "SmH-DigitalAssistant-Library_release"})
public final class ChatAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<MessageViewModel> messageList;
    private static final int BOT = 0;
    private static final int USER = 1;

    public ChatAdapter(@NotNull ArrayList<MessageViewModel> messageList) {
        Intrinsics.checkNotNullParameter(messageList, (String)"messageList");
        this.messageList = messageList;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View view;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = viewType;
        switch (n) {
            case 0: {
                view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.card_view_bot_message, parent, false);
                break;
            }
            case 1: {
                view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.card_view_user_message, parent, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid view type");
            }
        }
        View view2 = view;
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        return new ViewHolder(view2);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        MessageViewModel messageViewModel = this.messageList.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)messageViewModel, (String)"messageList[position]");
        holder.bind(messageViewModel);
    }

    public int getItemCount() {
        return this.messageList.size();
    }

    public int getItemViewType(int position) {
        return Intrinsics.areEqual((Object)this.messageList.get(position).getSender_id(), (Object)"BOT") ? 0 : 1;
    }

    public final void add(@NotNull MessageViewModel message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageList.add(message);
        this.notifyDataSetChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/smh_digitalassistant_library/adapters/ChatAdapter$Companion;", "", "()V", "BOT", "", "USER", "SmH-DigitalAssistant-Library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/smh_digitalassistant_library/adapters/ChatAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/smh_digitalassistant_library/adapters/ChatAdapter;Landroid/view/View;)V", "cardView", "Landroidx/cardview/widget/CardView;", "messageTextView", "Landroid/widget/TextView;", "bind", "", "message", "Lcom/smh_digitalassistant_library/models/MessageViewModel;", "SmH-DigitalAssistant-Library_release"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextView messageTextView;
        @NotNull
        private final CardView cardView;

        public ViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)ChatAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.chat_message);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.chat_message)");
            this.messageTextView = (TextView)view;
            view = itemView.findViewById(R.id.card_chat_message);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.card_chat_message)");
            this.cardView = (CardView)view;
        }

        public final void bind(@NotNull MessageViewModel message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.messageTextView.setText((CharSequence)message.getMessage());
        }
    }
}

