/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.iq80.leveldb.env.DbLock;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.memenv.FileState;
import org.iq80.leveldb.memenv.MemFile;

class MemFs {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";
    private final Object lock = new Object();
    private final Set<MemFile> dirs = new HashSet<MemFile>();
    private final Map<MemFile, FileState> maps = new HashMap<MemFile, FileState>();

    MemFs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempDir(String prefix) {
        Object object = this.lock;
        synchronized (object) {
            String baseName;
            MemFile e;
            do {
                baseName = SEPARATOR;
                if (prefix == null) continue;
                baseName = baseName + prefix + "-";
            } while (this.maps.containsKey(e = MemFile.createMemFile(this, baseName = baseName + System.currentTimeMillis() + "-")) || !this.dirs.add(e));
            e.mkdirs();
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileState requireFile(MemFile file) throws FileNotFoundException {
        FileState fileState;
        Object object = this.lock;
        synchronized (object) {
            fileState = this.maps.get(file);
            if (fileState == null) {
                throw new FileNotFoundException(file.getPath());
            }
        }
        return fileState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileState getOrCreateFile(MemFile file) throws IOException {
        FileState fileState;
        Object object = this.lock;
        synchronized (object) {
            if (this.dirs.contains(file)) {
                throw new IOException(file + " is a directory");
            }
            if (!this.dirs.contains(file.getParentFile())) {
                throw new IOException("Unable to create file " + file + ", parent directory does not exist");
            }
            fileState = this.maps.computeIfAbsent(file, memFile -> new FileState());
        }
        return fileState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            if (this.maps.containsKey(memFile)) {
                return false;
            }
            this.dirs.add(memFile);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.maps.containsKey(memFile);
        }
    }

    public boolean isFile(MemFile memFile) {
        return this.canRead(memFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.dirs.contains(memFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<FileState> getFileState(MemFile file) {
        Object object = this.lock;
        synchronized (object) {
            return Optional.ofNullable(this.maps.get(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.maps.remove(memFile) != null || this.dirs.remove(memFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> listFiles(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.children(memFile).collect(Collectors.toList());
        }
    }

    private Stream<MemFile> children(MemFile memFile) {
        String s = memFile.getPath() + SEPARATOR;
        return Stream.concat(this.maps.keySet().stream(), this.dirs.stream()).filter(e -> e.getPath().startsWith(s)).map(e -> {
            int i = e.getPath().indexOf(SEPARATOR, s.length());
            return i >= 0 ? MemFile.createMemFile(this, e.getPath().substring(0, i)) : e;
        }).distinct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTo(MemFile from, MemFile dest) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDirectory(from)) {
                return false;
            }
            if (this.maps.containsKey(from) && !this.maps.containsKey(dest)) {
                this.maps.put(dest, this.maps.get(from));
                this.maps.remove(from);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRecursively(MemFile memFile) {
        String prefix = memFile.getPath() + SEPARATOR;
        Object object = this.lock;
        synchronized (object) {
            boolean r = false;
            Iterator<Object> iterator = this.dirs.iterator();
            while (iterator.hasNext()) {
                MemFile dir = iterator.next();
                if (!dir.equals(memFile) && !dir.getPath().startsWith(prefix)) continue;
                iterator.remove();
                r = true;
            }
            iterator = this.maps.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((MemFile)entry.getKey()).equals(memFile) && !((MemFile)entry.getKey()).getPath().startsWith(prefix)) continue;
                iterator.remove();
                r = true;
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(MemFile memFile) {
        Object object = this.lock;
        synchronized (object) {
            return this.dirs.contains(memFile) || this.maps.containsKey(memFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLock doLock(MemFile file) throws IOException {
        FileState orCreateFile;
        Object object = this.lock;
        synchronized (object) {
            orCreateFile = this.getOrCreateFile(file);
            if (orCreateFile.isLocked()) {
                throw new IOException("lock on " + file + " already owned");
            }
            orCreateFile.setLocked(true);
        }
        return new MemDbLock(orCreateFile);
    }

    private class MemDbLock
    implements DbLock {
        private final FileState file;
        private boolean released;

        public MemDbLock(FileState file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            Object object = MemFs.this.lock;
            synchronized (object) {
                return !this.released;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Object object = MemFs.this.lock;
            synchronized (object) {
                if (!this.released) {
                    this.released = true;
                    this.file.setLocked(false);
                }
            }
        }
    }
}

