/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.IOException;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.impl.LogChunkType;
import org.iq80.leveldb.impl.LogMonitor;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.util.DynamicSliceOutput;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class LogReader {
    private final SequentialFile sequentialFile;
    private final LogMonitor monitor;
    private final boolean verifyChecksums;
    private final long initialOffset;
    private boolean resyncing;
    private boolean eof;
    private long lastRecordOffset;
    private long endOfBufferOffset;
    private final DynamicSliceOutput recordScratch = new DynamicSliceOutput(32768);
    private final SliceOutput blockScratch = Slices.allocate(32768).output();
    private SliceInput currentBlock = Slices.EMPTY_SLICE.input();
    private Slice currentChunk = Slices.EMPTY_SLICE;

    public LogReader(SequentialFile sequentialFile, LogMonitor monitor, boolean verifyChecksums, long initialOffset) {
        this.sequentialFile = sequentialFile;
        this.monitor = monitor;
        this.verifyChecksums = verifyChecksums;
        this.initialOffset = initialOffset;
        this.resyncing = initialOffset > 0L;
    }

    public long getLastRecordOffset() {
        return this.lastRecordOffset;
    }

    private boolean skipToInitialBlock() {
        int offsetInBlock = (int)(this.initialOffset % 32768L);
        long blockStartLocation = this.initialOffset - (long)offsetInBlock;
        if (offsetInBlock > 32762) {
            blockStartLocation += 32768L;
        }
        this.endOfBufferOffset = blockStartLocation;
        if (blockStartLocation > 0L) {
            try {
                this.sequentialFile.skip(blockStartLocation);
            }
            catch (IOException e) {
                this.reportDrop(blockStartLocation, e);
                return false;
            }
        }
        return true;
    }

    public Slice readRecord() {
        this.recordScratch.reset();
        if (this.lastRecordOffset < this.initialOffset && !this.skipToInitialBlock()) {
            return null;
        }
        long prospectiveRecordOffset = 0L;
        boolean inFragmentedRecord = false;
        block8: while (true) {
            LogChunkType chunkType = this.readNextChunk();
            long physicalRecordOffset = this.endOfBufferOffset - (long)this.currentBlock.available() - 7L - (long)this.currentChunk.length();
            if (this.resyncing) {
                if (chunkType == LogChunkType.MIDDLE) continue;
                if (chunkType == LogChunkType.LAST) {
                    this.resyncing = false;
                    continue;
                }
                this.resyncing = false;
            }
            switch (chunkType) {
                case FULL: {
                    if (inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "partial record without end(1)");
                    }
                    this.recordScratch.reset();
                    this.lastRecordOffset = prospectiveRecordOffset = physicalRecordOffset;
                    return this.currentChunk.copySlice();
                }
                case FIRST: {
                    if (inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "partial record without end(2)");
                        this.recordScratch.reset();
                    }
                    prospectiveRecordOffset = physicalRecordOffset;
                    this.recordScratch.writeBytes(this.currentChunk);
                    inFragmentedRecord = true;
                    continue block8;
                }
                case MIDDLE: {
                    if (!inFragmentedRecord) {
                        this.reportCorruption(this.currentChunk.length(), "missing start of fragmented record(1)");
                        this.recordScratch.reset();
                        continue block8;
                    }
                    this.recordScratch.writeBytes(this.currentChunk);
                    continue block8;
                }
                case LAST: {
                    if (!inFragmentedRecord) {
                        this.reportCorruption(this.currentChunk.length(), "missing start of fragmented record(2)");
                        this.recordScratch.reset();
                        continue block8;
                    }
                    this.recordScratch.writeBytes(this.currentChunk);
                    this.lastRecordOffset = prospectiveRecordOffset;
                    return this.recordScratch.slice().copySlice();
                }
                case EOF: {
                    if (inFragmentedRecord) {
                        this.recordScratch.reset();
                    }
                    return null;
                }
                case BAD_CHUNK: {
                    if (!inFragmentedRecord) continue block8;
                    this.reportCorruption(this.recordScratch.size(), "error in middle of record");
                    inFragmentedRecord = false;
                    this.recordScratch.reset();
                    continue block8;
                }
            }
            int dropSize = this.currentChunk.length();
            if (inFragmentedRecord) {
                dropSize += this.recordScratch.size();
            }
            this.reportCorruption(dropSize, String.format("Unexpected chunk type %s", new Object[]{chunkType}));
            inFragmentedRecord = false;
            this.recordScratch.reset();
        }
    }

    private LogChunkType readNextChunk() {
        int actualChecksum;
        this.currentChunk = Slices.EMPTY_SLICE;
        if (this.currentBlock.available() < 7 && !this.readNextBlock() && this.eof) {
            return LogChunkType.EOF;
        }
        int expectedChecksum = this.currentBlock.readInt();
        int length = this.currentBlock.readUnsignedByte();
        byte chunkTypeId = this.currentBlock.readByte();
        LogChunkType chunkType = LogChunkType.getLogChunkTypeByPersistentId(chunkTypeId);
        if ((length |= this.currentBlock.readUnsignedByte() << 8) > this.currentBlock.available()) {
            if (!this.eof) {
                int dropSize = this.currentBlock.available() + 7;
                this.reportCorruption(dropSize, "bad record length");
                this.currentBlock = Slices.EMPTY_SLICE.input();
                return LogChunkType.BAD_CHUNK;
            }
            return LogChunkType.EOF;
        }
        if (chunkType == LogChunkType.ZERO_TYPE && length == 0) {
            this.currentBlock = Slices.EMPTY_SLICE.input();
            return LogChunkType.BAD_CHUNK;
        }
        if (this.endOfBufferOffset - 7L - (long)length < this.initialOffset) {
            this.currentBlock.skipBytes(length);
            return LogChunkType.BAD_CHUNK;
        }
        this.currentChunk = this.currentBlock.readBytes(length);
        if (this.verifyChecksums && (actualChecksum = Logs.getChunkChecksum(chunkTypeId, this.currentChunk)) != expectedChecksum) {
            int dropSize = this.currentBlock.available() + 7 + length;
            this.currentBlock = Slices.EMPTY_SLICE.input();
            this.reportCorruption(dropSize, "checksum mismatch");
            return LogChunkType.BAD_CHUNK;
        }
        if (this.endOfBufferOffset - (long)this.currentBlock.available() - 7L - (long)length < this.initialOffset) {
            this.currentChunk = Slices.EMPTY_SLICE;
            return LogChunkType.BAD_CHUNK;
        }
        if (chunkType == LogChunkType.UNKNOWN) {
            this.reportCorruption(length, "unknown record type");
            return LogChunkType.BAD_CHUNK;
        }
        return chunkType;
    }

    private boolean readNextBlock() {
        if (this.eof) {
            return false;
        }
        this.blockScratch.reset();
        int readSoFar = 0;
        while (this.blockScratch.writableBytes() > 0) {
            try {
                int bytesRead = this.sequentialFile.read(this.blockScratch.writableBytes(), this.blockScratch);
                if (bytesRead < 0) {
                    this.eof = true;
                    if (this.blockScratch.writableBytes() <= 0 || readSoFar >= 7) break;
                    this.currentBlock = Slices.EMPTY_SLICE.input();
                    return false;
                }
                readSoFar += bytesRead;
                this.endOfBufferOffset += (long)bytesRead;
            }
            catch (IOException e) {
                this.currentBlock = Slices.EMPTY_SLICE.input();
                this.reportDrop(32768L, e);
                this.eof = true;
                return false;
            }
        }
        this.currentBlock = this.blockScratch.slice().input();
        return this.currentBlock.isReadable();
    }

    private void reportCorruption(long bytes, String reason) {
        if (this.monitor != null) {
            this.monitor.corruption(bytes, reason);
        }
    }

    private void reportDrop(long bytes, Throwable reason) {
        if (this.monitor != null) {
            this.monitor.corruption(bytes, reason);
        }
    }
}

