/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.XFilterPolicy;
import org.iq80.leveldb.env.DbLock;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.NoOpLogger;
import org.iq80.leveldb.env.SequentialFile;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.InsertIntoHandler;
import org.iq80.leveldb.impl.InternalFilterPolicy;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.InternalUserComparator;
import org.iq80.leveldb.impl.LogMonitor;
import org.iq80.leveldb.impl.LogMonitors;
import org.iq80.leveldb.impl.LogReader;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.MemTable;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.SnapshotList;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueHolder;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.impl.Version;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.impl.VersionSet;
import org.iq80.leveldb.impl.WriteBatchImpl;
import org.iq80.leveldb.iterator.DBIteratorAdapter;
import org.iq80.leveldb.iterator.InternalIterator;
import org.iq80.leveldb.iterator.MemTableIterator;
import org.iq80.leveldb.iterator.MergingIterator;
import org.iq80.leveldb.iterator.SnapshotSeekingIterator;
import org.iq80.leveldb.table.BytewiseComparator;
import org.iq80.leveldb.table.CustomUserComparator;
import org.iq80.leveldb.table.FilterPolicy;
import org.iq80.leveldb.table.TableBuilder;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.Snappy;

public class DbImpl
implements DB {
    private final Options options;
    private final boolean ownsLogger;
    private final File databaseDir;
    private final TableCache tableCache;
    private final DbLock dbLock;
    private final VersionSet versions;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private final ReentrantLock mutex = new ReentrantLock();
    private final Condition backgroundCondition = this.mutex.newCondition();
    private final List<Long> pendingOutputs = new ArrayList<Long>();
    private final Deque<WriteBatchInternal> writers = new LinkedList<WriteBatchInternal>();
    private final SnapshotList snapshots = new SnapshotList(this.mutex);
    private final WriteBatchImpl tmpBatch = new WriteBatchImpl();
    private final Env env;
    private LogWriter log;
    private MemTable memTable;
    private volatile MemTable immutableMemTable;
    private final InternalKeyComparator internalKeyComparator;
    private volatile Throwable backgroundException;
    private final ExecutorService compactionExecutor;
    private Future<?> backgroundCompaction;
    private ManualCompaction manualCompaction;
    private CompactionStats[] stats = new CompactionStats[7];
    private final Object suspensionMutex = new Object();
    private int suspensionCounter;

    public DbImpl(Options rawOptions, String dbname, Env env) throws IOException {
        DBComparator comparator;
        this.env = env;
        Objects.requireNonNull(rawOptions, "options is null");
        Objects.requireNonNull(dbname, "databaseDir is null");
        File databaseDir = env.toFile(dbname);
        this.options = this.sanitizeOptions(databaseDir, rawOptions);
        boolean bl = this.ownsLogger = this.options.logger() != rawOptions.logger();
        if (this.options.compressionType() == CompressionType.SNAPPY && !Snappy.available()) {
            this.options.compressionType(CompressionType.NONE);
        }
        this.databaseDir = databaseDir;
        if (this.options.filterPolicy() != null) {
            Preconditions.checkArgument((boolean)(this.options.filterPolicy() instanceof FilterPolicy), (Object)"Filter policy must implement Java interface FilterPolicy");
            this.options.filterPolicy((XFilterPolicy)InternalFilterPolicy.convert(this.options.filterPolicy()));
        }
        UserComparator userComparator = (comparator = this.options.comparator()) != null ? new CustomUserComparator(comparator) : new BytewiseComparator();
        this.internalKeyComparator = new InternalKeyComparator(userComparator);
        this.immutableMemTable = null;
        ThreadFactory compactionThreadFactory = new ThreadFactoryBuilder().setNameFormat("leveldb-compaction-%s").setUncaughtExceptionHandler((t, e) -> {
            this.mutex.lock();
            try {
                if (this.backgroundException == null) {
                    this.backgroundException = e;
                }
                this.options.logger().log("Unexpected exception occurred %s", new Object[]{e});
            }
            finally {
                this.mutex.unlock();
            }
        }).build();
        this.compactionExecutor = Executors.newSingleThreadExecutor(compactionThreadFactory);
        int tableCacheSize = this.options.maxOpenFiles() - 10;
        this.tableCache = new TableCache(databaseDir, tableCacheSize, new InternalUserComparator(this.internalKeyComparator), this.options, env);
        databaseDir.mkdirs();
        Preconditions.checkArgument((boolean)databaseDir.exists(), (String)"Database directory '%s' does not exist and could not be created", (Object)databaseDir);
        Preconditions.checkArgument((boolean)databaseDir.isDirectory(), (String)"Database directory '%s' is not a directory", (Object)databaseDir);
        for (int i = 0; i < 7; ++i) {
            this.stats[i] = new CompactionStats();
        }
        this.mutex.lock();
        Closer c = Closer.create();
        boolean success = false;
        try {
            this.dbLock = env.tryLock(databaseDir.child(Filename.lockFileName()));
            c.register(this.dbLock::release);
            File currentFile = databaseDir.child(Filename.currentFileName());
            if (!currentFile.canRead()) {
                Preconditions.checkArgument((boolean)this.options.createIfMissing(), (String)"Database '%s' does not exist and the create if missing option is disabled", (Object)databaseDir);
            } else {
                Preconditions.checkArgument((!this.options.errorIfExists() ? 1 : 0) != 0, (String)"Database '%s' exists and the error if exists option is enabled", (Object)databaseDir);
            }
            this.versions = new VersionSet(this.options, databaseDir, this.tableCache, this.internalKeyComparator, env);
            c.register(this.versions::release);
            boolean saveManifest = this.versions.recover();
            long minLogNumber = this.versions.getLogNumber();
            long previousLogNumber = this.versions.getPrevLogNumber();
            Set expected = this.versions.getLiveFiles().stream().map(FileMetaData::getNumber).collect(Collectors.toSet());
            List<File> filenames = databaseDir.listFiles();
            ArrayList<Long> logs = new ArrayList<Long>();
            for (File filename : filenames) {
                Filename.FileInfo fileInfo = Filename.parseFileName(filename);
                if (fileInfo == null) continue;
                expected.remove(fileInfo.getFileNumber());
                if (fileInfo.getFileType() != Filename.FileType.LOG || fileInfo.getFileNumber() < minLogNumber && fileInfo.getFileNumber() != previousLogNumber) continue;
                logs.add(fileInfo.getFileNumber());
            }
            Preconditions.checkArgument((boolean)expected.isEmpty(), (String)"%s missing files", (int)expected.size());
            VersionEdit edit = new VersionEdit();
            Collections.sort(logs);
            Iterator iterator = logs.iterator();
            while (iterator.hasNext()) {
                Long fileNumber = (Long)iterator.next();
                RecoverResult result = this.recoverLogFile(fileNumber, !iterator.hasNext(), edit);
                saveManifest |= result.saveManifest;
                this.versions.markFileNumberUsed(fileNumber);
                if (this.versions.getLastSequence() >= result.maxSequence) continue;
                this.versions.setLastSequence(result.maxSequence);
            }
            if (this.memTable == null) {
                long logFileNumber = this.versions.getNextFileNumber();
                this.log = Logs.createLogWriter(databaseDir.child(Filename.logFileName(logFileNumber)), logFileNumber, env);
                c.register((Closeable)this.log);
                edit.setLogNumber(this.log.getFileNumber());
                this.memTable = new MemTable(this.internalKeyComparator);
            }
            if (saveManifest) {
                edit.setPreviousLogNumber(0L);
                edit.setLogNumber(this.log.getFileNumber());
                this.versions.logAndApply(edit, this.mutex);
            }
            this.deleteObsoleteFiles();
            this.maybeScheduleCompaction();
            success = true;
        }
        catch (Throwable e2) {
            throw c.rethrow(e2);
        }
        finally {
            if (!success) {
                if (this.ownsLogger) {
                    c.register((Closeable)this.options.logger());
                }
                c.close();
            }
            this.mutex.unlock();
        }
    }

    private static <T extends Comparable<T>> T clipToRange(T in, T min, T max) {
        if (in.compareTo(min) < 0) {
            return min;
        }
        if (in.compareTo(max) > 0) {
            return max;
        }
        return in;
    }

    private Options sanitizeOptions(File databaseDir, Options src) throws IOException {
        Options result = Options.fromOptions((Options)src);
        result.maxOpenFiles(DbImpl.clipToRange(src.maxOpenFiles(), 74, 50000).intValue());
        result.writeBufferSize(DbImpl.clipToRange(src.writeBufferSize(), 65536, 0x40000000).intValue());
        result.maxFileSize(DbImpl.clipToRange(src.maxFileSize(), 0x100000, 0x40000000).intValue());
        result.blockSize(DbImpl.clipToRange(src.blockSize(), 1024, 0x400000).intValue());
        if (result.logger() == null && databaseDir != null && (databaseDir.isDirectory() || databaseDir.mkdirs())) {
            File file = databaseDir.child(Filename.infoLogFileName());
            file.renameTo(databaseDir.child(Filename.oldInfoLogFileName()));
            result.logger(this.env.newLogger(file));
        }
        if (result.logger() == null) {
            result.logger((Logger)new NoOpLogger());
        }
        return result;
    }

    @VisibleForTesting
    void invalidateAllCaches() {
        this.mutex.lock();
        try {
            while (this.backgroundCompaction != null && this.backgroundException == null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
            this.tableCache.invalidateAll();
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void close() {
        if (this.shuttingDown.getAndSet(true)) {
            return;
        }
        this.mutex.lock();
        try {
            while (this.backgroundCompaction != null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mutex.unlock();
        }
        this.compactionExecutor.shutdown();
        try {
            this.compactionExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.versions.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.log.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tableCache.close();
        if (this.ownsLogger) {
            Closeables.closeQuietly((Closeable)this.options.logger());
        }
        this.dbLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        if (!name.startsWith("leveldb.")) {
            return null;
        }
        String key = name.substring("leveldb.".length());
        this.mutex.lock();
        try {
            Matcher matcher = Pattern.compile("num-files-at-level(\\d+)").matcher(key);
            if (matcher.matches()) {
                int level = Integer.parseInt(matcher.group(1));
                String string = String.valueOf(this.versions.numberOfFilesInLevel(level));
                return string;
            }
            matcher = Pattern.compile("stats").matcher(key);
            if (matcher.matches()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("                               Compactions\n");
                stringBuilder.append("Level  Files Size(MB) Time(sec) Read(MB) Write(MB)\n");
                stringBuilder.append("--------------------------------------------------\n");
                for (int level = 0; level < 7; ++level) {
                    int files = this.versions.numberOfFilesInLevel(level);
                    if (this.stats[level].micros <= 0L && files <= 0) continue;
                    stringBuilder.append(String.format("%3d %8d %8.0f %9.0f %8.0f %9.0f%n", level, files, (double)this.versions.numberOfBytesInLevel(level) / 1048576.0, (double)this.stats[level].micros / 1000000.0, (double)this.stats[level].bytesRead / 1048576.0, (double)this.stats[level].bytesWritten / 1048576.0));
                }
                String string = stringBuilder.toString();
                return string;
            }
            if ("sstables".equals(key)) {
                String stringBuilder = this.versions.getCurrent().toString();
                return stringBuilder;
            }
            if ("approximate-memory-usage".equals(key)) {
                long sizeTotal = this.tableCache.getApproximateMemoryUsage();
                if (this.memTable != null) {
                    sizeTotal += this.memTable.approximateMemoryUsage();
                }
                if (this.immutableMemTable != null) {
                    sizeTotal += this.immutableMemTable.approximateMemoryUsage();
                }
                String string = Long.toUnsignedString(sizeTotal);
                return string;
            }
        }
        finally {
            this.mutex.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteObsoleteFiles() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (this.backgroundException != null) {
            return;
        }
        ArrayList<Long> live = new ArrayList<Long>(this.pendingOutputs);
        for (FileMetaData fileMetaData : this.versions.getLiveFiles()) {
            live.add(fileMetaData.getNumber());
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        for (File file : this.databaseDir.listFiles()) {
            Filename.FileInfo fileInfo = Filename.parseFileName(file);
            if (fileInfo == null) continue;
            long number = fileInfo.getFileNumber();
            boolean keep = true;
            switch (fileInfo.getFileType()) {
                case LOG: {
                    keep = number >= this.versions.getLogNumber() || number == this.versions.getPrevLogNumber();
                    break;
                }
                case DESCRIPTOR: {
                    keep = number >= this.versions.getManifestFileNumber();
                    break;
                }
                case TABLE: {
                    keep = live.contains(number);
                    break;
                }
                case TEMP: {
                    keep = live.contains(number);
                    break;
                }
                case CURRENT: 
                case DB_LOCK: 
                case INFO_LOG: {
                    keep = true;
                }
            }
            if (keep) continue;
            if (fileInfo.getFileType() == Filename.FileType.TABLE) {
                this.tableCache.evict(number);
            }
            this.options.logger().log("Delete type=%s #%s", new Object[]{fileInfo.getFileType(), number});
            filesToDelete.add(file);
        }
        this.mutex.unlock();
        try {
            filesToDelete.forEach(File::delete);
        }
        finally {
            this.mutex.lock();
        }
    }

    private void maybeScheduleCompaction() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (this.backgroundCompaction == null && !this.shuttingDown.get() && this.backgroundException == null && (this.immutableMemTable != null || this.manualCompaction != null || this.versions.needsCompaction())) {
            this.backgroundCompaction = this.compactionExecutor.submit(this::backgroundCall);
        }
    }

    private void checkBackgroundException() {
        Throwable e = this.backgroundException;
        if (e != null) {
            throw new BackgroundProcessingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundCall() {
        this.mutex.lock();
        try {
            Preconditions.checkState((this.backgroundCompaction != null ? 1 : 0) != 0, (Object)"Compaction was not correctly scheduled");
            try {
                if (!this.shuttingDown.get() && this.backgroundException == null) {
                    this.backgroundCompaction();
                }
            }
            finally {
                this.backgroundCompaction = null;
            }
            this.maybeScheduleCompaction();
        }
        catch (DatabaseShutdownException databaseShutdownException) {
            try {
                this.backgroundCondition.signalAll();
            }
            finally {
                this.mutex.unlock();
            }
        }
        catch (Throwable throwable) {
            this.recordBackgroundError(throwable);
        }
        finally {
            try {
                this.backgroundCondition.signalAll();
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundCompaction() throws IOException {
        Compaction compaction;
        ManualCompaction m;
        boolean isManual;
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (this.immutableMemTable != null) {
            this.compactMemTable();
            return;
        }
        InternalKey manualEnd = null;
        boolean bl = isManual = this.manualCompaction != null;
        if (isManual) {
            compaction = this.versions.compactRange((m = this.manualCompaction).level, m.begin, m.end);
            m.done = compaction == null;
            if (compaction != null) {
                manualEnd = compaction.input(0, compaction.getLevelInputs().size() - 1).getLargest();
            }
            this.options.logger().log("Manual compaction at level-%s from %s .. %s; will stop at %s", new Object[]{m.level, m.begin != null ? m.begin.toString() : "(begin)", m.end != null ? m.end.toString() : "(end)", m.done ? "(end)" : manualEnd});
        } else {
            compaction = this.versions.pickCompaction();
        }
        if (compaction != null) {
            if (!isManual && compaction.isTrivialMove()) {
                Preconditions.checkState((compaction.getLevelInputs().size() == 1 ? 1 : 0) != 0);
                FileMetaData fileMetaData = compaction.getLevelInputs().get(0);
                compaction.getEdit().deleteFile(compaction.getLevel(), fileMetaData.getNumber());
                compaction.getEdit().addFile(compaction.getLevel() + 1, fileMetaData);
                this.versions.logAndApply(compaction.getEdit(), this.mutex);
                this.options.logger().log("Moved #%s to level-%s %s bytes: %s", new Object[]{fileMetaData.getNumber(), compaction.getLevel() + 1, fileMetaData.getFileSize(), this.versions.levelSummary()});
            } else {
                CompactionState compactionState = new CompactionState(compaction);
                try {
                    this.doCompactionWork(compactionState);
                }
                catch (Exception e) {
                    this.options.logger().log("Compaction error: %s", new Object[]{e.getMessage()});
                    this.recordBackgroundError(e);
                }
                finally {
                    this.cleanupCompaction(compactionState);
                    compaction.close();
                    this.deleteObsoleteFiles();
                }
            }
        }
        if (compaction != null) {
            compaction.close();
        }
        if (isManual) {
            m = this.manualCompaction;
            if (this.backgroundException != null) {
                m.done = true;
            }
            if (!m.done) {
                m.begin = manualEnd;
            }
            this.manualCompaction = null;
        }
    }

    private void recordBackgroundError(Throwable e) {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Throwable backgroundException = this.backgroundException;
        if (backgroundException == null) {
            this.backgroundException = e;
            this.backgroundCondition.signalAll();
        }
        Throwables.throwIfInstanceOf((Throwable)e, Error.class);
    }

    private void cleanupCompaction(CompactionState compactionState) throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (compactionState.builder != null) {
            compactionState.builder.abandon();
            compactionState.builder = null;
        }
        if (compactionState.outfile != null) {
            compactionState.outfile.force();
            compactionState.outfile.close();
            compactionState.outfile = null;
        }
        for (FileMetaData output : compactionState.outputs) {
            this.pendingOutputs.remove(output.getNumber());
        }
    }

    private RecoverResult recoverLogFile(long fileNumber, boolean lastLog, VersionEdit edit) throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        File file = this.databaseDir.child(Filename.logFileName(fileNumber));
        try (SequentialFile in = this.env.newSequentialFile(file);){
            LogMonitor logMonitor = LogMonitors.logMonitor(this.options.logger());
            LogReader logReader = new LogReader(in, logMonitor, true, 0L);
            this.options.logger().log("Recovering log #%s", new Object[]{fileNumber});
            long maxSequence = 0L;
            int compactions = 0;
            boolean saveManifest = false;
            MemTable mem = null;
            Slice record = logReader.readRecord();
            while (record != null) {
                SliceInput sliceInput = record.input();
                if (sliceInput.available() < 12) {
                    logMonitor.corruption((long)sliceInput.available(), "log record too small");
                } else {
                    long sequenceBegin = sliceInput.readLong();
                    int updateSize = sliceInput.readInt();
                    try (WriteBatchImpl writeBatch = this.readWriteBatch(sliceInput, updateSize);){
                        if (mem == null) {
                            mem = new MemTable(this.internalKeyComparator);
                        }
                        writeBatch.forEach(new InsertIntoHandler(mem, sequenceBegin));
                    }
                    catch (Exception e) {
                        if (!this.options.paranoidChecks()) {
                            this.options.logger().log("Ignoring error %s", new Object[]{e});
                        }
                        Throwables.propagateIfPossible((Throwable)e, IOException.class);
                        throw new IOException(e);
                    }
                    long lastSequence = sequenceBegin + (long)updateSize - 1L;
                    if (lastSequence > maxSequence) {
                        maxSequence = lastSequence;
                    }
                    if (mem.approximateMemoryUsage() > (long)this.options.writeBufferSize()) {
                        ++compactions;
                        saveManifest = true;
                        this.writeLevel0Table(mem, edit, null);
                        mem = null;
                    }
                }
                record = logReader.readRecord();
            }
            if (this.options.reuseLogs() && lastLog && compactions == 0) {
                Preconditions.checkState((this.log == null ? 1 : 0) != 0);
                Preconditions.checkState((this.memTable == null ? 1 : 0) != 0);
                long originalSize = file.length();
                WritableFile writableFile = this.env.newAppendableFile(file);
                this.options.logger().log("Reusing old log %s", new Object[]{file});
                this.log = Logs.createLogWriter(fileNumber, writableFile, originalSize);
                if (mem != null) {
                    this.memTable = mem;
                    mem = null;
                } else {
                    this.memTable = new MemTable(this.internalKeyComparator);
                }
            }
            if (mem != null && !mem.isEmpty()) {
                saveManifest = true;
                this.writeLevel0Table(mem, edit, null);
            }
            RecoverResult recoverResult = new RecoverResult(maxSequence, saveManifest);
            return recoverResult;
        }
    }

    public byte[] get(byte[] key) throws DBException {
        return this.get(key, new ReadOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key, ReadOptions options) throws DBException {
        Slice value;
        LookupResult lookupResult;
        this.mutex.lock();
        try {
            long lastSequence = options.snapshot() != null ? this.snapshots.getSequenceFrom(options.snapshot()) : this.versions.getLastSequence();
            LookupKey lookupKey = new LookupKey(Slices.wrappedBuffer(key), lastSequence);
            MemTable memTable = this.memTable;
            MemTable immutableMemTable = this.immutableMemTable;
            Version current = this.versions.getCurrent();
            current.retain();
            ReadStats readStats = null;
            this.mutex.unlock();
            try {
                lookupResult = memTable.get(lookupKey);
                if (lookupResult == null && immutableMemTable != null) {
                    lookupResult = immutableMemTable.get(lookupKey);
                }
                if (lookupResult == null) {
                    readStats = new ReadStats();
                    lookupResult = current.get(options, lookupKey, readStats);
                }
            }
            finally {
                this.mutex.lock();
                if (readStats != null && current.updateStats(readStats)) {
                    this.maybeScheduleCompaction();
                }
                current.release();
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (lookupResult != null && (value = lookupResult.getValue()) != null) {
            return value.getBytes();
        }
        return null;
    }

    public void put(byte[] key, byte[] value) throws DBException {
        this.put(key, value, new WriteOptions());
    }

    public Snapshot put(byte[] key, byte[] value, WriteOptions options) throws DBException {
        try (WriteBatchImpl writeBatch = new WriteBatchImpl();){
            Snapshot snapshot = this.writeInternal(writeBatch.put(key, value), options);
            return snapshot;
        }
    }

    public void delete(byte[] key) throws DBException {
        this.delete(key, new WriteOptions());
    }

    public Snapshot delete(byte[] key, WriteOptions options) throws DBException {
        try (WriteBatchImpl writeBatch = new WriteBatchImpl();){
            Snapshot snapshot = this.writeInternal(writeBatch.delete(key), options);
            return snapshot;
        }
    }

    public void write(WriteBatch updates) throws DBException {
        this.writeInternal((WriteBatchImpl)updates, new WriteOptions());
    }

    public Snapshot write(WriteBatch updates, WriteOptions options) throws DBException {
        return this.writeInternal((WriteBatchImpl)updates, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot writeInternal(WriteBatchImpl myBatch, WriteOptions options) throws DBException {
        this.checkBackgroundException();
        WriteBatchInternal w = new WriteBatchInternal(myBatch, options.sync(), this.mutex.newCondition());
        this.mutex.lock();
        try {
            WriteBatchInternal ready;
            this.writers.offerLast(w);
            while (!w.done && this.writers.peekFirst() != w) {
                w.backgroundCondition.awaitUninterruptibly();
            }
            if (w.done) {
                w.checkExceptions();
                Snapshot snapshot = options.snapshot() ? this.snapshots.newSnapshot(this.versions.getLastSequence()) : null;
                return snapshot;
            }
            ValueHolder<WriteBatchInternal> lastWriterVh = new ValueHolder<WriteBatchInternal>(w);
            Exception error = null;
            try {
                this.multipleWriteGroup(myBatch, options, lastWriterVh);
            }
            catch (Exception e) {
                error = e;
            }
            WriteBatchInternal lastWrite = lastWriterVh.getValue();
            do {
                ready = this.writers.peekFirst();
                this.writers.pollFirst();
                if (ready == w) continue;
                ready.error = error;
                ready.done = true;
                ready.signal();
            } while (ready != lastWrite);
            if (!this.writers.isEmpty()) {
                this.writers.peekFirst().signal();
            }
            this.checkBackgroundException();
            if (error != null) {
                Throwables.propagateIfPossible((Throwable)error, DBException.class);
                throw new DBException((Throwable)error);
            }
            Snapshot snapshot = options.snapshot() ? this.snapshots.newSnapshot(this.versions.getLastSequence()) : null;
            return snapshot;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multipleWriteGroup(WriteBatchImpl myBatch, WriteOptions options, ValueHolder<WriteBatchInternal> lastWriter) {
        WriteBatchImpl updates = null;
        this.makeRoomForWrite(myBatch == null);
        if (myBatch != null) {
            updates = this.buildBatchGroup(lastWriter);
            long sequenceBegin = this.versions.getLastSequence() + 1L;
            long sequenceEnd = sequenceBegin + (long)updates.size() - 1L;
            this.mutex.unlock();
            try {
                Slice record = DbImpl.writeWriteBatch(updates, sequenceBegin);
                this.log.addRecord(record, options.sync());
                updates.forEach(new InsertIntoHandler(this.memTable, sequenceBegin));
            }
            catch (Exception e) {
                this.mutex.lock();
                try {
                    this.recordBackgroundError(e);
                }
                finally {
                    this.mutex.unlock();
                }
            }
            finally {
                this.mutex.lock();
            }
            if (updates == this.tmpBatch) {
                this.tmpBatch.clear();
            }
            this.versions.setLastSequence(sequenceEnd);
        }
    }

    private WriteBatchImpl buildBatchGroup(ValueHolder<WriteBatchInternal> lastWriter) {
        Preconditions.checkArgument((!this.writers.isEmpty() ? 1 : 0) != 0, (Object)"A least one writer is required");
        WriteBatchInternal first = this.writers.peekFirst();
        WriteBatchImpl result = first.batch;
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"Batch must be non null");
        int sizeInit = first.batch.getApproximateSize();
        int maxSize = 0x100000;
        if (sizeInit <= 131072) {
            maxSize = sizeInit + 131072;
        }
        int size = 0;
        lastWriter.setValue(first);
        for (WriteBatchInternal w : this.writers) {
            if (w.sync && !lastWriter.getValue().sync) break;
            if (w.batch != null) {
                if ((size += w.batch.getApproximateSize()) > maxSize) break;
                if (result == first.batch) {
                    result = this.tmpBatch;
                    Preconditions.checkState((result.size() == 0 ? 1 : 0) != 0, (Object)"Temp batch should be clean");
                    result.append(first.batch);
                } else if (first.batch != w.batch) {
                    result.append(w.batch);
                }
            }
            lastWriter.setValue(w);
        }
        return result;
    }

    public WriteBatch createWriteBatch() {
        this.checkBackgroundException();
        return new WriteBatchImpl();
    }

    public DBIteratorAdapter iterator() {
        return this.iterator(new ReadOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBIteratorAdapter iterator(ReadOptions options) {
        this.mutex.lock();
        try {
            InternalIterator rawIterator = this.internalIterator(options);
            long snapshot = this.getSnapshot(options);
            SnapshotSeekingIterator snapshotIterator = new SnapshotSeekingIterator(rawIterator, snapshot, this.internalKeyComparator.getUserComparator(), new RecordBytesListener());
            DBIteratorAdapter dBIteratorAdapter = new DBIteratorAdapter(snapshotIterator);
            return dBIteratorAdapter;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    InternalIterator internalIterator(ReadOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void recordReadSample(InternalKey key) {
        this.mutex.lock();
        try {
            if (this.versions.getCurrent().recordReadSample(key)) {
                this.maybeScheduleCompaction();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Snapshot getSnapshot() {
        this.checkBackgroundException();
        this.mutex.lock();
        try {
            Snapshot snapshot = this.snapshots.newSnapshot(this.versions.getLastSequence());
            return snapshot;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private long getSnapshot(ReadOptions options) {
        long snapshot = options.snapshot() != null ? this.snapshots.getSequenceFrom(options.snapshot()) : this.versions.getLastSequence();
        return snapshot;
    }

    private void makeRoomForWrite(boolean force) {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Preconditions.checkState((!this.writers.isEmpty() ? 1 : 0) != 0);
        boolean allowDelay = !force;
        while (true) {
            this.checkBackgroundException();
            if (allowDelay && this.versions.numberOfFilesInLevel(0) > 8) {
                try {
                    this.mutex.unlock();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new DBException((Throwable)e);
                }
                finally {
                    this.mutex.lock();
                }
                allowDelay = false;
                continue;
            }
            if (!force && this.memTable.approximateMemoryUsage() <= (long)this.options.writeBufferSize()) break;
            if (this.immutableMemTable != null) {
                this.options.logger().log("Current memtable full; waiting...");
                this.backgroundCondition.awaitUninterruptibly();
                continue;
            }
            if (this.versions.numberOfFilesInLevel(0) >= 12) {
                this.options.logger().log("Too many L0 files; waiting...");
                this.backgroundCondition.awaitUninterruptibly();
                continue;
            }
            Preconditions.checkState((this.versions.getPrevLogNumber() == 0L ? 1 : 0) != 0);
            try {
                this.log.close();
            }
            catch (IOException e) {
                throw new DBException("Unable to close log file " + this.log, (Throwable)e);
            }
            long logNumber = this.versions.getNextFileNumber();
            try {
                this.log = Logs.createLogWriter(this.databaseDir.child(Filename.logFileName(logNumber)), logNumber, this.env);
            }
            catch (IOException e) {
                throw new DBException("Unable to open new log file " + this.databaseDir.child(Filename.logFileName(logNumber)).getPath(), (Throwable)e);
            }
            this.immutableMemTable = this.memTable;
            this.memTable = new MemTable(this.internalKeyComparator);
            force = false;
            this.maybeScheduleCompaction();
        }
    }

    private void compactMemTable() throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Preconditions.checkState((this.immutableMemTable != null ? 1 : 0) != 0);
        try {
            VersionEdit edit = new VersionEdit();
            Version base = this.versions.getCurrent();
            base.retain();
            this.writeLevel0Table(this.immutableMemTable, edit, base);
            base.release();
            if (this.shuttingDown.get()) {
                throw new DatabaseShutdownException("Database shutdown during memtable compaction");
            }
            edit.setPreviousLogNumber(0L);
            edit.setLogNumber(this.log.getFileNumber());
            this.versions.logAndApply(edit, this.mutex);
            this.immutableMemTable = null;
            this.deleteObsoleteFiles();
        }
        finally {
            this.backgroundCondition.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLevel0Table(MemTable mem, VersionEdit edit, Version base) throws IOException {
        FileMetaData meta;
        long startMicros = this.env.nowMicros();
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (mem.isEmpty()) {
            return;
        }
        long fileNumber = this.versions.getNextFileNumber();
        this.pendingOutputs.add(fileNumber);
        this.options.logger().log("Level-0 table #%s: started", new Object[]{fileNumber});
        this.mutex.unlock();
        try {
            meta = this.buildTable(mem, fileNumber);
        }
        finally {
            this.mutex.lock();
        }
        this.options.logger().log("Level-0 table #%s: %s bytes", new Object[]{meta.getNumber(), meta.getFileSize()});
        this.pendingOutputs.remove(fileNumber);
        int level = 0;
        if (meta.getFileSize() > 0L) {
            Slice minUserKey = meta.getSmallest().getUserKey();
            Slice maxUserKey = meta.getLargest().getUserKey();
            if (base != null) {
                level = base.pickLevelForMemTableOutput(minUserKey, maxUserKey);
            }
            edit.addFile(level, meta);
        }
        this.stats[level].add(this.env.nowMicros() - startMicros, 0L, meta.getFileSize());
    }

    private FileMetaData buildTable(MemTable data, long fileNumber) throws IOException {
        File file = this.databaseDir.child(Filename.tableFileName(fileNumber));
        try {
            InternalKey smallest = null;
            InternalKey largest = null;
            try (WritableFile writableFile = this.env.newWritableFile(file);){
                TableBuilder tableBuilder = new TableBuilder(this.options, writableFile, new InternalUserComparator(this.internalKeyComparator));
                try (MemTableIterator it = data.iterator();){
                    boolean valid = it.seekToFirst();
                    while (valid) {
                        InternalKey key = (InternalKey)it.key();
                        if (smallest == null) {
                            smallest = key;
                        }
                        largest = key;
                        tableBuilder.add(key.encode(), (Slice)it.value());
                        valid = it.next();
                    }
                }
                tableBuilder.finish();
                writableFile.force();
            }
            if (smallest == null) {
                file.delete();
                return new FileMetaData(fileNumber, 0L, null, null);
            }
            FileMetaData fileMetaData = new FileMetaData(fileNumber, file.length(), smallest, largest);
            this.tableCache.newIterator(fileMetaData, new ReadOptions()).close();
            return fileMetaData;
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompactionWork(CompactionState compactionState) throws IOException {
        long startMicros = this.env.nowMicros();
        long immMicros = 0L;
        this.options.logger().log("Compacting %s@%s + %s@%s files", new Object[]{compactionState.compaction.input(0).size(), compactionState.compaction.getLevel(), compactionState.compaction.input(1).size(), compactionState.compaction.getLevel() + 1});
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Preconditions.checkArgument((this.versions.numberOfBytesInLevel(compactionState.getCompaction().getLevel()) > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.builder == null ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.outfile == null ? 1 : 0) != 0);
        compactionState.smallestSnapshot = this.snapshots.isEmpty() ? this.versions.getLastSequence() : this.snapshots.getOldest();
        MergingIterator mergingIterator = this.versions.makeInputIterator(compactionState.compaction);
        this.mutex.unlock();
        try (MergingIterator iterator = mergingIterator;){
            Slice currentUserKey = null;
            boolean hasCurrentUserKey = false;
            long lastSequenceForKey = 0xFFFFFFFFFFFFFFL;
            boolean valid = iterator.seekToFirst();
            while (valid && !this.shuttingDown.get()) {
                if (this.immutableMemTable != null) {
                    long immStart = this.env.nowMicros();
                    this.mutex.lock();
                    try {
                        this.compactMemTable();
                    }
                    finally {
                        this.mutex.unlock();
                    }
                    immMicros += this.env.nowMicros() - immStart;
                }
                InternalKey key = (InternalKey)iterator.key();
                if (compactionState.compaction.shouldStopBefore(key) && compactionState.builder != null) {
                    this.finishCompactionOutputFile(compactionState);
                }
                boolean drop = false;
                if (!hasCurrentUserKey || this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), currentUserKey) != 0) {
                    currentUserKey = key.getUserKey();
                    hasCurrentUserKey = true;
                    lastSequenceForKey = 0xFFFFFFFFFFFFFFL;
                }
                if (lastSequenceForKey <= compactionState.smallestSnapshot) {
                    drop = true;
                } else if (key.getValueType() == ValueType.DELETION && key.getSequenceNumber() <= compactionState.smallestSnapshot && compactionState.compaction.isBaseLevelForKey(key.getUserKey())) {
                    drop = true;
                }
                lastSequenceForKey = key.getSequenceNumber();
                if (!drop) {
                    if (compactionState.builder == null) {
                        this.openCompactionOutputFile(compactionState);
                    }
                    if (compactionState.builder.getEntryCount() == 0L) {
                        compactionState.currentSmallest = key;
                    }
                    compactionState.currentLargest = key;
                    compactionState.builder.add(key.encode(), (Slice)iterator.value());
                    if (compactionState.builder.getFileSize() >= compactionState.compaction.getMaxOutputFileSize()) {
                        this.finishCompactionOutputFile(compactionState);
                    }
                }
                valid = iterator.next();
            }
            if (this.shuttingDown.get()) {
                throw new DatabaseShutdownException("DB shutdown during compaction");
            }
            if (compactionState.builder != null) {
                this.finishCompactionOutputFile(compactionState);
            }
        }
        finally {
            long micros = this.env.nowMicros() - startMicros - immMicros;
            long bytesRead = 0L;
            for (int which = 0; which < 2; ++which) {
                for (int i = 0; i < compactionState.compaction.input(which).size(); ++i) {
                    bytesRead += compactionState.compaction.input(which, i).getFileSize();
                }
            }
            long bytesWritten = 0L;
            for (int i = 0; i < compactionState.outputs.size(); ++i) {
                bytesWritten += ((FileMetaData)compactionState.outputs.get(i)).getFileSize();
            }
            this.mutex.lock();
            this.stats[compactionState.compaction.getLevel() + 1].add(micros, bytesRead, bytesWritten);
        }
        this.installCompactionResults(compactionState);
        this.options.logger().log("compacted to: %s", new Object[]{this.versions.levelSummary()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCompactionOutputFile(CompactionState compactionState) throws IOException {
        long fileNumber;
        Objects.requireNonNull(compactionState, "compactionState is null");
        Preconditions.checkArgument((compactionState.builder == null ? 1 : 0) != 0, (Object)"compactionState builder is not null");
        this.mutex.lock();
        try {
            fileNumber = this.versions.getNextFileNumber();
            this.pendingOutputs.add(fileNumber);
            compactionState.currentFileNumber = fileNumber;
            compactionState.currentFileSize = 0L;
            compactionState.currentSmallest = null;
            compactionState.currentLargest = null;
        }
        finally {
            this.mutex.unlock();
        }
        File file = this.databaseDir.child(Filename.tableFileName(fileNumber));
        compactionState.outfile = this.env.newWritableFile(file);
        compactionState.builder = new TableBuilder(this.options, compactionState.outfile, new InternalUserComparator(this.internalKeyComparator));
    }

    private void finishCompactionOutputFile(CompactionState compactionState) throws IOException {
        Objects.requireNonNull(compactionState, "compactionState is null");
        Preconditions.checkArgument((compactionState.outfile != null ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.builder != null ? 1 : 0) != 0);
        long outputNumber = compactionState.currentFileNumber;
        Preconditions.checkArgument((outputNumber != 0L ? 1 : 0) != 0);
        long currentEntries = compactionState.builder.getEntryCount();
        compactionState.builder.finish();
        long currentBytes = compactionState.builder.getFileSize();
        compactionState.currentFileSize = currentBytes;
        CompactionState compactionState2 = compactionState;
        compactionState2.totalBytes = compactionState2.totalBytes + currentBytes;
        FileMetaData currentFileMetaData = new FileMetaData(compactionState.currentFileNumber, compactionState.currentFileSize, compactionState.currentSmallest, compactionState.currentLargest);
        compactionState.outputs.add(currentFileMetaData);
        compactionState.builder = null;
        compactionState.outfile.force();
        compactionState.outfile.close();
        compactionState.outfile = null;
        if (currentEntries > 0L) {
            this.tableCache.newIterator(outputNumber, new ReadOptions()).close();
            this.options.logger().log("Generated table #%s@%s: %s keys, %s bytes", new Object[]{outputNumber, compactionState.compaction.getLevel(), currentEntries, currentBytes});
        }
    }

    private void installCompactionResults(CompactionState compact) throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        this.options.logger().log("Compacted %s@%s + %s@%s files => %s bytes", new Object[]{compact.compaction.input(0).size(), compact.compaction.getLevel(), compact.compaction.input(1).size(), compact.compaction.getLevel() + 1, compact.totalBytes});
        compact.compaction.addInputDeletions(compact.compaction.getEdit());
        int level = compact.compaction.getLevel();
        for (FileMetaData output : compact.outputs) {
            compact.compaction.getEdit().addFile(level + 1, output);
            this.pendingOutputs.remove(output.getNumber());
        }
        this.versions.logAndApply(compact.compaction.getEdit(), this.mutex);
    }

    @VisibleForTesting
    int numberOfFilesInLevel(int level) {
        Version v;
        this.mutex.lock();
        try {
            v = this.versions.getCurrent();
        }
        finally {
            this.mutex.unlock();
        }
        return v.numberOfFilesInLevel(level);
    }

    public long[] getApproximateSizes(Range ... ranges) {
        Objects.requireNonNull(ranges, "ranges is null");
        long[] sizes = new long[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            Range range = ranges[i];
            sizes[i] = this.getApproximateSizes(range);
        }
        return sizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateSizes(Range range) {
        this.mutex.lock();
        try {
            Version v = this.versions.getCurrent();
            v.retain();
            try {
                InternalKey startKey = new InternalKey(Slices.wrappedBuffer(range.start()), 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
                InternalKey limitKey = new InternalKey(Slices.wrappedBuffer(range.limit()), 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
                long startOffset = v.getApproximateOffsetOf(startKey);
                long limitOffset = v.getApproximateOffsetOf(limitKey);
                long l = limitOffset >= startOffset ? limitOffset - startOffset : 0L;
                v.release();
                return l;
            }
            catch (Throwable throwable) {
                v.release();
                throw throwable;
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public long getMaxNextLevelOverlappingBytes() {
        this.mutex.lock();
        try {
            long l = this.versions.getMaxNextLevelOverlappingBytes();
            return l;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private WriteBatchImpl readWriteBatch(SliceInput record, int updateSize) throws IOException {
        WriteBatchImpl writeBatch = new WriteBatchImpl();
        int entries = 0;
        while (record.isReadable()) {
            Slice key;
            ++entries;
            ValueType valueType = ValueType.getValueTypeByPersistentId(record.readByte());
            if (valueType == ValueType.VALUE) {
                key = Slices.readLengthPrefixedBytes(record);
                Slice value = Slices.readLengthPrefixedBytes(record);
                writeBatch.put(key, value);
                continue;
            }
            if (valueType == ValueType.DELETION) {
                key = Slices.readLengthPrefixedBytes(record);
                writeBatch.delete(key);
                continue;
            }
            throw new IllegalStateException("Unexpected value type " + (Object)((Object)valueType));
        }
        if (entries != updateSize) {
            throw new IOException(String.format("Expected %d entries in log record but found %s entries", updateSize, entries));
        }
        return writeBatch;
    }

    static Slice writeWriteBatch(WriteBatchImpl updates, long sequenceBegin) {
        Slice record = Slices.allocate(12 + updates.getApproximateSize());
        final SliceOutput sliceOutput = record.output();
        sliceOutput.writeLong(sequenceBegin);
        sliceOutput.writeInt(updates.size());
        updates.forEach(new WriteBatchImpl.Handler(){

            @Override
            public void put(Slice key, Slice value) {
                sliceOutput.writeByte(ValueType.VALUE.getPersistentId());
                Slices.writeLengthPrefixedBytes(sliceOutput, key);
                Slices.writeLengthPrefixedBytes(sliceOutput, value);
            }

            @Override
            public void delete(Slice key) {
                sliceOutput.writeByte(ValueType.DELETION.getPersistentId());
                Slices.writeLengthPrefixedBytes(sliceOutput, key);
            }
        });
        return record.slice(0, sliceOutput.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendCompactions() throws InterruptedException {
        this.compactionExecutor.execute(() -> {
            try {
                Object object = this.suspensionMutex;
                synchronized (object) {
                    ++this.suspensionCounter;
                    this.suspensionMutex.notifyAll();
                    while (this.suspensionCounter > 0 && !this.compactionExecutor.isShutdown()) {
                        this.suspensionMutex.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Object object = this.suspensionMutex;
        synchronized (object) {
            while (this.suspensionCounter < 1) {
                this.suspensionMutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeCompactions() {
        Object object = this.suspensionMutex;
        synchronized (object) {
            --this.suspensionCounter;
            this.suspensionMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRange(byte[] begin, byte[] end) throws DBException {
        Slice smallestUserKey = begin == null ? null : new Slice(begin, 0, begin.length);
        Slice largestUserKey = end == null ? null : new Slice(end, 0, end.length);
        int maxLevelWithFiles = 1;
        this.mutex.lock();
        try {
            Version base = this.versions.getCurrent();
            for (int level = 1; level < 7; ++level) {
                if (!base.overlapInLevel(level, smallestUserKey, largestUserKey)) continue;
                maxLevelWithFiles = level;
            }
        }
        finally {
            this.mutex.unlock();
        }
        this.testCompactMemTable();
        for (int level = 0; level < maxLevelWithFiles; ++level) {
            this.testCompactRange(level, smallestUserKey, largestUserKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void testCompactRange(int level, Slice begin, Slice end) throws DBException {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((level + 1 < 7 ? 1 : 0) != 0);
        InternalKey beginStorage = begin == null ? null : new InternalKey(begin, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
        InternalKey endStorage = end == null ? null : new InternalKey(end, 0L, ValueType.DELETION);
        ManualCompaction manual = new ManualCompaction(level, beginStorage, endStorage);
        this.mutex.lock();
        try {
            while (!manual.done && !this.shuttingDown.get() && this.backgroundException == null) {
                if (this.manualCompaction == null) {
                    this.manualCompaction = manual;
                    this.maybeScheduleCompaction();
                    continue;
                }
                this.backgroundCondition.awaitUninterruptibly();
            }
            if (this.manualCompaction == manual) {
                this.manualCompaction = null;
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    @VisibleForTesting
    void testCompactMemTable() throws DBException {
        this.writeInternal(null, new WriteOptions());
        this.mutex.lock();
        try {
            while (this.immutableMemTable != null && this.backgroundException == null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
            if (this.immutableMemTable != null && this.backgroundException != null) {
                throw new DBException(this.backgroundException);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    @VisibleForTesting
    void waitForBackgroundCompactationToFinish() {
        this.mutex.lock();
        try {
            while (this.backgroundCompaction != null && !this.shuttingDown.get() && this.backgroundException == null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroyDB(File dbname, Env env) throws IOException {
        if (!dbname.exists()) {
            return true;
        }
        List<File> filenames = dbname.listFiles();
        boolean res = true;
        File lockFile = dbname.child(Filename.lockFileName());
        DbLock lock = env.tryLock(lockFile);
        try {
            for (File filename : filenames) {
                Filename.FileInfo fileInfo = Filename.parseFileName(filename);
                if (fileInfo == null || fileInfo.getFileType() == Filename.FileType.DB_LOCK) continue;
                res &= filename.delete();
            }
        }
        finally {
            try {
                lock.release();
            }
            catch (Exception exception) {}
        }
        lockFile.delete();
        dbname.delete();
        return res;
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.databaseDir + "}";
    }

    private /* synthetic */ void lambda$internalIterator$1(Version current) {
        this.mutex.lock();
        try {
            current.release();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private class WriteBatchInternal {
        private final WriteBatchImpl batch;
        private final boolean sync;
        private final Condition backgroundCondition;
        boolean done = false;
        public Throwable error;

        WriteBatchInternal(WriteBatchImpl batch, boolean sync, Condition backgroundCondition) {
            this.batch = batch;
            this.sync = sync;
            this.backgroundCondition = backgroundCondition;
        }

        void signal() {
            this.backgroundCondition.signal();
        }

        void checkExceptions() {
            DbImpl.this.checkBackgroundException();
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            if (this.error != null) {
                throw new DBException(this.error);
            }
        }
    }

    public class RecordBytesListener
    implements SnapshotSeekingIterator.IRecordBytesListener {
        private final Random r = new Random();
        private int bytesReadUntilSampling = this.getRandomCompactionPeriod(this.r);

        RecordBytesListener() {
        }

        @Override
        public void record(InternalKey internalKey, int bytes) {
            this.bytesReadUntilSampling -= bytes;
            while (this.bytesReadUntilSampling < 0) {
                this.bytesReadUntilSampling += this.getRandomCompactionPeriod(this.r);
                DbImpl.this.recordReadSample(internalKey);
            }
        }

        private int getRandomCompactionPeriod(Random r) {
            return r.nextInt(0x200000);
        }
    }

    public static class BackgroundProcessingException
    extends DBException {
        public BackgroundProcessingException(Throwable cause) {
            super(cause);
        }
    }

    public static class DatabaseShutdownException
    extends DBException {
        public DatabaseShutdownException() {
        }

        public DatabaseShutdownException(String message) {
            super(message);
        }
    }

    private static class CompactionStats {
        long micros = 0L;
        long bytesRead = 0L;
        long bytesWritten = 0L;

        CompactionStats() {
        }

        public void add(long micros, long bytesRead, long bytesWritten) {
            this.micros += micros;
            this.bytesRead += bytesRead;
            this.bytesWritten += bytesWritten;
        }
    }

    private static class ManualCompaction {
        private final int level;
        private InternalKey begin;
        private final InternalKey end;
        private boolean done;

        private ManualCompaction(int level, InternalKey begin, InternalKey end) {
            this.level = level;
            this.begin = begin;
            this.end = end;
        }
    }

    private static class CompactionState {
        private final Compaction compaction;
        private final List<FileMetaData> outputs = new ArrayList<FileMetaData>();
        private long smallestSnapshot;
        private WritableFile outfile;
        private TableBuilder builder;
        private long currentFileNumber;
        private long currentFileSize;
        private InternalKey currentSmallest;
        private InternalKey currentLargest;
        private long totalBytes;

        private CompactionState(Compaction compaction) {
            this.compaction = compaction;
        }

        public Compaction getCompaction() {
            return this.compaction;
        }
    }

    private static class RecoverResult {
        long maxSequence;
        boolean saveManifest;

        public RecoverResult(long maxSequence, boolean saveManifest) {
            this.maxSequence = maxSequence;
            this.saveManifest = saveManifest;
        }
    }
}

