/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Objects;
import org.iq80.leveldb.env.RandomInputFile;
import org.iq80.leveldb.fileenv.ByteBufferSupport;

class MMRandomInputFile
implements RandomInputFile {
    private final String file;
    private final long size;
    private final MappedByteBuffer data;

    private MMRandomInputFile(String file, MappedByteBuffer data, long size) {
        this.file = file;
        this.size = size;
        this.data = data;
    }

    public static RandomInputFile open(File file) throws IOException {
        Objects.requireNonNull(file, "file is null");
        MappedByteBuffer map = Files.map((File)file);
        return new MMRandomInputFile(file.getAbsolutePath(), map, map.capacity());
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public ByteBuffer read(long offset, int length) {
        int newPosition = (int)((long)this.data.position() + offset);
        return (ByteBuffer)this.data.duplicate().order(ByteOrder.LITTLE_ENDIAN).clear().limit(newPosition + length).position(newPosition);
    }

    @Override
    public void close() throws IOException {
        try {
            ByteBufferSupport.unmap(this.data);
        }
        catch (Exception e) {
            throw new IOException("Unable to unmap file", e);
        }
    }

    public String toString() {
        return "MMTableDataSource{file='" + this.file + '\'' + ", size=" + this.size + '}';
    }
}

