/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.visualtester;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PdfVisualTester {
    private static final int LEFT_MARGIN_PX = 45;
    private static final int LINE_HEIGHT_PX = 17;
    private static final BufferedImage ONE_PX_IMAGE = new BufferedImage(1, 1, 1);

    /*
     * Exception decompiling
     */
    public static List<PdfCompareResult> comparePdfDocuments(byte[] expected, byte[] actual, String testName, boolean keepSameImages) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isImageDifferent(BufferedImage imgExpected, BufferedImage imgActual) {
        DataBuffer dbExpected = imgExpected.getData().getDataBuffer();
        DataBuffer dbActual = imgActual.getData().getDataBuffer();
        if (dbExpected.getDataType() != dbActual.getDataType()) {
            return true;
        }
        switch (dbExpected.getDataType()) {
            case 0: {
                return !Arrays.equals(((DataBufferByte)dbExpected).getData(), ((DataBufferByte)dbActual).getData());
            }
            case 2: {
                return !Arrays.equals(((DataBufferShort)dbExpected).getData(), ((DataBufferShort)dbActual).getData());
            }
            case 1: {
                return !Arrays.equals(((DataBufferUShort)dbExpected).getData(), ((DataBufferUShort)dbActual).getData());
            }
            case 3: {
                return !Arrays.equals(((DataBufferInt)dbExpected).getData(), ((DataBufferInt)dbActual).getData());
            }
            case 4: {
                return !Arrays.equals(((DataBufferFloat)dbExpected).getData(), ((DataBufferFloat)dbActual).getData());
            }
            case 5: {
                return !Arrays.equals(((DataBufferDouble)dbExpected).getData(), ((DataBufferDouble)dbActual).getData());
            }
            case 32: {
                return true;
            }
        }
        return true;
    }

    public static BufferedImage createDiffImage(BufferedImage img1, BufferedImage img2) {
        int maxW = Math.max(img1.getWidth(), img2.getWidth());
        int maxH = Math.max(img1.getHeight(), img2.getHeight());
        BufferedImage diff = new BufferedImage(maxW + 45, maxH, 1);
        Graphics2D g2d = diff.createGraphics();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, diff.getWidth(), diff.getHeight());
        g2d.dispose();
        DataBuffer db = diff.getRaster().getDataBuffer();
        boolean hasDifferences = false;
        ArrayList<Boolean> lines = new ArrayList<Boolean>(maxH / 10);
        for (int y = 0; y < maxH; ++y) {
            int diffLineOffset = y * (maxW + 45);
            if (y % 17 == 0 && y != 0) {
                lines.add(hasDifferences);
                hasDifferences = false;
            }
            for (int x = 0; x < maxW; ++x) {
                int expectedPixel;
                int actualPixel = PdfVisualTester.getActualPixel(img1, x, y);
                if (actualPixel != (expectedPixel = PdfVisualTester.getExpectedPixel(img2, x, y))) {
                    hasDifferences = true;
                    db.setElem(diffLineOffset + x + 45, PdfVisualTester.getElement(expectedPixel, actualPixel));
                    continue;
                }
                db.setElem(diffLineOffset + x + 45, PdfVisualTester.getElement(expectedPixel, actualPixel));
            }
        }
        g2d = diff.createGraphics();
        g2d.setFont(new Font("Monospaced", 0, 15));
        g2d.setPaint(Color.BLACK);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int ascent = g2d.getFontMetrics().getAscent();
        for (int i = 0; i < lines.size(); ++i) {
            boolean differs = (Boolean)lines.get(i);
            if (differs) {
                g2d.setPaint(Color.PINK);
                g2d.fillRect(0, i * 17, 45, 17);
                g2d.setPaint(Color.BLACK);
            }
            g2d.drawString(String.format("%03d", i), 2, i * 17 + 1 + ascent);
        }
        g2d.dispose();
        return diff;
    }

    private static int getExpectedPixel(BufferedImage img, int x, int y) {
        if (x >= img.getWidth() || y >= img.getHeight()) {
            return Color.PINK.getRGB();
        }
        return img.getRGB(x, y);
    }

    private static int getActualPixel(BufferedImage img, int x, int y) {
        if (x >= img.getWidth() || y >= img.getHeight()) {
            return Color.CYAN.getRGB();
        }
        return img.getRGB(x, y);
    }

    private static int getElement(int expectedElement, int actualElement) {
        if (expectedElement != actualElement) {
            int actualDarkness;
            int expectedDarkness = PdfVisualTester.calcCombinedIntensity(expectedElement);
            if (expectedDarkness > (actualDarkness = PdfVisualTester.calcCombinedIntensity(actualElement))) {
                return PdfVisualTester.color(PdfVisualTester.levelIntensity(expectedDarkness, 210), 0, 0);
            }
            return PdfVisualTester.color(0, PdfVisualTester.levelIntensity(actualDarkness, 180), 0);
        }
        return PdfVisualTester.fadeElement(expectedElement);
    }

    private static int levelIntensity(int darkness, int maxIntensity) {
        return Math.min(maxIntensity, Math.max(50, darkness));
    }

    private static int calcCombinedIntensity(int element) {
        Color color = new Color(element);
        return Math.min(255, (color.getRed() + color.getGreen() + color.getRed()) / 3);
    }

    private static int color(int r, int g, int b) {
        return new Color(r, g, b).getRGB();
    }

    private static int fadeElement(int i) {
        Color color = new Color(i);
        return new Color(PdfVisualTester.fade(color.getRed()), PdfVisualTester.fade(color.getGreen()), PdfVisualTester.fade(color.getBlue())).getRGB();
    }

    private static int fade(int i) {
        return i + (255 - i) * 3 / 5;
    }

    public static class PdfCompareResult {
        public final ProblemType type;
        public final String logMessage;
        public final int pageNumber;
        public final TestImage testImages;
        public static final int INALID_PAGE_NO = -1;

        private PdfCompareResult(ProblemType type, String logMessage, int pageNumber, TestImage testImage) {
            this.type = type;
            this.logMessage = type.toString() + ": " + logMessage;
            this.pageNumber = pageNumber;
            this.testImages = testImage;
        }
    }

    public static enum ProblemType {
        PAGE_GOOD,
        NO_EXPECTED_DOCUMENT_PROVIDED,
        NO_ACTUAL_DOCUMENT_PROVIDED,
        EXTRA_EXPECTED_PAGE,
        PAGE_COUNT_DIFFERENT,
        PAGE_SIZE_DIFFERENT,
        PAGE_VISUALLY_DIFFERENT;

    }

    public static class TestImage {
        private final String testName;
        private final int pageNumber;
        private final BufferedImage expected;
        private final BufferedImage actual;
        private final boolean differences;

        public String getTestName() {
            return this.testName;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public BufferedImage getExpected() {
            return this.expected;
        }

        public BufferedImage getActual() {
            return this.actual;
        }

        public BufferedImage createDiff() {
            if (this.actual == null) {
                return PdfVisualTester.createDiffImage(this.expected, ONE_PX_IMAGE);
            }
            return PdfVisualTester.createDiffImage(this.expected, this.actual);
        }

        public boolean hasDifferences() {
            return this.differences;
        }

        private TestImage(String test, int pageNo, BufferedImage exp, BufferedImage act, boolean hasDifferences) {
            this.expected = exp;
            this.actual = act;
            this.testName = test;
            this.pageNumber = pageNo;
            this.differences = hasDifferences;
        }
    }
}

