/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.support;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Template;
import com.querydsl.jpa.hibernate.HibernateUtil;
import com.querydsl.sql.SQLTemplates;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BasicTypeRegistry;

final class DialectSupport {
    private DialectSupport() {
    }

    public static Map<String, DialectFunctionTemplate> createPatterns(SQLTemplates templates) {
        HashMap<String, DialectFunctionTemplate> functions = new HashMap<String, DialectFunctionTemplate>();
        functions.put("second", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.SECOND));
        functions.put("minute", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.MINUTE));
        functions.put("hour", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.HOUR));
        functions.put("day", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.DAY_OF_MONTH));
        functions.put("week", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.WEEK));
        functions.put("month", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.MONTH));
        functions.put("year", DialectSupport.createFunction(templates, (Operator)Ops.DateTimeOps.YEAR));
        return functions;
    }

    public static DialectFunctionTemplate createFunction(SQLTemplates templates, Operator operator) {
        Template template = templates.getTemplate(operator);
        BasicTypeReference type = HibernateUtil.getType(operator.getType());
        return new DialectFunctionTemplate(DialectSupport.convert(template), type);
    }

    public static String convert(Template template) {
        StringBuilder builder = new StringBuilder();
        for (Template.Element element : template.getElements()) {
            if (element instanceof Template.AsString) {
                builder.append("?").append(((Template.AsString)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.ByIndex) {
                builder.append("?").append(((Template.ByIndex)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.Transformed) {
                builder.append("?").append(((Template.Transformed)element).getIndex() + 1);
                continue;
            }
            if (element instanceof Template.StaticText) {
                builder.append(((Template.StaticText)element).getText());
                continue;
            }
            throw new IllegalStateException("Unsupported element " + String.valueOf(element));
        }
        return builder.toString();
    }

    public static void extendRegistry(SQLTemplates templates, FunctionContributions functionContributions) {
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        Map<String, DialectFunctionTemplate> functions = DialectSupport.createPatterns(templates);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        functions.forEach((name, template) -> functionRegistry.registerPattern(name, template.pattern(), basicTypeRegistry.resolve(template.type())));
    }

    public static void extendRegistry(String name, DialectFunctionTemplate template, FunctionContributions functionContributions) {
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        functionRegistry.registerPattern(name, template.pattern(), basicTypeRegistry.resolve(template.type()));
    }

    static class DialectFunctionTemplate {
        private final String pattern;
        private final BasicTypeReference<?> type;

        DialectFunctionTemplate(String pattern, BasicTypeReference<?> type) {
            this.pattern = pattern;
            this.type = type;
        }

        String pattern() {
            return this.pattern;
        }

        BasicTypeReference<?> type() {
            return this.type;
        }
    }
}

