/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.Extension;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModule {
    private final Map<Class<?>, Object> instances = new HashMap();
    private final Map<Class<?>, Class<?>> bindings = new HashMap();
    private final Map<String, Object> namedInstances = new HashMap<String, Object>();
    private final Map<String, Class<?>> namedBindings = new HashMap();

    public AbstractModule() {
        this.configure();
    }

    public final <T> AbstractModule bind(Class<T> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interfaces can't be instantiated");
        }
        this.bind(clazz, (T)clazz);
        return this;
    }

    public final <T> AbstractModule bind(String name, Class<? extends T> implementation) {
        this.namedBindings.put(name, implementation);
        return this;
    }

    public final <T> AbstractModule bind(String name, T implementation) {
        this.namedInstances.put(name, implementation);
        return this;
    }

    public final <T> AbstractModule bindInstance(String name, Class<? extends T> implementation) {
        this.namedInstances.put(name, implementation);
        return this;
    }

    public final <T> AbstractModule bind(Class<T> iface, Class<? extends T> implementation) {
        this.bindings.put(iface, implementation);
        return this;
    }

    public final <T> AbstractModule bind(Class<T> iface, T implementation) {
        this.instances.put(iface, implementation);
        return this;
    }

    public final void loadExtensions() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class, Extension.class.getClassLoader());
        for (Extension extension : loader) {
            extension.addSupport(this);
        }
    }

    protected abstract void configure();

    public final <T> T get(Class<T> iface) {
        if (this.instances.containsKey(iface)) {
            return (T)this.instances.get(iface);
        }
        if (this.bindings.containsKey(iface)) {
            Class<?> implementation = this.bindings.get(iface);
            Object instance = this.createInstance(implementation);
            this.instances.put(iface, instance);
            return (T)instance;
        }
        throw new IllegalArgumentException(iface.getName() + " is not registered");
    }

    public final <T> T get(Class<T> iface, String name) {
        if (this.namedInstances.containsKey(name)) {
            return (T)this.namedInstances.get(name);
        }
        if (this.namedBindings.containsKey(name)) {
            Class<?> implementation = this.namedBindings.get(name);
            if (implementation != null) {
                Object instance = this.createInstance(implementation);
                this.namedInstances.put(name, instance);
                return (T)instance;
            }
            return null;
        }
        throw new IllegalArgumentException(iface.getName() + " " + name + " is not registered");
    }

    private <T> T createInstance(Class<? extends T> implementation) {
        Constructor constructor = Arrays.stream(implementation.getConstructors()).filter(c -> c.isAnnotationPresent(Inject.class)).findFirst().orElseGet(() -> AbstractModule.fallbackToDefaultConstructor(implementation));
        Object[] args = this.getConstructorParameters(constructor);
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object @NotNull [] getConstructorParameters(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Named named = this.getNamedAnnotation(parameterAnnotations[i]);
            args[i] = named != null ? this.get(parameterTypes[i], named.value()) : this.get(parameterTypes[i]);
        }
        return args;
    }

    @NotNull
    private static <T> Constructor<? extends T> fallbackToDefaultConstructor(Class<? extends T> implementation) {
        try {
            return implementation.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private Named getNamedAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Named.class)) continue;
            return (Named)annotation;
        }
        return null;
    }
}

