/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaFileManager;

public final class MemFileSystemRegistry {
    public static final MemFileSystemRegistry DEFAULT = new MemFileSystemRegistry();
    private final Map<JavaFileManager, String> jfm2prefix = new WeakHashMap<JavaFileManager, String>();
    private Map<String, WeakReference<JavaFileManager>> prefix2jfm = new WeakHashMap<String, WeakReference<JavaFileManager>>();
    private final String protocolName;
    private int sequence = 0;

    private MemFileSystemRegistry() {
        String pkgName = MemFileSystemRegistry.class.getPackage().getName();
        this.protocolName = pkgName.substring(pkgName.lastIndexOf(46) + 1);
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        String parentPackage = pkgName.substring(0, pkgName.lastIndexOf(46));
        pkgs = pkgs == null ? parentPackage : pkgs + "|" + parentPackage;
        System.setProperty("java.protocol.handler.pkgs", pkgs);
    }

    public JavaFileManager getFileSystem(URL url) {
        String prefix = url.getProtocol() + "://" + url.getHost() + "/";
        if (this.prefix2jfm.containsKey(prefix)) {
            return (JavaFileManager)this.prefix2jfm.get(prefix).get();
        }
        return null;
    }

    public String getUrlPrefix(JavaFileManager jfm) {
        if (this.jfm2prefix.containsKey(jfm)) {
            return this.jfm2prefix.get(jfm);
        }
        String result = this.protocolName + "://jfm" + this.sequence++ + "/";
        this.jfm2prefix.put(jfm, result);
        this.prefix2jfm.put(result, new WeakReference<JavaFileManager>(jfm));
        return result;
    }
}

