/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.MethodMetadata;
import feign.Param;
import feign.QueryMapEncoder;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BuildTemplateByResolvingArgs
implements RequestTemplate.Factory {
    private final QueryMapEncoder queryMapEncoder;
    final MethodMetadata metadata;
    final Target<?> target;
    private final Map<Integer, Param.Expander> indexToExpander = new HashMap<Integer, Param.Expander>();

    BuildTemplateByResolvingArgs(MethodMetadata metadata, QueryMapEncoder queryMapEncoder, Target target) {
        this.metadata = metadata;
        this.target = target;
        this.queryMapEncoder = queryMapEncoder;
        if (metadata.indexToExpander() != null) {
            this.indexToExpander.putAll(metadata.indexToExpander());
            return;
        }
        if (metadata.indexToExpanderClass().isEmpty()) {
            return;
        }
        for (Map.Entry indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
            try {
                this.indexToExpander.put((Integer)indexToExpanderClass.getKey(), (Param.Expander)((Class)indexToExpanderClass.getValue()).newInstance());
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    public RequestTemplate create(Object[] argv) {
        Object value;
        RequestTemplate mutable = new RequestTemplate(this.metadata.template());
        if (this.metadata.urlIndex() != null) {
            int urlIndex = this.metadata.urlIndex();
            Util.checkNotNull((Object)argv[urlIndex], (String)"URI parameter %s was null", (Object[])new Object[]{urlIndex});
            mutable.insert(0, (CharSequence)String.valueOf(argv[urlIndex]));
        }
        HashMap<String, Object> varBuilder = new HashMap<String, Object>();
        for (Map.Entry entry : this.metadata.indexToName().entrySet()) {
            int i = (Integer)entry.getKey();
            Object value2 = argv[(Integer)entry.getKey()];
            if (value2 == null) continue;
            if (this.indexToExpander.containsKey(i)) {
                value2 = this.expandElements(this.indexToExpander.get(i), value2);
            }
            for (String name : (Collection)entry.getValue()) {
                varBuilder.put(name, value2);
            }
        }
        RequestTemplate template = this.resolve(argv, mutable, varBuilder);
        if (this.metadata.queryMapIndex() != null) {
            value = argv[this.metadata.queryMapIndex()];
            Map<String, Object> queryMap = this.toQueryMap(value);
            template = this.addQueryMapQueryParameters(queryMap, template);
        }
        if (this.metadata.headerMapIndex() != null) {
            value = argv[this.metadata.headerMapIndex()];
            Map<String, Object> headerMap = this.toQueryMap(value);
            template = this.addHeaderMapHeaders(headerMap, template);
        }
        return template;
    }

    private Map<String, Object> toQueryMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        try {
            return this.queryMapEncoder.encode(value);
        }
        catch (EncodeException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object expandElements(Param.Expander expander, Object value) {
        if (value instanceof Iterable) {
            return this.expandIterable(expander, (Iterable)value);
        }
        return expander.expand(value);
    }

    private List<String> expandIterable(Param.Expander expander, Iterable value) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object element : value) {
            if (element == null) continue;
            values.add(expander.expand(element));
        }
        return values;
    }

    private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutableRequestTemplate) {
        for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
            Object currValue = currEntry.getValue();
            ArrayList<String> values = new ArrayList<String>();
            if (currValue instanceof Iterable) {
                for (Object valueObject : (Iterable)currValue) {
                    values.add(valueObject == null ? null : valueObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutableRequestTemplate.header(currEntry.getKey(), values);
        }
        return mutableRequestTemplate;
    }

    private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutableRequestTemplate) {
        for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
            Object currValue = currEntry.getValue();
            ArrayList<String> values = new ArrayList<String>();
            if (currValue instanceof Iterable) {
                for (Object valueObject : (Iterable)currValue) {
                    values.add(valueObject == null ? null : valueObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutableRequestTemplate.query(currEntry.getKey(), values);
        }
        return mutableRequestTemplate;
    }

    protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
        return mutable.resolve(variables);
    }

    static final class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        BuildEncodedTemplateFromArgs(MethodMetadata metadata, QueryMapEncoder queryMapEncoder, Target target, Encoder encoder) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            Object body = argv[this.metadata.bodyIndex()];
            Util.checkNotNull((Object)body, (String)"Body parameter %s was null", (Object[])new Object[]{this.metadata.bodyIndex()});
            try {
                this.encoder.encode(body, this.metadata.bodyType(), mutable);
            }
            catch (EncodeException encodeException) {
                throw encodeException;
            }
            catch (RuntimeException unexpectedException) {
                throw new EncodeException(unexpectedException.getMessage(), (Throwable)unexpectedException);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    static final class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        BuildFormEncodedTemplateFromArgs(MethodMetadata metadata, QueryMapEncoder queryMapEncoder, Target target, Encoder encoder) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            HashMap<String, Object> formVariables = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException encodeException) {
                throw encodeException;
            }
            catch (RuntimeException unexpectedException) {
                throw new EncodeException(unexpectedException.getMessage(), (Throwable)unexpectedException);
            }
            return super.resolve(argv, mutable, variables);
        }
    }
}

