/*
 * Decompiled with CFR 0.152.
 */
package feign.vertx;

import feign.Request;
import feign.Response;
import feign.Util;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class VertxHttpClient {
    private final HttpClient httpClient;

    public VertxHttpClient(Vertx vertx, HttpClientOptions options) {
        Util.checkNotNull((Object)vertx, (String)"Argument vertx must not be null", (Object[])new Object[0]);
        Util.checkNotNull((Object)options, (String)"Argument options must be not null", (Object[])new Object[0]);
        this.httpClient = vertx.createHttpClient(options);
    }

    public Future<Response> execute(Request request) {
        HttpClientRequest httpClientRequest;
        Util.checkNotNull((Object)request, (String)"Argument request must be not null", (Object[])new Object[0]);
        try {
            httpClientRequest = this.makeHttpClientRequest(request);
        }
        catch (MalformedURLException unexpectedException) {
            return Future.failedFuture((Throwable)unexpectedException);
        }
        Future responseFuture = Future.future();
        httpClientRequest.exceptionHandler(arg_0 -> ((Future)responseFuture).fail(arg_0));
        httpClientRequest.handler(response -> {
            Map<String, Collection> responseHeaders = StreamSupport.stream(response.headers().spliterator(), false).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toCollection(ArrayList::new))));
            response.exceptionHandler(arg_0 -> ((Future)responseFuture).fail(arg_0));
            response.bodyHandler(body -> {
                Response feignResponse = Response.create((int)response.statusCode(), (String)response.statusMessage(), (Map)responseHeaders, (byte[])body.getBytes());
                responseFuture.complete((Object)feignResponse);
            });
        });
        if (request.body() != null) {
            httpClientRequest.write(Buffer.buffer((byte[])request.body()));
        }
        httpClientRequest.end();
        return responseFuture;
    }

    private HttpClientRequest makeHttpClientRequest(Request request) throws MalformedURLException {
        URL url = new URL(request.url());
        int port = url.getPort() > -1 ? url.getPort() : 80;
        String host = url.getHost();
        String requestUri = url.getFile();
        HttpClientRequest httpClientRequest = this.httpClient.request(HttpMethod.valueOf((String)request.method()), port, host, requestUri);
        for (Map.Entry header : request.headers().entrySet()) {
            httpClientRequest = httpClientRequest.putHeader((String)header.getKey(), (Iterable)header.getValue());
        }
        return httpClientRequest;
    }
}

