/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.MethodMetadata;
import feign.Param;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BuildTemplateByResolvingArgs
implements RequestTemplate.Factory {
    protected final MethodMetadata metadata;
    private final Map<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();

    public BuildTemplateByResolvingArgs(MethodMetadata metadata) {
        this.metadata = metadata;
        if (metadata.indexToExpander() != null) {
            this.indexToExpander.putAll(metadata.indexToExpander());
            return;
        }
        if (metadata.indexToExpanderClass().isEmpty()) {
            return;
        }
        for (Map.Entry indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
            try {
                this.indexToExpander.put((Integer)indexToExpanderClass.getKey(), (Param.Expander)((Class)indexToExpanderClass.getValue()).newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public RequestTemplate create(Object[] argv) {
        RequestTemplate mutable = new RequestTemplate(this.metadata.template());
        if (this.metadata.urlIndex() != null) {
            int urlIndex = this.metadata.urlIndex();
            Util.checkArgument((argv[urlIndex] != null ? 1 : 0) != 0, (String)"URI parameter %s was null", (Object[])new Object[]{urlIndex});
            mutable.insert(0, (CharSequence)String.valueOf(argv[urlIndex]));
        }
        LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : this.metadata.indexToName().entrySet()) {
            int i = (Integer)entry.getKey();
            Object value = argv[(Integer)entry.getKey()];
            if (value == null) continue;
            if (this.indexToExpander.containsKey(i)) {
                value = this.indexToExpander.get(i).expand(value);
            }
            for (String name : (Collection)entry.getValue()) {
                varBuilder.put(name, value);
            }
        }
        RequestTemplate template = this.resolve(argv, mutable, varBuilder);
        if (this.metadata.queryMapIndex() != null) {
            template = this.addQueryMapQueryParameters(argv, template);
        }
        if (this.metadata.headerMapIndex() != null) {
            template = this.addHeaderMapHeaders(argv, template);
        }
        return template;
    }

    private RequestTemplate addHeaderMapHeaders(Object[] argv, RequestTemplate mutable) {
        Map headerMap = (Map)argv[this.metadata.headerMapIndex()];
        for (Map.Entry currEntry : headerMap.entrySet()) {
            Util.checkState((currEntry.getKey().getClass() == String.class ? 1 : 0) != 0, (String)"HeaderMap key must be a String: %s", (Object[])new Object[]{currEntry.getKey()});
            ArrayList<String> values = new ArrayList<String>();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    values.add(nextObject == null ? null : nextObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutable.header((String)currEntry.getKey(), values);
        }
        return mutable;
    }

    private RequestTemplate addQueryMapQueryParameters(Object[] argv, RequestTemplate mutable) {
        Map queryMap = (Map)argv[this.metadata.queryMapIndex()];
        for (Map.Entry currEntry : queryMap.entrySet()) {
            Util.checkState((currEntry.getKey().getClass() == String.class ? 1 : 0) != 0, (String)"QueryMap key must be a String: %s", (Object[])new Object[]{currEntry.getKey()});
            ArrayList<String> values = new ArrayList<String>();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    values.add(nextObject == null ? null : nextObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutable.query((String)currEntry.getKey(), values);
        }
        return mutable;
    }

    protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
        return mutable.resolve(variables);
    }

    public static class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        public BuildEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder) {
            super(metadata);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            Object body = argv[this.metadata.bodyIndex()];
            Util.checkArgument((body != null ? 1 : 0) != 0, (String)"Body parameter %s was null", (Object[])new Object[]{this.metadata.bodyIndex()});
            try {
                this.encoder.encode(body, this.metadata.bodyType(), mutable);
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), (Throwable)e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    public static class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        public BuildFormEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder) {
            super(metadata);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            LinkedHashMap<String, Object> formVariables = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), (Throwable)e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }
}

