/*
 * Decompiled with CFR 0.152.
 */
package feign.spring;

import feign.DeclarativeContract;
import feign.MethodMetadata;
import feign.Request;
import feign.Util;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;

public class SpringContract
extends DeclarativeContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    public SpringContract() {
        this.registerClassAnnotation(RequestMapping.class, (requestMapping, data) -> {
            this.appendMappings(data, requestMapping.value());
            if (requestMapping.method().length == 1) {
                data.template().method(Request.HttpMethod.valueOf((String)requestMapping.method()[0].name()));
            }
            this.handleProducesAnnotation(data, requestMapping.produces());
            this.handleConsumesAnnotation(data, requestMapping.consumes());
        });
        this.registerMethodAnnotation(RequestMapping.class, (requestMapping, data) -> {
            this.appendMappings(data, this.mapping(requestMapping.path(), requestMapping.value()));
            if (requestMapping.method().length == 1) {
                data.template().method(Request.HttpMethod.valueOf((String)requestMapping.method()[0].name()));
            }
            this.handleProducesAnnotation(data, requestMapping.produces());
            this.handleConsumesAnnotation(data, requestMapping.consumes());
        });
        this.registerMethodAnnotation(GetMapping.class, (mapping, data) -> {
            this.appendMappings(data, this.mapping(mapping.path(), mapping.value()));
            data.template().method(Request.HttpMethod.GET);
            this.handleProducesAnnotation(data, mapping.produces());
            this.handleConsumesAnnotation(data, mapping.consumes());
        });
        this.registerMethodAnnotation(PostMapping.class, (mapping, data) -> {
            this.appendMappings(data, this.mapping(mapping.path(), mapping.value()));
            data.template().method(Request.HttpMethod.POST);
            this.handleProducesAnnotation(data, mapping.produces());
            this.handleConsumesAnnotation(data, mapping.consumes());
        });
        this.registerMethodAnnotation(PutMapping.class, (mapping, data) -> {
            this.appendMappings(data, this.mapping(mapping.path(), mapping.value()));
            data.template().method(Request.HttpMethod.PUT);
            this.handleProducesAnnotation(data, mapping.produces());
            this.handleConsumesAnnotation(data, mapping.consumes());
        });
        this.registerMethodAnnotation(DeleteMapping.class, (mapping, data) -> {
            this.appendMappings(data, this.mapping(mapping.path(), mapping.value()));
            data.template().method(Request.HttpMethod.DELETE);
            this.handleProducesAnnotation(data, mapping.produces());
            this.handleConsumesAnnotation(data, mapping.consumes());
        });
        this.registerMethodAnnotation(PatchMapping.class, (mapping, data) -> {
            this.appendMappings(data, this.mapping(mapping.path(), mapping.value()));
            data.template().method(Request.HttpMethod.PATCH);
            this.handleProducesAnnotation(data, mapping.produces());
            this.handleConsumesAnnotation(data, mapping.consumes());
        });
        this.registerMethodAnnotation(ResponseBody.class, (body, data) -> this.handleProducesAnnotation(data, "application/json"));
        this.registerMethodAnnotation(ExceptionHandler.class, (ann, data) -> data.ignoreMethod());
        this.registerParameterAnnotation(PathVariable.class, this.pathVariableParameterAnnotationProcessor());
        this.registerParameterAnnotation(RequestBody.class, (body, data, paramIndex) -> {
            data.setBodyRequired(body.required());
            this.handleConsumesAnnotation(data, "application/json");
        });
        this.registerParameterAnnotation(RequestParam.class, this.requestParamParameterAnnotationProcessor());
        this.registerParameterAnnotation(RequestPart.class, this.requestPartParameterAnnotationProcessor());
        this.registerParameterAnnotation(RequestHeader.class, this.requestHeaderParameterAnnotationProcessor());
    }

    private String[] mapping(String[] firstPriority, String[] fallback) {
        return firstPriority.length > 0 ? firstPriority : fallback;
    }

    private String parameterName(String firstPriority, String secondPriority, Parameter parameter) {
        if (Util.isNotBlank((String)firstPriority)) {
            return firstPriority;
        }
        if (Util.isNotBlank((String)secondPriority)) {
            return secondPriority;
        }
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        return firstPriority;
    }

    private DeclarativeContract.ParameterAnnotationProcessor<PathVariable> pathVariableParameterAnnotationProcessor() {
        return (parameterAnnotation, data, paramIndex) -> {
            Parameter parameter = data.method().getParameters()[paramIndex];
            String name = this.parameterName(parameterAnnotation.name(), parameterAnnotation.value(), parameter);
            this.nameParam(data, name, paramIndex);
        };
    }

    private DeclarativeContract.ParameterAnnotationProcessor<RequestParam> requestParamParameterAnnotationProcessor() {
        return (parameterAnnotation, data, paramIndex) -> {
            Parameter parameter = data.method().getParameters()[paramIndex];
            String name = this.parameterName(parameterAnnotation.name(), parameterAnnotation.value(), parameter);
            Collection<String> query = this.addTemplatedParam((Collection)data.template().queries().get(name), name);
            data.template().query(name, query);
            this.nameParam(data, name, paramIndex);
        };
    }

    private DeclarativeContract.ParameterAnnotationProcessor<RequestHeader> requestHeaderParameterAnnotationProcessor() {
        return (parameterAnnotation, data, paramIndex) -> {
            Parameter parameter = data.method().getParameters()[paramIndex];
            Util.checkState((data.headerMapIndex() == null ? 1 : 0) != 0, (String)"Header map can only be present once.", (Object[])new Object[0]);
            if (Map.class.isAssignableFrom(parameter.getType()) || this.isUserPojo(parameter.getType())) {
                data.headerMapIndex(Integer.valueOf(paramIndex));
                return;
            }
            String name = this.parameterName(parameterAnnotation.name(), parameterAnnotation.value(), parameter);
            Collection<String> headers = this.addTemplatedParam((Collection)data.template().headers().get(name), name);
            data.template().header(name, headers);
            this.nameParam(data, name, paramIndex);
        };
    }

    private DeclarativeContract.ParameterAnnotationProcessor<RequestPart> requestPartParameterAnnotationProcessor() {
        return (parameterAnnotation, data, paramIndex) -> {
            Parameter parameter = data.method().getParameters()[paramIndex];
            String name = this.parameterName(parameterAnnotation.name(), parameterAnnotation.value(), parameter);
            data.template().methodMetadata().formParams().add(name);
            this.nameParam(data, name, paramIndex);
        };
    }

    private boolean isUserPojo(Type type) {
        String typeName = type.toString();
        return !typeName.startsWith("class java.");
    }

    private void appendMappings(MethodMetadata data, String[] mappings) {
        for (int i = 0; i < mappings.length; ++i) {
            Object methodAnnotationValue = mappings[i];
            if (!((String)methodAnnotationValue).startsWith("/") && !data.template().url().endsWith("/")) {
                methodAnnotationValue = "/" + (String)methodAnnotationValue;
            }
            if (data.template().url().endsWith("/") && ((String)methodAnnotationValue).startsWith("/")) {
                methodAnnotationValue = ((String)methodAnnotationValue).substring(1);
            }
            data.template().uri(data.template().url() + (String)methodAnnotationValue);
        }
    }

    private void handleProducesAnnotation(MethodMetadata data, String ... produces) {
        if (produces.length == 0) {
            return;
        }
        data.template().removeHeader(ACCEPT);
        data.template().header(ACCEPT, new String[]{produces[0]});
    }

    private void handleConsumesAnnotation(MethodMetadata data, String ... consumes) {
        if (consumes.length == 0) {
            return;
        }
        data.template().removeHeader(CONTENT_TYPE);
        data.template().header(CONTENT_TYPE, new String[]{consumes[0]});
    }

    protected Collection<String> addTemplatedParam(Collection<String> possiblyNull, String name) {
        if (possiblyNull == null) {
            possiblyNull = new ArrayList<String>();
        }
        possiblyNull.add(String.format("{%s}", name));
        return possiblyNull;
    }
}

