/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.Decoder;
import feign.micrometer.FeignMetricName;
import feign.micrometer.FeignMetricTagResolver;
import feign.micrometer.MeteredBody;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

public class MeteredDecoder
implements Decoder {
    private final Decoder decoder;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;
    private final MetricTagResolver metricTagResolver;

    public MeteredDecoder(Decoder decoder, MeterRegistry meterRegistry) {
        this(decoder, meterRegistry, new FeignMetricName(Decoder.class), new FeignMetricTagResolver());
    }

    public MeteredDecoder(Decoder decoder, MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        this.decoder = decoder;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.metricTagResolver = metricTagResolver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object decode(Response response, Type type) throws IOException, FeignException {
        Object decoded;
        Timer timer;
        Timer.Sample sample;
        Optional<MeteredBody> body;
        block6: {
            body = Optional.ofNullable(response.body()).map(MeteredBody::new);
            Response meteredResponse = body.map(b -> response.toBuilder().body((Response.Body)b).build()).orElse(response);
            sample = Timer.start((MeterRegistry)this.meterRegistry);
            timer = null;
            try {
                decoded = this.decoder.decode(meteredResponse, type);
                timer = this.createTimer(response, type, null);
                sample.stop(timer);
                if (timer != null) break block6;
            }
            catch (IOException | RuntimeException e) {
                try {
                    timer = this.createTimer(response, type, e);
                    this.createExceptionCounter(response, type, e).count();
                    throw e;
                    catch (Exception e2) {
                        timer = this.createTimer(response, type, e2);
                        this.createExceptionCounter(response, type, e2).count();
                        throw new IOException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (timer == null) {
                        timer = this.createTimer(response, type, null);
                    }
                    sample.stop(timer);
                    throw throwable;
                }
            }
            timer = this.createTimer(response, type, null);
        }
        sample.stop(timer);
        body.ifPresent(b -> this.createSummary(response, type).record((double)b.count()));
        return decoded;
    }

    protected Timer createTimer(Response response, Type type, Exception e) {
        Tag[] extraTags = this.extraTags(response, type, e);
        RequestTemplate template = response.request().requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), e, extraTags);
        return this.meterRegistry.timer(this.metricName.name(e), (Iterable)allTags);
    }

    protected Counter createExceptionCounter(Response response, Type type, Exception e) {
        Tag[] extraTags = this.extraTags(response, type, e);
        RequestTemplate template = response.request().requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), Tag.of((String)"uri", (String)template.path()), Tag.of((String)"exception_name", (String)e.getClass().getSimpleName())).and(extraTags);
        return this.meterRegistry.counter(this.metricName.name("error_count"), (Iterable)allTags);
    }

    protected DistributionSummary createSummary(Response response, Type type) {
        Tag[] tags = this.extraTags(response, type, null);
        RequestTemplate template = response.request().requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), tags);
        return this.meterRegistry.summary(this.metricName.name("response_size"), (Iterable)allTags);
    }

    protected Tag[] extraTags(Response response, Type type, Exception e) {
        return MetricTagResolver.EMPTY_TAGS_ARRAY;
    }
}

