/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jaxb.JAXBContextFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBDecoder
implements Decoder {
    private final JAXBContextFactory jaxbContextFactory;

    public JAXBDecoder(JAXBContextFactory jaxbContextFactory) {
        this.jaxbContextFactory = jaxbContextFactory;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 404) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("JAXB only supports decoding raw types. Found " + type);
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXSource source = new SAXSource(saxParserFactory.newSAXParser().getXMLReader(), new InputSource(response.body().asInputStream()));
            Unmarshaller unmarshaller = this.jaxbContextFactory.createUnmarshaller((Class)type);
            Object object = unmarshaller.unmarshal((Source)source);
            return object;
        }
        catch (JAXBException e) {
            throw new DecodeException(e.toString(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new DecodeException(e.toString(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new DecodeException(e.toString(), (Throwable)e);
        }
        finally {
            if (response.body() != null) {
                response.body().close();
            }
        }
    }
}

