/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson3;

import com.fasterxml.jackson.annotation.JsonInclude;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.Collections;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;

public class Jackson3Encoder
implements Encoder {
    private final JsonMapper mapper;

    public Jackson3Encoder() {
        this(Collections.emptyList());
    }

    public Jackson3Encoder(Iterable<JacksonModule> modules) {
        this(((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL))).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).addModules(modules)).build());
    }

    public Jackson3Encoder(JsonMapper mapper) {
        this.mapper = mapper;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        try {
            JavaType javaType = this.mapper.getTypeFactory().constructType(bodyType);
            template.body(this.mapper.writerFor(javaType).writeValueAsBytes(object), Util.UTF_8);
        }
        catch (JacksonException e) {
            throw new EncodeException(e.getMessage(), (Throwable)e);
        }
    }
}

