/*
 * Decompiled with CFR 0.152.
 */
package feign.hc5;

import feign.AsyncClient;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.zip.GZIPOutputStream;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;

public final class AsyncApacheHttp5Client
implements AsyncClient<HttpClientContext>,
AutoCloseable {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private final CloseableHttpAsyncClient client;

    public AsyncApacheHttp5Client() {
        this(AsyncApacheHttp5Client.createStartedClient());
    }

    public AsyncApacheHttp5Client(CloseableHttpAsyncClient client) {
        this.client = client;
    }

    private static CloseableHttpAsyncClient createStartedClient() {
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().build();
        client.start();
        return client;
    }

    public CompletableFuture<Response> execute(final Request request, Request.Options options, Optional<HttpClientContext> requestContext) {
        SimpleHttpRequest httpUriRequest = this.toClassicHttpRequest(request, options);
        final CompletableFuture<Response> result = new CompletableFuture<Response>();
        FutureCallback<SimpleHttpResponse> callback = new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse httpResponse) {
                result.complete(AsyncApacheHttp5Client.this.toFeignResponse(httpResponse, request));
            }

            public void failed(Exception ex) {
                result.completeExceptionally(ex);
            }

            public void cancelled() {
                result.cancel(false);
            }
        };
        this.client.execute(httpUriRequest, (HttpContext)this.configureTimeoutsAndRedirection(options, requestContext.orElseGet(HttpClientContext::new)), (FutureCallback)callback);
        return result;
    }

    protected HttpClientContext configureTimeoutsAndRedirection(Request.Options options, HttpClientContext context) {
        RequestConfig requestConfig = (this.client instanceof Configurable ? RequestConfig.copy((RequestConfig)((Configurable)this.client).getConfig()) : RequestConfig.custom()).setConnectTimeout(options.connectTimeout(), options.connectTimeoutUnit()).setResponseTimeout(options.readTimeout(), options.readTimeoutUnit()).setRedirectsEnabled(options.isFollowRedirects()).build();
        context.setRequestConfig(requestConfig);
        return context;
    }

    SimpleHttpRequest toClassicHttpRequest(Request request, Request.Options options) {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest(request.httpMethod().name(), request.url());
        boolean hasAcceptHeader = false;
        boolean isGzip = false;
        for (Map.Entry headerEntry : request.headers().entrySet()) {
            String headerName = (String)headerEntry.getKey();
            if (headerName.equalsIgnoreCase(ACCEPT_HEADER_NAME)) {
                hasAcceptHeader = true;
            }
            if (headerName.equalsIgnoreCase("Content-Length")) continue;
            if (headerName.equalsIgnoreCase("Content-Encoding")) {
                isGzip = ((Collection)headerEntry.getValue()).stream().anyMatch("gzip"::equalsIgnoreCase);
                boolean isDeflate = ((Collection)headerEntry.getValue()).stream().anyMatch("deflate"::equalsIgnoreCase);
                if (isDeflate) {
                    throw new IllegalArgumentException("Deflate Content-Encoding is not supported by feign-hc5");
                }
            }
            for (String headerValue : (Collection)headerEntry.getValue()) {
                httpRequest.addHeader(headerName, (Object)headerValue);
            }
        }
        if (!hasAcceptHeader) {
            httpRequest.addHeader(ACCEPT_HEADER_NAME, (Object)"*/*");
        }
        byte[] data = request.body();
        if (isGzip && data != null && data.length > 0) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 GZIPOutputStream gzipOs = new GZIPOutputStream((OutputStream)baos, true);){
                gzipOs.write(data);
                gzipOs.flush();
                data = baos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (data != null) {
            httpRequest.setBody(data, this.getContentType(request));
        }
        return httpRequest;
    }

    private ContentType getContentType(Request request) {
        ContentType contentType = null;
        for (Map.Entry entry : request.headers().entrySet()) {
            Collection values;
            if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type") || (values = (Collection)entry.getValue()) == null || values.isEmpty()) continue;
            contentType = ContentType.parse((CharSequence)((CharSequence)values.iterator().next()));
            if (contentType.getCharset() != null) break;
            contentType = contentType.withCharset(request.charset());
            break;
        }
        return contentType;
    }

    Response toFeignResponse(SimpleHttpResponse httpResponse, Request request) {
        int statusCode = httpResponse.getCode();
        String reason = httpResponse.getReasonPhrase();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (Header header : httpResponse.getHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        return Response.builder().protocolVersion((Request.ProtocolVersion)Util.enumForName(Request.ProtocolVersion.class, (Object)httpResponse.getVersion().format())).status(statusCode).reason(reason).headers(headers).request(request).body(httpResponse.getBodyBytes()).build();
    }

    @Override
    public void close() throws Exception {
        this.client.close(CloseMode.GRACEFUL);
    }
}

