/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.graphql.GraphqlContract;
import feign.graphql.GraphqlErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Optional;

public class GraphqlDecoder
implements Decoder {
    private final ObjectMapper mapper;
    private final Decoder delegate;

    public GraphqlDecoder() {
        this(new ObjectMapper(), null);
    }

    public GraphqlDecoder(ObjectMapper mapper) {
        this(mapper, null);
    }

    public GraphqlDecoder(Decoder delegate) {
        this(new ObjectMapper(), delegate);
    }

    public GraphqlDecoder(ObjectMapper mapper, Decoder delegate) {
        this.mapper = mapper;
        this.delegate = delegate;
    }

    public Object decode(Response response, Type type) throws IOException {
        Type targetType = type;
        boolean optional = this.isOptionalType(type);
        if (optional) {
            targetType = this.extractOptionalInnerType(type);
        }
        Optional<Object> result = this.doDecode(response, targetType);
        return optional ? Optional.ofNullable(result) : result;
    }

    private Object doDecode(Response response, Type type) throws IOException {
        JsonNode root;
        JsonNode errorsNode;
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(response.charset());
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        if (!(errorsNode = (root = this.mapper.readTree(reader)).path("errors")).isMissingNode() && errorsNode.isArray() && !errorsNode.isEmpty()) {
            String operationField = this.resolveOperationField(root, response);
            throw new GraphqlErrorException(response.status(), operationField, errorsNode.toString(), response.request());
        }
        JsonNode dataNode = root.path("data");
        if (dataNode.isMissingNode() || dataNode.isNull() || !dataNode.isObject()) {
            return Util.emptyValueOf((Type)type);
        }
        Iterator fieldNames = dataNode.fieldNames();
        if (!fieldNames.hasNext()) {
            return Util.emptyValueOf((Type)type);
        }
        String firstField = (String)fieldNames.next();
        JsonNode operationData = dataNode.get(firstField);
        if (operationData == null || operationData.isNull()) {
            return Util.emptyValueOf((Type)type);
        }
        if (operationData.isArray() && !this.isCollectionOrArrayType(type)) {
            if (operationData.isEmpty()) {
                return Util.emptyValueOf((Type)type);
            }
            operationData = operationData.get(0);
        }
        if (this.delegate != null) {
            byte[] dataBytes = this.mapper.writeValueAsBytes((Object)operationData);
            Response dataResponse = Response.builder().status(response.status()).reason(response.reason()).headers(response.headers()).request(response.request()).body(dataBytes).build();
            return this.delegate.decode(dataResponse, type);
        }
        return this.mapper.readValue(this.mapper.treeAsTokens((TreeNode)operationData), this.mapper.constructType(type));
    }

    private String resolveOperationField(JsonNode root, Response response) {
        Iterator names;
        JsonNode dataNode = root.path("data");
        if (!dataNode.isMissingNode() && dataNode.isObject() && (names = dataNode.fieldNames()).hasNext()) {
            return (String)names.next();
        }
        if (response.request() != null && response.request().body() != null) {
            try {
                JsonNode requestBody = this.mapper.readTree(response.request().body());
                String query = requestBody.path("query").asText(null);
                if (query != null) {
                    return GraphqlContract.extractOperationField(query);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "unknown";
    }

    private boolean isOptionalType(Type type) {
        ParameterizedType pt;
        Type type2;
        if (type instanceof JavaType) {
            JavaType jt = (JavaType)type;
            return jt.getRawClass() == Optional.class;
        }
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class cls = (Class)type2;
            return cls == Optional.class;
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls == Optional.class;
        }
        return false;
    }

    private Type extractOptionalInnerType(Type type) {
        if (type instanceof JavaType) {
            JavaType jt = (JavaType)type;
            return jt.containedType(0);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private boolean isCollectionOrArrayType(Type type) {
        ParameterizedType pt;
        Type type2;
        if (type instanceof JavaType) {
            JavaType jt = (JavaType)type;
            return jt.isCollectionLikeType() || jt.isArrayType();
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() || Iterable.class.isAssignableFrom(cls);
        }
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class cls = (Class)type2;
            return Iterable.class.isAssignableFrom(cls);
        }
        return false;
    }
}

