/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.graphql.GraphqlContract;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class GraphqlEncoder
implements Encoder,
RequestInterceptor {
    private final Encoder delegate;
    private final Map<String, GraphqlContract.QueryMetadata> queryMetadata;

    public GraphqlEncoder(Encoder delegate, GraphqlContract contract) {
        this.delegate = delegate;
        this.queryMetadata = contract.queryMetadata();
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        GraphqlContract.QueryMetadata meta = this.lookupMetadata(template);
        if (meta == null) {
            this.delegate.encode(object, bodyType, template);
            return;
        }
        LinkedHashMap<String, Object> graphqlBody = new LinkedHashMap<String, Object>();
        graphqlBody.put("query", meta.query);
        if (object != null && meta.variableName != null) {
            LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
            variables.put(meta.variableName, object);
            graphqlBody.put("variables", variables);
        }
        this.delegate.encode(graphqlBody, MAP_STRING_WILDCARD, template);
    }

    public void apply(RequestTemplate template) {
        if (template.body() != null) {
            return;
        }
        GraphqlContract.QueryMetadata meta = this.lookupMetadata(template);
        if (meta == null) {
            return;
        }
        LinkedHashMap<String, String> graphqlBody = new LinkedHashMap<String, String>();
        graphqlBody.put("query", meta.query);
        this.delegate.encode(graphqlBody, MAP_STRING_WILDCARD, template);
    }

    private GraphqlContract.QueryMetadata lookupMetadata(RequestTemplate template) {
        if (template.methodMetadata() == null) {
            return null;
        }
        return this.queryMetadata.get(template.methodMetadata().configKey());
    }
}

