/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql;

import feign.Contract;
import feign.Request;
import feign.graphql.GraphqlQuery;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GraphqlContract
extends Contract.Default {
    private static final Pattern OPERATION_FIELD_PATTERN = Pattern.compile("\\{\\s*(\\w+)\\s*[({]", 32);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\s*(\\w+)\\s*:");
    private final Map<String, QueryMetadata> metadata = new ConcurrentHashMap<String, QueryMetadata>();

    public GraphqlContract() {
        super.registerMethodAnnotation(GraphqlQuery.class, (annotation, data) -> {
            String query = annotation.value();
            if (data.template().method() == null) {
                data.template().method(Request.HttpMethod.POST);
                data.template().uri("/");
            }
            String variableName = GraphqlContract.extractFirstVariable(query);
            this.metadata.put(data.configKey(), new QueryMetadata(query, variableName));
        });
    }

    Map<String, QueryMetadata> queryMetadata() {
        return this.metadata;
    }

    static String extractOperationField(String query) {
        int braceCount = 0;
        boolean inOperation = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '{') {
                String prefix;
                Matcher m;
                if (++braceCount == 1) {
                    inOperation = true;
                    continue;
                }
                if (braceCount != 2 || !inOperation || !(m = OPERATION_FIELD_PATTERN.matcher((prefix = query.substring(0, i).trim()) + "{")).find()) continue;
                return m.group(1);
            }
            if (c != '}') continue;
            --braceCount;
        }
        Matcher m = OPERATION_FIELD_PATTERN.matcher(query);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    static String extractFirstVariable(String query) {
        Matcher m = VARIABLE_PATTERN.matcher(query);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    static class QueryMetadata {
        final String query;
        final String variableName;

        QueryMetadata(String query, String variableName) {
            this.query = query;
            this.variableName = variableName;
        }
    }
}

