/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Contract;
import feign.MethodMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class DeclarativeContract
extends Contract.BaseContract {
    private List<GuardedAnnotationProcessor> classAnnotationProcessors = new ArrayList<GuardedAnnotationProcessor>();
    private List<GuardedAnnotationProcessor> methodAnnotationProcessors = new ArrayList<GuardedAnnotationProcessor>();
    Map<Class<Annotation>, ParameterAnnotationProcessor<Annotation>> parameterAnnotationProcessors = new HashMap<Class<Annotation>, ParameterAnnotationProcessor<Annotation>>();

    @Override
    public final List<MethodMetadata> parseAndValidatateMetadata(Class<?> targetType) {
        return super.parseAndValidatateMetadata(targetType);
    }

    @Override
    protected final void processAnnotationOnClass(MethodMetadata data, Class<?> targetType) {
        Arrays.stream(targetType.getAnnotations()).forEach(annotation -> this.classAnnotationProcessors.stream().filter(processor -> processor.test((Annotation)annotation)).forEach(processor -> processor.process((Annotation)annotation, data)));
    }

    @Override
    protected final void processAnnotationOnMethod(MethodMetadata data, Annotation annotation, Method method) {
        this.methodAnnotationProcessors.stream().filter(processor -> processor.test(annotation)).forEach(processor -> processor.process(annotation, data));
    }

    @Override
    protected final boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        Arrays.stream(annotations).filter(annotation -> this.parameterAnnotationProcessors.containsKey(annotation.annotationType())).forEach(annotation -> this.parameterAnnotationProcessors.getOrDefault(annotation.annotationType(), ParameterAnnotationProcessor.DO_NOTHING).process((Annotation)annotation, data, paramIndex));
        return false;
    }

    protected <E extends Annotation> void registerClassAnnotation(Class<E> annotationType, AnnotationProcessor<E> processor) {
        this.registerClassAnnotation((E annotation) -> annotation.annotationType().equals(annotationType), processor);
    }

    protected <E extends Annotation> void registerClassAnnotation(Predicate<E> predicate, AnnotationProcessor<E> processor) {
        this.classAnnotationProcessors.add(new GuardedAnnotationProcessor(predicate, processor));
    }

    protected <E extends Annotation> void registerMethodAnnotation(Class<E> annotationType, AnnotationProcessor<E> processor) {
        this.registerMethodAnnotation((E annotation) -> annotation.annotationType().equals(annotationType), processor);
    }

    protected <E extends Annotation> void registerMethodAnnotation(Predicate<E> predicate, AnnotationProcessor<E> processor) {
        this.methodAnnotationProcessors.add(new GuardedAnnotationProcessor(predicate, processor));
    }

    protected <E extends Annotation> void registerParameterAnnotation(Class<E> annotation, ParameterAnnotationProcessor<E> processor) {
        this.parameterAnnotationProcessors.put(annotation, processor);
    }

    private class GuardedAnnotationProcessor
    implements Predicate<Annotation>,
    AnnotationProcessor<Annotation> {
        private Predicate<Annotation> predicate;
        private AnnotationProcessor<Annotation> processor;

        private GuardedAnnotationProcessor(Predicate predicate, AnnotationProcessor processor) {
            this.predicate = predicate;
            this.processor = processor;
        }

        @Override
        public void process(Annotation annotation, MethodMetadata metadata) {
            this.processor.process(annotation, metadata);
        }

        @Override
        public boolean test(Annotation t) {
            return this.predicate.test(t);
        }
    }

    @FunctionalInterface
    public static interface ParameterAnnotationProcessor<E extends Annotation> {
        public static final ParameterAnnotationProcessor<Annotation> DO_NOTHING = (ann, data, i) -> {};

        public void process(E var1, MethodMetadata var2, int var3);
    }

    @FunctionalInterface
    public static interface AnnotationProcessor<E extends Annotation> {
        public void process(E var1, MethodMetadata var2);
    }
}

