/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface ErrorDecoder {
    public Exception decode(String var1, Response var2);

    public static class RetryAfterDecoder {
        private final DateTimeFormatter dateTimeFormatter;

        RetryAfterDecoder() {
            this(DateTimeFormatter.RFC_1123_DATE_TIME);
        }

        RetryAfterDecoder(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = Util.checkNotNull(dateTimeFormatter, "dateTimeFormatter", new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public Long apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+\\.?0*$")) {
                retryAfter = retryAfter.replaceAll("\\.0*$", "");
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return this.currentTimeMillis() + deltaMillis;
            }
            try {
                return ZonedDateTime.parse(retryAfter, this.dateTimeFormatter).toInstant().toEpochMilli();
            }
            catch (NullPointerException | DateTimeParseException ignored) {
                return null;
            }
        }
    }

    public static class Default
    implements ErrorDecoder {
        private final RetryAfterDecoder retryAfterDecoder = new RetryAfterDecoder();
        private Integer maxBodyBytesLength;
        private Integer maxBodyCharsLength;

        public Default() {
            this.maxBodyBytesLength = null;
            this.maxBodyCharsLength = null;
        }

        public Default(Integer maxBodyBytesLength, Integer maxBodyCharsLength) {
            this.maxBodyBytesLength = maxBodyBytesLength;
            this.maxBodyCharsLength = maxBodyCharsLength;
        }

        @Override
        public Exception decode(String methodKey, Response response) {
            FeignException exception = FeignException.errorStatus(methodKey, response, this.maxBodyBytesLength, this.maxBodyCharsLength);
            Long retryAfter = this.retryAfterDecoder.apply((String)this.firstOrNull(response.headers(), "Retry-After"));
            if (retryAfter != null) {
                return new RetryableException(response.status(), exception.getMessage(), response.request().httpMethod(), exception, retryAfter, response.request(), methodKey);
            }
            return exception;
        }

        private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
            if (map.containsKey(key) && !map.get(key).isEmpty()) {
                return map.get(key).iterator().next();
            }
            return null;
        }
    }
}

