/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.MethodMetadata;
import feign.Target;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;

final class FeignMetricName {
    private final Class<?> meteredComponent;

    public FeignMetricName(Class<?> meteredComponent) {
        this.meteredComponent = meteredComponent;
    }

    public MetricName metricName(MethodMetadata methodMetadata, Target<?> target, String suffix) {
        return this.metricName(methodMetadata, target).resolve(suffix);
    }

    public MetricName metricName(MethodMetadata methodMetadata, Target<?> target) {
        return this.metricName(methodMetadata.targetType(), methodMetadata.method(), target.url());
    }

    public MetricName metricName(Class<?> targetType, Method method, String url) {
        return MetricRegistry.name(this.meteredComponent, (String[])new String[0]).tagged(new String[]{"client", targetType.getName()}).tagged(new String[]{"method", method.getName()}).tagged(new String[]{"host", this.extractHost(url)});
    }

    private String extractHost(String targetUrl) {
        try {
            return new URI(targetUrl).getHost();
        }
        catch (URISyntaxException e) {
            return targetUrl.length() <= 20 ? targetUrl : targetUrl.substring(0, 20);
        }
    }
}

