/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import feign.utils.ExceptionUtils;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;

public class BaseMeteredClient {
    protected final MetricRegistry metricRegistry;
    protected final FeignMetricName metricName;
    protected final MetricSuppliers metricSuppliers;

    public BaseMeteredClient(MetricRegistry metricRegistry, FeignMetricName metricName, MetricSuppliers metricSuppliers) {
        this.metricRegistry = metricRegistry;
        this.metricName = metricName;
        this.metricSuppliers = metricSuppliers;
    }

    protected Timer.Context createTimer(RequestTemplate template) {
        return this.metricRegistry.timer(this.metricName.metricName(template.methodMetadata(), template.feignTarget()).tagged(new String[]{"uri", template.methodMetadata().template().path()}), this.metricSuppliers.timers()).time();
    }

    protected void recordSuccess(RequestTemplate template, Response response) {
        this.metricRegistry.counter(this.httpResponseCode(template).tagged(new String[]{"http_status", String.valueOf(response.status())}).tagged(new String[]{"status_group", response.status() / 100 + "xx"}).tagged(new String[]{"uri", template.methodMetadata().template().path()})).inc();
    }

    protected void recordFailure(RequestTemplate template, FeignException e) {
        this.metricRegistry.counter(this.httpResponseCode(template).tagged(new String[]{"exception_name", ((Object)((Object)e)).getClass().getSimpleName()}).tagged(new String[]{"root_cause_name", ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName()}).tagged(new String[]{"http_status", String.valueOf(e.status())}).tagged(new String[]{"status_group", e.status() / 100 + "xx"}).tagged(new String[]{"uri", template.methodMetadata().template().path()})).inc();
    }

    protected void recordFailure(RequestTemplate template, Exception e) {
        this.metricRegistry.counter(this.httpResponseCode(template).tagged(new String[]{"exception_name", e.getClass().getSimpleName()}).tagged(new String[]{"root_cause_name", ExceptionUtils.getRootCause((Throwable)e).getClass().getSimpleName()}).tagged(new String[]{"uri", template.methodMetadata().template().path()})).inc();
    }

    private MetricName httpResponseCode(RequestTemplate template) {
        return this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "http_response_code");
    }
}

