/*
 * Decompiled with CFR 0.152.
 */
package feign.benchmark;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Request;
import feign.Response;
import feign.Target;
import feign.benchmark.FeignTestInterface;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
public class WhatShouldWeCacheBenchmarks {
    private Contract feignContract;
    private Contract cachedContact;
    private Client fakeClient;
    private Feign cachedFakeFeign;
    private FeignTestInterface cachedFakeApi;

    @Setup
    public void setup() {
        this.feignContract = new Contract.Default();
        this.cachedContact = new Contract(){
            private final List<MethodMetadata> cached = new Contract.Default().parseAndValidatateMetadata(FeignTestInterface.class);

            @Override
            public List<MethodMetadata> parseAndValidatateMetadata(Class<?> declaring) {
                return this.cached;
            }
        };
        this.fakeClient = new Client(){

            @Override
            public Response execute(Request request, Request.Options options) throws IOException {
                LinkedHashMap<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();
                return Response.create(200, "ok", headers, (byte[])null);
            }
        };
        this.cachedFakeFeign = Feign.builder().client(this.fakeClient).build();
        this.cachedFakeApi = this.cachedFakeFeign.newInstance(new Target.HardCodedTarget<FeignTestInterface>(FeignTestInterface.class, "http://localhost"));
    }

    @Benchmark
    public List<MethodMetadata> parseFeignContract() {
        return this.feignContract.parseAndValidatateMetadata(FeignTestInterface.class);
    }

    @Benchmark
    public Response buildAndQuery_fake() {
        return Feign.builder().client(this.fakeClient).target(FeignTestInterface.class, "http://localhost").query();
    }

    @Benchmark
    public Response buildAndQuery_fake_cachedContract() {
        return Feign.builder().contract(this.cachedContact).client(this.fakeClient).target(FeignTestInterface.class, "http://localhost").query();
    }

    @Benchmark
    public Response buildAndQuery_fake_cachedFeign() {
        return this.cachedFakeFeign.newInstance(new Target.HardCodedTarget<FeignTestInterface>(FeignTestInterface.class, "http://localhost")).query();
    }

    @Benchmark
    public Response buildAndQuery_fake_cachedApi() {
        return this.cachedFakeApi.query();
    }
}

