/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.client.events;

import io.reactivex.netty.channel.events.ConnectionEventPublisher;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.tcp.client.events.SafeTcpClientEventListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.subscriptions.CompositeSubscription;

public final class TcpClientEventPublisher
extends TcpClientEventListener
implements EventSource<TcpClientEventListener>,
EventPublisher {
    public static final Action1<TcpClientEventListener> CONN_START_ACTION = new Action1<TcpClientEventListener>(){

        @Override
        public void call(TcpClientEventListener l) {
            l.onConnectStart();
        }
    };
    public static final Action3<TcpClientEventListener, Long, TimeUnit> CONN_SUCCESS_ACTION = new Action3<TcpClientEventListener, Long, TimeUnit>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit) {
            l.onConnectSuccess(duration, timeUnit);
        }
    };
    public static final Action4<TcpClientEventListener, Long, TimeUnit, Throwable> CONN_FAILED_ACTION = new Action4<TcpClientEventListener, Long, TimeUnit, Throwable>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onConnectFailed(duration, timeUnit, t);
        }
    };
    public static final Action1<TcpClientEventListener> EVICTION_ACTION = new Action1<TcpClientEventListener>(){

        @Override
        public void call(TcpClientEventListener l) {
            l.onPooledConnectionEviction();
        }
    };
    public static final Action1<TcpClientEventListener> REUSE_ACTION = new Action1<TcpClientEventListener>(){

        @Override
        public void call(TcpClientEventListener l) {
            l.onPooledConnectionReuse();
        }
    };
    public static final Action1<TcpClientEventListener> ACQUIRE_START_ACTION = new Action1<TcpClientEventListener>(){

        @Override
        public void call(TcpClientEventListener l) {
            l.onPoolAcquireStart();
        }
    };
    public static final Action3<TcpClientEventListener, Long, TimeUnit> ACQUIRE_SUCCESS_ACTION = new Action3<TcpClientEventListener, Long, TimeUnit>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit) {
            l.onPoolAcquireSuccess(duration, timeUnit);
        }
    };
    public static final Action4<TcpClientEventListener, Long, TimeUnit, Throwable> ACQUIRE_FAILED_ACTION = new Action4<TcpClientEventListener, Long, TimeUnit, Throwable>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onPoolAcquireFailed(duration, timeUnit, t);
        }
    };
    public static final Action1<TcpClientEventListener> RELEASE_START_ACTION = new Action1<TcpClientEventListener>(){

        @Override
        public void call(TcpClientEventListener l) {
            l.onPoolReleaseStart();
        }
    };
    public static final Action3<TcpClientEventListener, Long, TimeUnit> RELEASE_SUCCESS_ACTION = new Action3<TcpClientEventListener, Long, TimeUnit>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit) {
            l.onPoolReleaseSuccess(duration, timeUnit);
        }
    };
    public static final Action4<TcpClientEventListener, Long, TimeUnit, Throwable> RELEASE_FAILED_ACTION = new Action4<TcpClientEventListener, Long, TimeUnit, Throwable>(){

        @Override
        public void call(TcpClientEventListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onPoolReleaseFailed(duration, timeUnit, t);
        }
    };
    private final ListenersHolder<TcpClientEventListener> listeners;
    private final ConnectionEventPublisher<TcpClientEventListener> connDelegate;

    public TcpClientEventPublisher() {
        this.listeners = new ListenersHolder();
        this.connDelegate = new ConnectionEventPublisher();
    }

    public TcpClientEventPublisher(TcpClientEventPublisher toCopy) {
        this.listeners = toCopy.listeners.copy();
        this.connDelegate = toCopy.connDelegate.copy();
    }

    @Override
    public void onConnectStart() {
        this.listeners.invokeListeners(CONN_START_ACTION);
    }

    @Override
    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(CONN_SUCCESS_ACTION, duration, timeUnit);
    }

    @Override
    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(CONN_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onPoolReleaseStart() {
        this.listeners.invokeListeners(RELEASE_START_ACTION);
    }

    @Override
    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(RELEASE_SUCCESS_ACTION, duration, timeUnit);
    }

    @Override
    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(RELEASE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onPooledConnectionEviction() {
        this.listeners.invokeListeners(EVICTION_ACTION);
    }

    @Override
    public void onPooledConnectionReuse() {
        this.listeners.invokeListeners(REUSE_ACTION);
    }

    @Override
    public void onPoolAcquireStart() {
        this.listeners.invokeListeners(ACQUIRE_START_ACTION);
    }

    @Override
    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(ACQUIRE_SUCCESS_ACTION, duration, timeUnit);
    }

    @Override
    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(ACQUIRE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.connDelegate.onByteRead(bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.connDelegate.onByteWritten(bytesWritten);
    }

    @Override
    public void onFlushStart() {
        this.connDelegate.onFlushStart();
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.connDelegate.onFlushComplete(duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.connDelegate.onWriteStart();
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.connDelegate.onWriteSuccess(duration, timeUnit);
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectionCloseStart() {
        this.connDelegate.onConnectionCloseStart();
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.connDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onCustomEvent(Object event) {
        this.connDelegate.onCustomEvent(event);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.connDelegate.onCustomEvent(event, duration, timeUnit);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onCustomEvent(event, duration, timeUnit, throwable);
    }

    @Override
    public void onCustomEvent(Object event, Throwable throwable) {
        this.connDelegate.onCustomEvent(event, throwable);
    }

    @Override
    public Subscription subscribe(TcpClientEventListener listener) {
        if (!SafeEventListener.class.isAssignableFrom(listener.getClass())) {
            listener = new SafeTcpClientEventListener(listener);
        }
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.listeners.subscribe(listener));
        cs.add(this.connDelegate.subscribe(listener));
        return cs;
    }

    @Override
    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    public TcpClientEventPublisher copy() {
        return new TcpClientEventPublisher(this);
    }

    ListenersHolder<TcpClientEventListener> getListeners() {
        return this.listeners;
    }
}

