/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.internal;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Iterator;
import java.util.Map;

public final class HttpMessageFormatter {
    private HttpMessageFormatter() {
    }

    public static String formatRequest(HttpVersion version, HttpMethod method, String uri, Iterator<Map.Entry<CharSequence, CharSequence>> headers) {
        StringBuilder builder = new StringBuilder();
        builder.append(method).append(' ').append(uri).append(' ').append(version.text()).append('\n');
        HttpMessageFormatter.printHeaders(headers, builder);
        return builder.toString();
    }

    public static String formatResponse(HttpVersion version, HttpResponseStatus status, Iterator<Map.Entry<CharSequence, CharSequence>> headers) {
        StringBuilder builder = new StringBuilder();
        builder.append(version.text()).append(' ').append(status.code()).append(' ').append(status.reasonPhrase()).append('\n');
        HttpMessageFormatter.printHeaders(headers, builder);
        return builder.toString();
    }

    private static void printHeaders(Iterator<Map.Entry<CharSequence, CharSequence>> headers, StringBuilder builder) {
        while (headers.hasNext()) {
            Map.Entry<CharSequence, CharSequence> next = headers.next();
            builder.append(next.getKey()).append(": ").append(next.getValue()).append('\n');
        }
        builder.append('\n');
    }
}

