/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.reactivex.netty.channel.AutoReleaseOperator;
import io.reactivex.netty.channel.DisposableContentSource;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class ContentSource<T>
extends Observable<T> {
    private ContentSource(final Observable<T> source) {
        super(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                source.unsafeSubscribe(subscriber);
            }
        });
    }

    public ContentSource(final Channel channel, final Func1<Subscriber<? super T>, Object> subscriptionEventFactory) {
        super(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                channel.pipeline().fireUserEventTriggered(subscriptionEventFactory.call(subscriber));
            }
        });
    }

    public ContentSource(final Throwable error) {
        super(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                subscriber.onError(error);
            }
        });
    }

    public Observable<T> autoRelease() {
        return this.lift(new AutoReleaseOperator());
    }

    public DisposableContentSource<T> replayable() {
        return DisposableContentSource.createNew(this);
    }

    public <R> ContentSource<R> transform(Observable.Transformer<T, R> transformer) {
        return new ContentSource<T>((Observable)transformer.call(this));
    }
}

