/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.AsciiString;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CookiesHolder {
    private final HttpHeaders nettyHeaders;
    private final AsciiString cookiesHeaderName;
    private final boolean isClientDecoder;
    private Map<String, Set<Cookie>> allCookies;
    private boolean cookiesParsed;

    private CookiesHolder(HttpHeaders nettyHeaders, AsciiString cookiesHeaderName, boolean isClientDecoder) {
        this.nettyHeaders = nettyHeaders;
        this.cookiesHeaderName = cookiesHeaderName;
        this.isClientDecoder = isClientDecoder;
        this.allCookies = Collections.emptyMap();
    }

    public Map<String, Set<Cookie>> getAllCookies() {
        return this._parseIfNeededAndGet();
    }

    public static CookiesHolder newClientResponseHolder(HttpHeaders headers) {
        return new CookiesHolder(headers, HttpHeaderNames.SET_COOKIE, true);
    }

    public static CookiesHolder newServerRequestHolder(HttpHeaders headers) {
        return new CookiesHolder(headers, HttpHeaderNames.COOKIE, false);
    }

    private synchronized Map<String, Set<Cookie>> _parseIfNeededAndGet() {
        if (this.cookiesParsed) {
            return this.allCookies;
        }
        List<String> allCookieHeaders = this.nettyHeaders.getAll(this.cookiesHeaderName);
        HashMap<String, HashSet<Cookie>> cookies = new HashMap<String, HashSet<Cookie>>();
        for (String aCookieHeader : allCookieHeaders) {
            if (this.isClientDecoder) {
                Cookie decoded = ClientCookieDecoder.STRICT.decode(aCookieHeader);
                HashSet<Cookie> existingCookiesOfName = (HashSet<Cookie>)cookies.get(decoded.name());
                if (null == existingCookiesOfName) {
                    existingCookiesOfName = new HashSet<Cookie>();
                    cookies.put(decoded.name(), existingCookiesOfName);
                }
                existingCookiesOfName.add(decoded);
                continue;
            }
            Set<Cookie> decode = ServerCookieDecoder.STRICT.decode(aCookieHeader);
            for (Cookie cookie : decode) {
                HashSet<Cookie> existingCookiesOfName = (HashSet<Cookie>)cookies.get(cookie.name());
                if (null == existingCookiesOfName) {
                    existingCookiesOfName = new HashSet<Cookie>();
                    cookies.put(cookie.name(), existingCookiesOfName);
                }
                existingCookiesOfName.add(cookie);
            }
        }
        this.allCookies = Collections.unmodifiableMap(cookies);
        this.cookiesParsed = true;
        return this.allCookies;
    }
}

