/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.channel.ChannelOperations;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.channel.DefaultChannelOperations;
import io.reactivex.netty.channel.events.ConnectionEventListener;
import io.reactivex.netty.events.EventAttributeKeys;
import io.reactivex.netty.events.EventPublisher;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public final class ConnectionImpl<R, W>
extends Connection<R, W> {
    private final ChannelOperations<W> delegate;

    private ConnectionImpl(Channel nettyChannel, ConnectionEventListener eventListener, EventPublisher eventPublisher) {
        super(nettyChannel);
        this.delegate = new DefaultChannelOperations(nettyChannel, eventListener, eventPublisher);
    }

    private ConnectionImpl(Channel nettyChannel, ChannelOperations<W> delegate) {
        super(nettyChannel);
        this.delegate = delegate;
    }

    private ConnectionImpl(ConnectionImpl<?, ?> toCopy, ContentSource<R> contentSource, ChannelOperations<W> delegate) {
        super(toCopy, contentSource);
        this.delegate = delegate;
    }

    @Override
    public Observable<Void> write(Observable<W> msgs) {
        return this.delegate.write(msgs);
    }

    @Override
    public Observable<Void> write(Observable<W> msgs, Func1<W, Boolean> flushSelector) {
        return this.delegate.write(msgs, flushSelector);
    }

    @Override
    public Observable<Void> writeAndFlushOnEach(Observable<W> msgs) {
        return this.delegate.writeAndFlushOnEach(msgs);
    }

    @Override
    public Observable<Void> writeString(Observable<String> msgs) {
        return this.delegate.writeString(msgs);
    }

    @Override
    public Observable<Void> writeString(Observable<String> msgs, Func1<String, Boolean> flushSelector) {
        return this.delegate.writeString(msgs, flushSelector);
    }

    @Override
    public Observable<Void> writeStringAndFlushOnEach(Observable<String> msgs) {
        return this.delegate.writeStringAndFlushOnEach(msgs);
    }

    @Override
    public Observable<Void> writeBytes(Observable<byte[]> msgs) {
        return this.delegate.writeBytes(msgs);
    }

    @Override
    public Observable<Void> writeBytes(Observable<byte[]> msgs, Func1<byte[], Boolean> flushSelector) {
        return this.delegate.writeBytes(msgs, flushSelector);
    }

    @Override
    public Observable<Void> writeBytesAndFlushOnEach(Observable<byte[]> msgs) {
        return this.delegate.writeBytesAndFlushOnEach(msgs);
    }

    @Override
    public Observable<Void> writeFileRegion(Observable<FileRegion> msgs) {
        return this.delegate.writeFileRegion(msgs);
    }

    @Override
    public Observable<Void> writeFileRegion(Observable<FileRegion> msgs, Func1<FileRegion, Boolean> flushSelector) {
        return this.delegate.writeFileRegion(msgs, flushSelector);
    }

    @Override
    public Observable<Void> writeFileRegionAndFlushOnEach(Observable<FileRegion> msgs) {
        return this.delegate.writeFileRegionAndFlushOnEach(msgs);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public Observable<Void> close() {
        return this.delegate.close();
    }

    @Override
    public Observable<Void> close(boolean flush) {
        return this.delegate.close(flush);
    }

    @Override
    public void closeNow() {
        this.delegate.closeNow();
    }

    @Override
    public Observable<Void> closeListener() {
        return this.delegate.closeListener();
    }

    public static <R, W> ConnectionImpl<R, W> fromChannel(Channel nettyChannel) {
        EventPublisher ep = nettyChannel.attr(EventAttributeKeys.EVENT_PUBLISHER).get();
        if (null == ep) {
            throw new IllegalArgumentException("No event publisher set in the channel.");
        }
        ConnectionEventListener l = null;
        if (ep.publishingEnabled() && null == (l = nettyChannel.attr(EventAttributeKeys.CONNECTION_EVENT_LISTENER).get())) {
            throw new IllegalArgumentException("No event listener set in the channel.");
        }
        ConnectionImpl<R, W> toReturn = new ConnectionImpl<R, W>(nettyChannel, l, ep);
        toReturn.connectCloseToChannelClose();
        return toReturn;
    }

    static <R, W> ConnectionImpl<R, W> create(Channel nettyChannel, ChannelOperations<W> delegate) {
        ConnectionImpl<R, W> toReturn = new ConnectionImpl<R, W>(nettyChannel, delegate);
        toReturn.connectCloseToChannelClose();
        return toReturn;
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerFirst(String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addFirst(name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerFirst(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addFirst(group, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerLast(String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addLast(name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerLast(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addLast(group, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerBefore(String baseName, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addBefore(baseName, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addBefore(group, baseName, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerAfter(String baseName, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addAfter(baseName, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.getResettableChannelPipeline().markIfNotYetMarked().addAfter(group, baseName, name, handler);
        return this.cast();
    }

    @Override
    public <RR, WW> Connection<RR, WW> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        pipelineConfigurator.call(this.getResettableChannelPipeline().markIfNotYetMarked());
        return this.cast();
    }

    @Override
    public <RR> Connection<RR, W> transformRead(Observable.Transformer<R, RR> transformer) {
        return new ConnectionImpl<RR, W>(this, this.getInput().transform(transformer), this.delegate);
    }

    @Override
    public <WW> Connection<R, WW> transformWrite(AllocatingTransformer<WW, W> transformer) {
        return new ConnectionImpl(this, this.getInput(), this.delegate.transformWrite(transformer));
    }

    protected <RR, WW> Connection<RR, WW> cast() {
        return this;
    }
}

