/*
 * Decompiled with CFR 0.152.
 */
package feign.error;

import feign.Feign;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.error.ErrorCodes;
import feign.error.ErrorHandling;
import feign.error.ExceptionGenerator;
import feign.error.MethodErrorHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnnotationErrorDecoder
implements ErrorDecoder {
    private final Map<String, MethodErrorHandler> errorHandlerMap;
    private final ErrorDecoder defaultDecoder;

    AnnotationErrorDecoder(Map<String, MethodErrorHandler> errorHandlerMap, ErrorDecoder defaultDecoder) {
        this.errorHandlerMap = errorHandlerMap;
        this.defaultDecoder = defaultDecoder;
    }

    public Exception decode(String methodKey, Response response) {
        if (this.errorHandlerMap.containsKey(methodKey)) {
            return this.errorHandlerMap.get(methodKey).decode(response);
        }
        return this.defaultDecoder.decode(methodKey, response);
    }

    public static Builder builderFor(Class<?> apiType) {
        return new Builder(apiType);
    }

    public static class Builder {
        private final Class<?> apiType;
        private ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
        private Decoder responseBodyDecoder = new Decoder.Default();

        public Builder(Class<?> apiType) {
            this.apiType = apiType;
        }

        public Builder withDefaultDecoder(ErrorDecoder defaultDecoder) {
            this.defaultDecoder = defaultDecoder;
            return this;
        }

        public Builder withResponseBodyDecoder(Decoder responseBodyDecoder) {
            this.responseBodyDecoder = responseBodyDecoder;
            return this;
        }

        public AnnotationErrorDecoder build() {
            Map<String, MethodErrorHandler> errorHandlerMap = this.generateErrorHandlerMapFromApi(this.apiType);
            return new AnnotationErrorDecoder(errorHandlerMap, this.defaultDecoder);
        }

        Map<String, MethodErrorHandler> generateErrorHandlerMapFromApi(Class<?> apiType) {
            ExceptionGenerator classLevelDefault = new ExceptionGenerator.Builder().withResponseBodyDecoder(this.responseBodyDecoder).withExceptionType(ErrorHandling.NO_DEFAULT.class).build();
            HashMap<Integer, ExceptionGenerator> classLevelStatusCodeDefinitions = new HashMap();
            Optional<ErrorHandling> classLevelErrorHandling = this.readErrorHandlingIncludingInherited(apiType);
            if (classLevelErrorHandling.isPresent()) {
                ErrorHandlingDefinition classErrorHandlingDefinition = Builder.readAnnotation(classLevelErrorHandling.get(), this.responseBodyDecoder);
                classLevelDefault = classErrorHandlingDefinition.defaultThrow;
                classLevelStatusCodeDefinitions = classErrorHandlingDefinition.statusCodesMap;
            }
            HashMap<String, MethodErrorHandler> methodErrorHandlerMap = new HashMap<String, MethodErrorHandler>();
            for (Method method : apiType.getMethods()) {
                ErrorHandling methodLevelAnnotation = Builder.getErrorHandlingAnnotation(method);
                if (methodLevelAnnotation == null) continue;
                ErrorHandlingDefinition methodErrorHandling = Builder.readAnnotation(methodLevelAnnotation, this.responseBodyDecoder);
                ExceptionGenerator methodDefault = methodErrorHandling.defaultThrow;
                if (methodDefault.getExceptionType().equals(ErrorHandling.NO_DEFAULT.class)) {
                    methodDefault = classLevelDefault;
                }
                MethodErrorHandler methodErrorHandler = new MethodErrorHandler(methodErrorHandling.statusCodesMap, classLevelStatusCodeDefinitions, methodDefault);
                methodErrorHandlerMap.put(Feign.configKey(apiType, (Method)method), methodErrorHandler);
            }
            return methodErrorHandlerMap;
        }

        Optional<ErrorHandling> readErrorHandlingIncludingInherited(Class<?> apiType) {
            ErrorHandling apiTypeAnnotation = Builder.getErrorHandlingAnnotation(apiType);
            if (apiTypeAnnotation != null) {
                return Optional.of(apiTypeAnnotation);
            }
            for (Class<?> parentInterface : apiType.getInterfaces()) {
                Optional<ErrorHandling> errorHandling = this.readErrorHandlingIncludingInherited(parentInterface);
                if (!errorHandling.isPresent()) continue;
                return errorHandling;
            }
            if (!apiType.isInterface() && !apiType.getSuperclass().equals(Object.class)) {
                return this.readErrorHandlingIncludingInherited(apiType.getSuperclass());
            }
            return Optional.empty();
        }

        private static ErrorHandling getErrorHandlingAnnotation(AnnotatedElement element) {
            ErrorHandling annotation = element.getAnnotation(ErrorHandling.class);
            if (annotation == null) {
                Annotation metaAnnotation;
                Annotation[] annotationArray = element.getAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n && (annotation = (metaAnnotation = annotationArray[i]).annotationType().getAnnotation(ErrorHandling.class)) == null; ++i) {
                }
            }
            return annotation;
        }

        static ErrorHandlingDefinition readAnnotation(ErrorHandling errorHandling, Decoder responseBodyDecoder) {
            ExceptionGenerator defaultException = new ExceptionGenerator.Builder().withResponseBodyDecoder(responseBodyDecoder).withExceptionType(errorHandling.defaultException()).build();
            HashMap<Integer, ExceptionGenerator> statusCodesDefinition = new HashMap<Integer, ExceptionGenerator>();
            for (ErrorCodes statusCodeDefinition : errorHandling.codeSpecific()) {
                for (int statusCode : statusCodeDefinition.codes()) {
                    if (statusCodesDefinition.containsKey(statusCode)) {
                        throw new IllegalStateException("Status Code [" + statusCode + "] has already been declared to throw [" + ((ExceptionGenerator)statusCodesDefinition.get(statusCode)).getExceptionType().getName() + "] and [" + statusCodeDefinition.generate() + "] - dupe definition");
                    }
                    statusCodesDefinition.put(statusCode, new ExceptionGenerator.Builder().withResponseBodyDecoder(responseBodyDecoder).withExceptionType(statusCodeDefinition.generate()).build());
                }
            }
            return new ErrorHandlingDefinition(defaultException, statusCodesDefinition);
        }

        private static class ErrorHandlingDefinition {
            private final ExceptionGenerator defaultThrow;
            private final Map<Integer, ExceptionGenerator> statusCodesMap;

            private ErrorHandlingDefinition(ExceptionGenerator defaultThrow, Map<Integer, ExceptionGenerator> statusCodesMap) {
                this.defaultThrow = defaultThrow;
                this.statusCodesMap = statusCodesMap;
            }
        }
    }
}

