/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql.apt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class SchemaLoader {
    private final Filer filer;
    private final Messager messager;

    public SchemaLoader(Filer filer, Messager messager) {
        this.filer = filer;
        this.messager = messager;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String load(String path, Element element) {
        StandardLocation[] locations;
        for (StandardLocation location : locations = new StandardLocation[]{StandardLocation.CLASS_PATH, StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT}) {
            try {
                FileObject resource = this.filer.getResource(location, "", path);
                try (InputStream is = resource.openInputStream();){
                    String string;
                    try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        int read;
                        StringBuilder sb = new StringBuilder();
                        char[] buf = new char[4096];
                        while ((read = reader.read(buf)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        string = sb.toString();
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
            }
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "GraphQL schema not found: " + path, element);
        return null;
    }
}

