/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql.apt;

import graphql.GraphQLError;
import graphql.language.Document;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLSchema;
import graphql.validation.Validator;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class QueryValidator {
    private final Messager messager;

    public QueryValidator(Messager messager) {
        this.messager = messager;
    }

    public boolean validate(GraphQLSchema schema, Document document, Element methodElement) {
        Validator validator = new Validator();
        List errors = validator.validateDocument(schema, document, Locale.ENGLISH);
        if (errors.isEmpty()) {
            return true;
        }
        for (GraphQLError error : errors) {
            List locations = error.getLocations();
            if (locations != null && !locations.isEmpty()) {
                SourceLocation loc = (SourceLocation)locations.get(0);
                this.messager.printMessage(Diagnostic.Kind.ERROR, "GraphQL validation error at line %d, column %d: %s".formatted(loc.getLine(), loc.getColumn(), error.getMessage()), methodElement);
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "GraphQL validation error: " + error.getMessage(), methodElement);
        }
        return false;
    }
}

