/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql.apt;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphqlTypeMapper {
    private static final Map<String, com.squareup.javapoet.TypeName> BUILT_IN_SCALARS = Map.of("String", ClassName.get(String.class), "Int", ClassName.get(Integer.class), "Float", ClassName.get(Double.class), "Boolean", ClassName.get(Boolean.class), "ID", ClassName.get(String.class));
    private final String targetPackage;
    private final Map<String, com.squareup.javapoet.TypeName> customScalars;

    public GraphqlTypeMapper(String targetPackage, Map<String, com.squareup.javapoet.TypeName> customScalars) {
        this.targetPackage = targetPackage;
        this.customScalars = new HashMap<String, com.squareup.javapoet.TypeName>(customScalars);
    }

    public com.squareup.javapoet.TypeName map(Type<?> type) {
        if (type instanceof NonNullType) {
            NonNullType nullType = (NonNullType)type;
            return this.map(nullType.getType());
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            com.squareup.javapoet.TypeName elementType = this.map(listType.getType());
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (com.squareup.javapoet.TypeName[])new com.squareup.javapoet.TypeName[]{elementType});
        }
        if (type instanceof TypeName) {
            TypeName name = (TypeName)type;
            return this.mapScalarOrNamed(name.getName());
        }
        return ClassName.get(String.class);
    }

    private com.squareup.javapoet.TypeName mapScalarOrNamed(String name) {
        com.squareup.javapoet.TypeName builtIn = BUILT_IN_SCALARS.get(name);
        if (builtIn != null) {
            return builtIn;
        }
        com.squareup.javapoet.TypeName custom = this.customScalars.get(name);
        if (custom != null) {
            return custom;
        }
        return ClassName.get((String)this.targetPackage, (String)name, (String[])new String[0]);
    }

    public boolean isScalar(String name) {
        return BUILT_IN_SCALARS.containsKey(name) || this.customScalars.containsKey(name);
    }
}

