/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql.apt;

import com.google.auto.service.AutoService;
import feign.graphql.GraphqlQuery;
import feign.graphql.GraphqlSchema;
import feign.graphql.Scalar;
import feign.graphql.apt.GraphqlTypeMapper;
import feign.graphql.apt.QueryValidator;
import feign.graphql.apt.SchemaLoader;
import feign.graphql.apt.TypeGenerator;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"feign.graphql.GraphqlSchema"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class GraphqlSchemaProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private static final Set<String> GRAPHQL_BUILT_IN_SCALARS = Set.of("String", "Int", "Float", "Boolean", "ID");
    private static final Set<String> JAVA_BUILT_INS = Set.of("String", "Integer", "Long", "Double", "Float", "Boolean", "Object", "Byte", "Short", "Character", "BigDecimal", "BigInteger");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(GraphqlSchema.class)) {
            if (!(element instanceof TypeElement)) continue;
            this.processInterface((TypeElement)element);
        }
        return true;
    }

    private void processInterface(TypeElement typeElement) {
        TypeDefinitionRegistry registry;
        SchemaLoader loader = new SchemaLoader(this.filer, this.messager);
        GraphqlSchema schemaAnnotation = typeElement.getAnnotation(GraphqlSchema.class);
        String schemaPath = schemaAnnotation.value();
        String schemaContent = loader.load(schemaPath, typeElement);
        if (schemaContent == null) {
            return;
        }
        SchemaParser schemaParser = new SchemaParser();
        try {
            registry = schemaParser.parse(schemaContent);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to parse GraphQL schema: " + e.getMessage(), typeElement);
            return;
        }
        Map<String, com.squareup.javapoet.TypeName> customScalars = this.collectScalarMappings(typeElement);
        if (!this.validateCustomScalars(registry, customScalars, typeElement)) {
            return;
        }
        GraphQLSchema graphqlSchema = UnExecutableSchemaGenerator.makeUnExecutableSchema((TypeDefinitionRegistry)registry);
        boolean generateTypes = schemaAnnotation.generateTypes();
        String targetPackage = this.getPackageName(typeElement);
        GraphqlTypeMapper typeMapper = new GraphqlTypeMapper(targetPackage, customScalars);
        QueryValidator validator = new QueryValidator(this.messager);
        TypeGenerator generator = new TypeGenerator(this.filer, this.messager, registry, typeMapper, targetPackage);
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement method;
            GraphqlQuery queryAnnotation;
            if (!(element instanceof ExecutableElement) || (queryAnnotation = (method = (ExecutableElement)element).getAnnotation(GraphqlQuery.class)) == null) continue;
            this.processMethod(method, queryAnnotation, graphqlSchema, registry, generator, validator, generateTypes, targetPackage);
        }
    }

    private Map<String, com.squareup.javapoet.TypeName> collectScalarMappings(TypeElement typeElement) {
        HashMap<String, com.squareup.javapoet.TypeName> scalars = new HashMap<String, com.squareup.javapoet.TypeName>();
        this.collectScalarsFromType(typeElement, scalars);
        this.collectScalarsFromParents(typeElement, scalars);
        return scalars;
    }

    private void collectScalarsFromType(TypeElement typeElement, Map<String, com.squareup.javapoet.TypeName> scalars) {
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement method;
            Scalar scalarAnnotation;
            if (!(element instanceof ExecutableElement) || (scalarAnnotation = (method = (ExecutableElement)element).getAnnotation(Scalar.class)) == null) continue;
            String scalarName = scalarAnnotation.value();
            com.squareup.javapoet.TypeName javaType = com.squareup.javapoet.TypeName.get((TypeMirror)method.getReturnType());
            scalars.put(scalarName, javaType);
        }
    }

    private void collectScalarsFromParents(TypeElement typeElement, Map<String, com.squareup.javapoet.TypeName> scalars) {
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType type;
            Element element;
            if (!(typeMirror instanceof DeclaredType) || !((element = (type = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            TypeElement parentType = (TypeElement)element;
            this.collectScalarsFromType(parentType, scalars);
            this.collectScalarsFromParents(parentType, scalars);
        }
    }

    private boolean validateCustomScalars(TypeDefinitionRegistry registry, Map<String, com.squareup.javapoet.TypeName> customScalars, TypeElement typeElement) {
        Map schemaScalars = registry.scalars();
        boolean valid = true;
        for (String scalarName : schemaScalars.keySet()) {
            if (GRAPHQL_BUILT_IN_SCALARS.contains(scalarName) || customScalars.containsKey(scalarName)) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Custom scalar '" + scalarName + "' is used in the schema but no @Scalar(\"" + scalarName + "\") method is defined. Add a @Scalar(\"" + scalarName + "\") default method to this interface or a parent interface.", typeElement);
            valid = false;
        }
        return valid;
    }

    private void processMethod(ExecutableElement method, GraphqlQuery queryAnnotation, GraphQLSchema graphqlSchema, TypeDefinitionRegistry registry, TypeGenerator generator, QueryValidator validator, boolean generateTypes, String targetPackage) {
        String fieldTypeName;
        ObjectTypeDefinition fieldObjectType;
        FieldDefinition fieldDefinition;
        Field rootField;
        ObjectTypeDefinition rootType;
        Document document;
        String queryString = queryAnnotation.value();
        try {
            document = Parser.parse((String)queryString);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to parse GraphQL query: " + e.getMessage(), method);
            return;
        }
        if (!validator.validate(graphqlSchema, document, method) || !generateTypes) {
            return;
        }
        OperationDefinition operation = this.findOperation(document);
        if (operation == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "No operation definition found in GraphQL query", method);
            return;
        }
        String returnTypeName = this.getSimpleTypeName(method.getReturnType());
        if (returnTypeName != null && !this.isExistingExternalType(method.getReturnType(), targetPackage) && (rootType = this.getRootType(operation, registry)) != null && (rootField = this.findRootField(operation.getSelectionSet())) != null && rootField.getSelectionSet() != null && (fieldDefinition = this.findFieldDefinition(rootType, rootField.getName())) != null && (fieldObjectType = (ObjectTypeDefinition)registry.getType(fieldTypeName = this.unwrapTypeName(fieldDefinition.getType()), ObjectTypeDefinition.class).orElse(null)) != null) {
            generator.generateResultType(returnTypeName, rootField.getSelectionSet(), fieldObjectType, method);
        }
        List<? extends VariableElement> params = method.getParameters();
        List variableDefs = operation.getVariableDefinitions();
        for (VariableElement variableElement : params) {
            String graphqlInputTypeName;
            String paramTypeName = this.getSimpleTypeName(variableElement.asType());
            if (paramTypeName == null || this.isJavaBuiltIn(paramTypeName) || this.isExistingExternalType(variableElement.asType(), targetPackage) || (graphqlInputTypeName = this.findGraphqlInputType(paramTypeName, variableDefs)) == null) continue;
            generator.generateInputType(paramTypeName, graphqlInputTypeName, method);
        }
    }

    private OperationDefinition findOperation(Document document) {
        for (Definition def : document.getDefinitions()) {
            if (!(def instanceof OperationDefinition)) continue;
            OperationDefinition definition = (OperationDefinition)def;
            return definition;
        }
        return null;
    }

    private Field findRootField(SelectionSet selectionSet) {
        if (selectionSet == null) {
            return null;
        }
        for (Selection selection : selectionSet.getSelections()) {
            if (!(selection instanceof Field)) continue;
            Field field = (Field)selection;
            return field;
        }
        return null;
    }

    private FieldDefinition findFieldDefinition(ObjectTypeDefinition typeDef, String fieldName) {
        for (FieldDefinition fd : typeDef.getFieldDefinitions()) {
            if (!fd.getName().equals(fieldName)) continue;
            return fd;
        }
        return null;
    }

    private ObjectTypeDefinition getRootType(OperationDefinition operation, TypeDefinitionRegistry registry) {
        String rootTypeName = switch (operation.getOperation()) {
            case OperationDefinition.Operation.MUTATION -> registry.schemaDefinition().flatMap(sd -> sd.getOperationTypeDefinitions().stream().filter(otd -> otd.getName().equals("mutation")).findFirst()).map(otd -> otd.getTypeName().getName()).orElse("Mutation");
            case OperationDefinition.Operation.SUBSCRIPTION -> registry.schemaDefinition().flatMap(sd -> sd.getOperationTypeDefinitions().stream().filter(otd -> otd.getName().equals("subscription")).findFirst()).map(otd -> otd.getTypeName().getName()).orElse("Subscription");
            default -> registry.schemaDefinition().flatMap(sd -> sd.getOperationTypeDefinitions().stream().filter(otd -> otd.getName().equals("query")).findFirst()).map(otd -> otd.getTypeName().getName()).orElse("Query");
        };
        return registry.getType(rootTypeName, ObjectTypeDefinition.class).orElse(null);
    }

    private String findGraphqlInputType(String javaParamTypeName, List<VariableDefinition> variableDefs) {
        for (VariableDefinition varDef : variableDefs) {
            String graphqlTypeName = this.unwrapTypeName(varDef.getType());
            if (!graphqlTypeName.equals(javaParamTypeName)) continue;
            return graphqlTypeName;
        }
        return javaParamTypeName;
    }

    private String unwrapTypeName(Type<?> type) {
        if (type instanceof NonNullType) {
            NonNullType nullType = (NonNullType)type;
            return this.unwrapTypeName(nullType.getType());
        }
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            return this.unwrapTypeName(listType.getType());
        }
        if (type instanceof TypeName) {
            TypeName name = (TypeName)type;
            return name.getName();
        }
        return "String";
    }

    private boolean isJavaBuiltIn(String typeName) {
        return JAVA_BUILT_INS.contains(typeName);
    }

    private String getSimpleTypeName(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            List<? extends TypeMirror> typeArgs;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element typeElement = declaredType.asElement();
            String simpleName = typeElement.getSimpleName().toString();
            if ("List".equals(simpleName) && !(typeArgs = declaredType.getTypeArguments()).isEmpty()) {
                return this.getSimpleTypeName(typeArgs.get(0));
            }
            return simpleName;
        }
        return null;
    }

    private boolean isExistingExternalType(TypeMirror typeMirror, String targetPackage) {
        DeclaredType type;
        Element element;
        TypeMirror unwrapped = this.unwrapListTypeMirror(typeMirror);
        if (unwrapped.getKind() == TypeKind.ERROR) {
            return false;
        }
        if (unwrapped instanceof DeclaredType && (element = (type = (DeclaredType)unwrapped).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            String qualifiedName = typeElement.getQualifiedName().toString();
            int lastDot = qualifiedName.lastIndexOf(46);
            String typePkg = lastDot > 0 ? qualifiedName.substring(0, lastDot) : "";
            return !typePkg.equals(targetPackage);
        }
        return false;
    }

    private TypeMirror unwrapListTypeMirror(TypeMirror typeMirror) {
        List<? extends TypeMirror> typeArgs;
        DeclaredType declaredType;
        String simpleName;
        if (typeMirror instanceof DeclaredType && "List".equals(simpleName = (declaredType = (DeclaredType)typeMirror).asElement().getSimpleName().toString()) && !(typeArgs = declaredType.getTypeArguments()).isEmpty()) {
            return typeArgs.get(0);
        }
        return typeMirror;
    }

    private String getPackageName(TypeElement typeElement) {
        Element enclosing = typeElement.getEnclosingElement();
        while (enclosing != null && !(enclosing instanceof PackageElement)) {
            enclosing = enclosing.getEnclosingElement();
        }
        if (enclosing instanceof PackageElement) {
            PackageElement element = (PackageElement)enclosing;
            return element.getQualifiedName().toString();
        }
        return "";
    }
}

