/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.util.Arrays;
import org.ton.java.utils.Utils;

public class Secp256k1KeyPair {
    public byte[] privateKey;
    public byte[] publicKey;

    public byte[] publicKeyNoPrefix() {
        return Utils.slice(this.publicKey, 1, this.publicKey.length - 1);
    }

    Secp256k1KeyPair(byte[] privateKey, byte[] publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static Secp256k1KeyPairBuilder builder() {
        return new Secp256k1KeyPairBuilder();
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secp256k1KeyPair)) {
            return false;
        }
        Secp256k1KeyPair other = (Secp256k1KeyPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPrivateKey(), other.getPrivateKey())) {
            return false;
        }
        return Arrays.equals(this.getPublicKey(), other.getPublicKey());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Secp256k1KeyPair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPrivateKey());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        return result;
    }

    public String toString() {
        return "Secp256k1KeyPair(privateKey=" + Arrays.toString(this.getPrivateKey()) + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ")";
    }

    public static class Secp256k1KeyPairBuilder {
        private byte[] privateKey;
        private byte[] publicKey;

        Secp256k1KeyPairBuilder() {
        }

        public Secp256k1KeyPairBuilder privateKey(byte[] privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Secp256k1KeyPairBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Secp256k1KeyPair build() {
            return new Secp256k1KeyPair(this.privateKey, this.publicKey);
        }

        public String toString() {
            return "Secp256k1KeyPair.Secp256k1KeyPairBuilder(privateKey=" + Arrays.toString(this.privateKey) + ", publicKey=" + Arrays.toString(this.publicKey) + ")";
        }
    }
}

