/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.math.BigInteger;
import org.ton.java.utils.ByteUtils;
import org.ton.java.utils.CRC32C;

public final class CRC32Utils {
    private CRC32Utils() {
    }

    public static Long getCRC32ChecksumAsLong(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return 0L;
        }
        CRC32C crc32c = new CRC32C();
        crc32c.update(bytes, 0, bytes.length);
        return crc32c.getValue() & 0xFFFFFFFFL;
    }

    public static String getCRC32ChecksumAsHex(byte[] bytes) {
        return BigInteger.valueOf(CRC32Utils.getCRC32ChecksumAsLong(bytes)).toString(16);
    }

    public static byte[] getCRC32ChecksumAsBytes(byte[] bytes) {
        return ByteUtils.long4BytesToBytes(CRC32Utils.getCRC32ChecksumAsLong(bytes));
    }

    public static byte[] getCRC32ChecksumAsBytesReversed(byte[] bytes) {
        byte[] b = ByteUtils.long4BytesToBytes(CRC32Utils.getCRC32ChecksumAsLong(bytes));
        byte[] reversed = new byte[]{b[3], b[2], b[1], b[0]};
        return reversed;
    }
}

