/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ByteUtils {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final Map<String, byte[]> HEX_TO_BYTES_CACHE = new ConcurrentHashMap<String, byte[]>(256);

    private ByteUtils() {
    }

    public static String bytesToHex(byte[] raw) {
        if (raw == null || raw.length == 0) {
            return "";
        }
        int len = raw.length;
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int v = raw[i] & 0xFF;
            hexChars[j++] = HEX_CHARS[v >>> 4];
            hexChars[j++] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToSignedBytes(String hex) {
        byte[] cached;
        if (hex == null || hex.isEmpty()) {
            return new byte[0];
        }
        if (hex.length() == 2 && (cached = HEX_TO_BYTES_CACHE.get(hex.toLowerCase())) != null) {
            return (byte[])cached.clone();
        }
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] slice(byte[] src, int from, int size) {
        if (src == null) {
            return new byte[0];
        }
        if (from < 0 || size < 0 || from + size > src.length) {
            throw new IllegalArgumentException("Invalid slice parameters");
        }
        byte[] resultArray = new byte[size];
        System.arraycopy(src, from, resultArray, 0, size);
        return resultArray;
    }

    public static byte[] concatBytes(byte[] a, byte[] b) {
        if (a == null) {
            return b != null ? (byte[])b.clone() : new byte[]{};
        }
        if (b == null) {
            return (byte[])a.clone();
        }
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] signedBytesToUnsigned(byte[] bytes) {
        if (bytes == null) {
            return new int[0];
        }
        int[] converted = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            converted[i] = bytes[i] & 0xFF;
        }
        return converted;
    }

    public static byte[] unsignedBytesToSigned(int[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        byte[] converted = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            converted[i] = (byte)(bytes[i] & 0xFF);
        }
        return converted;
    }

    public static byte[] long4BytesToBytes(long l) {
        byte[] result = new byte[4];
        result[3] = (byte)(l & 0xFFL);
        result[2] = (byte)(l >> 8 & 0xFFL);
        result[1] = (byte)(l >> 16 & 0xFFL);
        result[0] = (byte)(l >> 24 & 0xFFL);
        return result;
    }

    public static int[] longToBytes(long l) {
        int[] result = new int[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (int)l & 0xFF;
            l >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] b) {
        if (b == null || b.length < 8) {
            throw new IllegalArgumentException("Byte array must be at least 8 bytes long");
        }
        return ((long)b[0] & 0xFFL) << 56 | ((long)b[1] & 0xFFL) << 48 | ((long)b[2] & 0xFFL) << 40 | ((long)b[3] & 0xFFL) << 32 | ((long)b[4] & 0xFFL) << 24 | ((long)b[5] & 0xFFL) << 16 | ((long)b[6] & 0xFFL) << 8 | (long)b[7] & 0xFFL;
    }

    public static int bytesToInt(byte[] b) {
        if (b == null || b.length < 4) {
            throw new IllegalArgumentException("Byte array must be at least 4 bytes long");
        }
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static int bytesToIntX(byte[] b) {
        if (b == null || b.length == 0) {
            return 0;
        }
        int result = 0;
        for (byte value : b) {
            result = result << 8 | value & 0xFF;
        }
        return result;
    }

    public static short bytesToShort(byte[] b) {
        if (b == null || b.length < 2) {
            throw new IllegalArgumentException("Byte array must be at least 2 bytes long");
        }
        return (short)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
    }

    public static long intsToLong(int[] b) {
        if (b == null || b.length < 8) {
            throw new IllegalArgumentException("Int array must be at least 8 elements long");
        }
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result = result << 8 | (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static int intsToInt(int[] b) {
        if (b == null || b.length < 4) {
            throw new IllegalArgumentException("Int array must be at least 4 elements long");
        }
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static short intsToShort(int[] b) {
        if (b == null || b.length < 2) {
            throw new IllegalArgumentException("Int array must be at least 2 elements long");
        }
        return (short)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
    }

    public static int[] intToIntArray(int l) {
        return new int[]{l};
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    public static void intToByteArrayOptimized(int value, byte[] buffer) {
        if (buffer == null || buffer.length < 4) {
            throw new IllegalArgumentException("Buffer must be at least 4 bytes long");
        }
        buffer[0] = (byte)(value >>> 24);
        buffer[1] = (byte)(value >>> 16);
        buffer[2] = (byte)(value >>> 8);
        buffer[3] = (byte)value;
    }

    public static String bytesToHex(int[] raw) {
        if (raw == null || raw.length == 0) {
            return "";
        }
        int len = raw.length;
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int v = raw[i] & 0xFF;
            hexChars[j++] = HEX_CHARS[v >>> 4];
            hexChars[j++] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            String hex = String.format("%02x", i);
            HEX_TO_BYTES_CACHE.put(hex, new byte[]{(byte)i});
        }
    }
}

