/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib.types;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Deque;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.tonlib.types.TvmCell;
import org.ton.java.tonlib.types.TvmNumber;
import org.ton.java.tonlib.types.TvmSlice;
import org.ton.java.tonlib.types.TvmStackEntry;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.tonlib.types.TvmStackEntryTuple;
import org.ton.java.utils.Utils;

public class ParseRunResult
implements Serializable {
    private static final Gson gson = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).setLenient().create();

    public static TvmStackEntry renderTvmElement(String elementType, String element) {
        String[] values = new String[]{"num", "number", "int", "cell", "slice", "tvm.cell", "tvm.slice"};
        if (Arrays.asList(values).contains(elementType)) {
            if (elementType.contains("num") || elementType.contains("number") || elementType.contains("int")) {
                return TvmStackEntryNumber.builder().number(TvmNumber.builder().number(element).build()).build();
            }
            if (elementType.contains("cell")) {
                byte[] e = Utils.hexToSignedBytes((String)element);
                Cell cell = CellBuilder.beginCell().fromBoc(e).endCell();
                String cellBase64 = ParseRunResult.bytesToBase64(cell.toBoc(false));
                return TvmStackEntryCell.builder().cell(TvmCell.builder().bytes(cellBase64).build()).build();
            }
            if (elementType.contains("slice")) {
                byte[] e = Utils.hexToSignedBytes((String)element);
                Cell cell = CellBuilder.beginCell().fromBoc(e).endCell();
                String cellBase64 = ParseRunResult.bytesToBase64(cell.toBoc(false));
                return TvmStackEntrySlice.builder().slice(TvmSlice.builder().bytes(cellBase64).build()).build();
            }
            if (!elementType.contains("dict") && !elementType.contains("list") && elementType.contains("tuple")) {
                // empty if block
            }
        } else {
            throw new Error("Rendering of type " + elementType + " is not implemented");
        }
        return TvmStackEntryCell.builder().build();
    }

    public static Deque<TvmStackEntry> renderTvmStack(Deque<String> stackData) {
        ArrayDeque<TvmStackEntry> stack = new ArrayDeque<TvmStackEntry>();
        for (String e : stackData) {
            String[] a = e.replace("[", "").replace("]", "").split(",");
            String type = a[0].trim();
            String data = a[1].trim();
            stack.offer(ParseRunResult.renderTvmElement(type, data));
        }
        return stack;
    }

    public static String serializeTvmElement(TvmStackEntry entry) {
        if (entry instanceof TvmStackEntryNumber) {
            return String.format("[\"%s\",%x]", "num", ((TvmStackEntryNumber)entry).getNumber());
        }
        if (entry instanceof TvmStackEntryCell) {
            return String.format("[\"%s\",%s]", "cell", ((TvmStackEntryCell)entry).getCell().getBytes());
        }
        if (entry instanceof TvmStackEntrySlice) {
            return String.format("[\"%s\",%s]", "cell", ((TvmStackEntrySlice)entry).getSlice().getBytes());
        }
        if (entry instanceof TvmStackEntryTuple) {
            return String.format("[\"%s\",%s]", "tuple", ((TvmStackEntryTuple)entry).getTuple());
        }
        if (entry instanceof TvmStackEntryList) {
            return String.format("[\"%s\",%s]", "list", ((TvmStackEntryList)entry).getList());
        }
        throw new Error("Unknown type");
    }

    public static Deque<String> serializeTvmStack(Deque<TvmStackEntry> tvmStack) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (TvmStackEntry e : tvmStack) {
            stack.offer(ParseRunResult.serializeTvmElement(e));
        }
        return stack;
    }

    private static String bytesToBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static String bytesToBase64(int[] unsignedBytes) {
        return Base64.getEncoder().encodeToString(Utils.unsignedBytesToSigned((int[])unsignedBytes));
    }

    private static String bytesToBase64UrlSafe(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    private static String sbb(String str, String pattern) {
        if (Objects.isNull(str) || !str.contains(pattern)) {
            return null;
        }
        int openindex = str.indexOf(pattern) + pattern.indexOf("{");
        int closeIndex = ParseRunResult.findPosOfClosingBracket(str, pattern);
        if (closeIndex == -1) {
            return null;
        }
        return str.substring(openindex, closeIndex + 1).trim();
    }

    private static int findPosOfClosingBracket(String str, String pattern) {
        int openBracketIndex = pattern.indexOf("{");
        int index = str.indexOf(pattern) + openBracketIndex;
        ArrayDeque<Integer> st = new ArrayDeque<Integer>();
        for (int i = index; i < str.length(); ++i) {
            if (str.charAt(i) == '{') {
                st.push(Integer.valueOf(str.charAt(i)));
                continue;
            }
            if (str.charAt(i) != '}') continue;
            if (st.isEmpty()) {
                return i;
            }
            st.pop();
            if (!st.isEmpty()) continue;
            return i;
        }
        return -1;
    }
}

