/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.ConfigParams0;
import org.ton.java.tlb.ConfigParams1;
import org.ton.java.tlb.ConfigParams10;
import org.ton.java.tlb.ConfigParams11;
import org.ton.java.tlb.ConfigParams12;
import org.ton.java.tlb.ConfigParams13;
import org.ton.java.tlb.ConfigParams14;
import org.ton.java.tlb.ConfigParams15;
import org.ton.java.tlb.ConfigParams16;
import org.ton.java.tlb.ConfigParams17;
import org.ton.java.tlb.ConfigParams18;
import org.ton.java.tlb.ConfigParams19;
import org.ton.java.tlb.ConfigParams2;
import org.ton.java.tlb.ConfigParams20;
import org.ton.java.tlb.ConfigParams21;
import org.ton.java.tlb.ConfigParams22;
import org.ton.java.tlb.ConfigParams23;
import org.ton.java.tlb.ConfigParams24;
import org.ton.java.tlb.ConfigParams25;
import org.ton.java.tlb.ConfigParams28;
import org.ton.java.tlb.ConfigParams29;
import org.ton.java.tlb.ConfigParams3;
import org.ton.java.tlb.ConfigParams31;
import org.ton.java.tlb.ConfigParams32;
import org.ton.java.tlb.ConfigParams33;
import org.ton.java.tlb.ConfigParams34;
import org.ton.java.tlb.ConfigParams35;
import org.ton.java.tlb.ConfigParams36;
import org.ton.java.tlb.ConfigParams37;
import org.ton.java.tlb.ConfigParams39;
import org.ton.java.tlb.ConfigParams4;
import org.ton.java.tlb.ConfigParams40;
import org.ton.java.tlb.ConfigParams44;
import org.ton.java.tlb.ConfigParams45;
import org.ton.java.tlb.ConfigParams5;
import org.ton.java.tlb.ConfigParams6;
import org.ton.java.tlb.ConfigParams71;
import org.ton.java.tlb.ConfigParams72;
import org.ton.java.tlb.ConfigParams73;
import org.ton.java.tlb.ConfigParams79;
import org.ton.java.tlb.ConfigParams8;
import org.ton.java.tlb.ConfigParams81;
import org.ton.java.tlb.ConfigParams82;
import org.ton.java.tlb.ConfigParams9;
import org.ton.java.tlb.JettonBridgeParams;
import org.ton.java.tlb.JettonBridgeParamsV1;
import org.ton.java.tlb.OracleBridgeParams;
import org.ton.java.tlb.Transaction;
import org.ton.java.tlb.ValidatorSet;
import org.ton.java.tlb.Validators;
import org.ton.java.tonlib.LibraryResultParser;
import org.ton.java.tonlib.RunResultParser;
import org.ton.java.tonlib.TonlibJsonI;
import org.ton.java.tonlib.queries.BlockHeaderQuery;
import org.ton.java.tonlib.queries.CreateAndSendRawMessageQuery;
import org.ton.java.tonlib.queries.CreateQuery;
import org.ton.java.tonlib.queries.DecryptQuery;
import org.ton.java.tonlib.queries.DnsResolveQuery;
import org.ton.java.tonlib.queries.EncryptQuery;
import org.ton.java.tonlib.queries.EstimateFeesQuery;
import org.ton.java.tonlib.queries.GetAccountStateOnlyWithBlockQuery;
import org.ton.java.tonlib.queries.GetAccountStateQueryOnly;
import org.ton.java.tonlib.queries.GetBlockTransactionsExtQuery;
import org.ton.java.tonlib.queries.GetBlockTransactionsQuery;
import org.ton.java.tonlib.queries.GetConfigAllQuery;
import org.ton.java.tonlib.queries.GetConfigParamQuery;
import org.ton.java.tonlib.queries.GetLastQuery;
import org.ton.java.tonlib.queries.GetLibrariesExtQuery;
import org.ton.java.tonlib.queries.GetLibrariesQuery;
import org.ton.java.tonlib.queries.GetLiteServerInfoQuery;
import org.ton.java.tonlib.queries.GetRawAccountStateQueryOnly;
import org.ton.java.tonlib.queries.GetRawTransactionsQuery;
import org.ton.java.tonlib.queries.GetRawTransactionsV2Query;
import org.ton.java.tonlib.queries.GetShardsQuery;
import org.ton.java.tonlib.queries.LoadContractQuery;
import org.ton.java.tonlib.queries.LoadContractWithBlockQuery;
import org.ton.java.tonlib.queries.LookupBlockQuery;
import org.ton.java.tonlib.queries.MethodNumber;
import org.ton.java.tonlib.queries.MethodString;
import org.ton.java.tonlib.queries.NewKeyQuery;
import org.ton.java.tonlib.queries.RawGetAccountStateOnlyWithBlockQuery;
import org.ton.java.tonlib.queries.RunMethodIntQuery;
import org.ton.java.tonlib.queries.RunMethodStrQuery;
import org.ton.java.tonlib.queries.SendQuery;
import org.ton.java.tonlib.queries.SendRawMessageQuery;
import org.ton.java.tonlib.types.AccountAddressOnly;
import org.ton.java.tonlib.types.AccountTransactionId;
import org.ton.java.tonlib.types.BlockHeader;
import org.ton.java.tonlib.types.BlockId;
import org.ton.java.tonlib.types.BlockIdExt;
import org.ton.java.tonlib.types.BlockTransactions;
import org.ton.java.tonlib.types.BlockTransactionsExt;
import org.ton.java.tonlib.types.ConfigInfo;
import org.ton.java.tonlib.types.Data;
import org.ton.java.tonlib.types.Destination;
import org.ton.java.tonlib.types.DnsResolved;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.FullAccountState;
import org.ton.java.tonlib.types.Key;
import org.ton.java.tonlib.types.LastTransactionId;
import org.ton.java.tonlib.types.LiteServerVersion;
import org.ton.java.tonlib.types.LoadContract;
import org.ton.java.tonlib.types.MasterChainInfo;
import org.ton.java.tonlib.types.Ok;
import org.ton.java.tonlib.types.ParseRunResult;
import org.ton.java.tonlib.types.Participant;
import org.ton.java.tonlib.types.QueryFees;
import org.ton.java.tonlib.types.QueryInfo;
import org.ton.java.tonlib.types.RawAccountState;
import org.ton.java.tonlib.types.RawMessage;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RawTransactions;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.Shards;
import org.ton.java.tonlib.types.ShortTxId;
import org.ton.java.tonlib.types.SmcLibraryQueryExt;
import org.ton.java.tonlib.types.SmcLibraryResult;
import org.ton.java.tonlib.types.TonlibError;
import org.ton.java.tonlib.types.TvmStackEntry;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntryTuple;
import org.ton.java.tonlib.types.TvmTuple;
import org.ton.java.tonlib.types.UpdateSyncState;
import org.ton.java.tonlib.types.VerbosityLevel;
import org.ton.java.tonlib.types.globalconfig.KeyStoreTypeDirectory;
import org.ton.java.tonlib.types.globalconfig.KeyStoreTypeMemory;
import org.ton.java.tonlib.types.globalconfig.LiteServers;
import org.ton.java.tonlib.types.globalconfig.TonGlobalConfig;
import org.ton.java.tonlib.types.globalconfig.TonlibConfig;
import org.ton.java.tonlib.types.globalconfig.TonlibOptions;
import org.ton.java.tonlib.types.globalconfig.TonlibSetup;
import org.ton.java.utils.Utils;

public class Tonlib {
    private static final Logger log = LoggerFactory.getLogger(Tonlib.class);
    public static final Address ELECTION_ADDRESS = Address.of((String)"-1:3333333333333333333333333333333333333333333333333333333333333333");
    public String pathToTonlibSharedLib;
    public String pathToGlobalConfig;
    private String globalConfigAsString;
    private TonGlobalConfig globalConfigAsObject;
    private VerbosityLevel verbosityLevel;
    private Boolean ignoreCache;
    private boolean testnet;
    private boolean keystoreInMemory;
    private String keystorePath;
    private Integer liteServerIndex;
    private Boolean usingAllLiteServers;
    public static TonGlobalConfig originalGlobalConfigInternal;
    public static String originalGlobalConfigStr;
    private int receiveRetryTimes;
    private double receiveTimeout;
    private static TonlibJsonI tonlibJson;
    private Boolean printInfo;
    private static final Gson gson;
    private static Pointer tonlib;
    private Map<String, String> sent;
    private Map<String, String> received;

    public static TonlibBuilder builder() {
        return new CustomTonlibBuilder();
    }

    private void reinitTonlibConfig(TonGlobalConfig tonGlobalConfig) {
        this.destroy();
        tonlibJson = (TonlibJsonI)Native.load((String)this.pathToTonlibSharedLib, TonlibJsonI.class);
        Utils.disableNativeOutput((int)this.verbosityLevel.ordinal());
        tonlib = tonlibJson.tonlib_client_json_create();
        tonlibJson.tonlib_client_set_verbosity_level(this.verbosityLevel.ordinal());
        TonlibSetup tonlibSetup = TonlibSetup.builder().type("init").options(TonlibOptions.builder().type("options").config(TonlibConfig.builder().type("config").config(gson.toJson((Object)tonGlobalConfig)).use_callbacks_for_network(false).blockchain_name("").ignore_cache(this.ignoreCache).build()).keystore_type(this.keystoreInMemory ? KeyStoreTypeMemory.builder().type("keyStoreTypeInMemory").build() : KeyStoreTypeDirectory.builder().type("keyStoreTypeDirectory").directory(this.keystorePath.equals(".") ? "." : this.keystorePath).build()).build()).build();
        tonlibJson.tonlib_client_json_send(tonlib, gson.toJson((Object)tonlibSetup));
        tonlibJson.tonlib_client_json_receive(tonlib, this.receiveTimeout);
        Utils.enableNativeOutput((int)this.verbosityLevel.ordinal());
    }

    public void destroy() {
        Utils.disableNativeOutput((int)this.verbosityLevel.ordinal());
        tonlibJson.tonlib_client_json_destroy(tonlib);
        Utils.enableNativeOutput((int)this.verbosityLevel.ordinal());
    }

    private String receive(String queryExtraId) {
        String result;
        do {
            if (Objects.isNull(result = tonlibJson.tonlib_client_json_receive(tonlib, this.receiveTimeout))) {
                return "";
            }
            String responseExtraId = this.extractExtra(result);
            if (StringUtils.isNotEmpty((CharSequence)responseExtraId)) {
                this.received.put(responseExtraId, "");
            }
            if (result.contains("updateSyncState") || result.contains("syncStateDone") || result.contains("syncStateInProgress")) {
                return result;
            }
            if (!this.received.containsKey(queryExtraId)) continue;
            this.sent.remove(queryExtraId);
            this.received.remove(queryExtraId);
            return result;
        } while (!this.received.containsKey(queryExtraId));
        return result;
    }

    private String extractExtra(String query) {
        if (StringUtils.countMatches((CharSequence)query, (CharSequence)"@extra") > 1) {
            String q = query.replaceFirst("@extra", "");
            return StringUtils.substringBetween((String)q, (String)"@extra\":\"", (String)"\"}");
        }
        return StringUtils.substringBetween((String)query, (String)"@extra\":\"", (String)"\"}");
    }

    private synchronized String syncAndRead(String query) {
        String response = "";
        String queryExtraId = this.extractExtra(query);
        if (StringUtils.isNotEmpty((CharSequence)queryExtraId)) {
            this.sent.put(queryExtraId, "");
        }
        int retry = 0;
        do {
            UpdateSyncState sync;
            String responseExtraId;
            if (response.contains("syncStateInProgress") || response.contains("syncStateDone")) {
                response = this.receive(queryExtraId);
            } else {
                tonlibJson.tonlib_client_json_send(tonlib, query);
                response = this.receive(queryExtraId);
            }
            if (response.contains(" : duplicate message\"") || response.contains(": not in db\"") || response.contains("Failed to unpack account state") || response.contains(": cannot apply external message to current state")) {
                return response;
            }
            if (StringUtils.isEmpty((CharSequence)response) || response.contains("error")) {
                if (!StringUtils.isEmpty((CharSequence)response)) {
                    log.info(response);
                }
                if (++retry > this.receiveRetryTimes) {
                    throw new Error("Error in tonlib.receive(), " + this.receiveRetryTimes + " times was not able retrieve result from lite-server.");
                }
                if (this.usingAllLiteServers.booleanValue() && retry < originalGlobalConfigInternal.getLiteservers().length) {
                    TonGlobalConfig globalConfigCurrent = (TonGlobalConfig)gson.fromJson(originalGlobalConfigStr, TonGlobalConfig.class);
                    LiteServers[] liteServers = originalGlobalConfigInternal.getLiteservers();
                    LiteServers[] newLiteServers = new LiteServers[]{liteServers[retry % originalGlobalConfigInternal.getLiteservers().length]};
                    globalConfigCurrent.setLiteservers(newLiteServers);
                    log.info("Trying next lite-server at index: " + retry % originalGlobalConfigInternal.getLiteservers().length + " (" + Utils.int2ip((long)globalConfigCurrent.getLiteservers()[0].getIp()) + ")");
                    this.reinitTonlibConfig(globalConfigCurrent);
                }
            } else if (response.contains("\"@type\":\"ok\"") ? (queryExtraId = this.extractExtra(query)).equals(responseExtraId = this.extractExtra(response)) : !response.contains("syncStateDone") && !response.contains("syncStateInProgress")) {
                return response;
            }
            if (Objects.nonNull(sync = (UpdateSyncState)gson.fromJson(response, UpdateSyncState.class)) && Objects.nonNull(sync.getSync_state()) && sync.getType().equals("updateSyncState") && !response.contains("syncStateDone")) {
                double pct = 0.0;
                if (sync.getSync_state().getTo_seqno() != 0L && (pct = (double)(sync.getSync_state().getCurrent_seqno() * 100L) / (double)sync.getSync_state().getTo_seqno()) < 99.5) {
                    log.info("Synchronizing: " + String.format("%.2f%%", pct));
                }
            }
            Utils.sleepMs((long)20L);
        } while (StringUtils.isEmpty((CharSequence)response) || response.contains("error") || response.contains("syncStateInProgress") || response.contains("syncStateDone"));
        return response;
    }

    public BlockIdExt lookupBlock(long seqno, long workchain, long shard, long lt, long utime) {
        int mode = 0;
        if (seqno != 0L) {
            ++mode;
        }
        if (lt != 0L) {
            mode += 2;
        }
        if (utime != 0L) {
            mode += 4;
        }
        LookupBlockQuery lookupBlockQuery = LookupBlockQuery.builder().mode(mode).id(BlockId.builder().seqno(seqno).workchain(workchain).shard(shard).build()).lt(lt).utime(utime).build();
        String result = this.syncAndRead(gson.toJson((Object)lookupBlockQuery));
        return (BlockIdExt)gson.fromJson(result, BlockIdExt.class);
    }

    public BlockIdExt lookupBlock(long seqno, long workchain, long shard, long lt) {
        return this.lookupBlock(seqno, workchain, shard, lt, 0L);
    }

    public MasterChainInfo getLast() {
        GetLastQuery getLastQuery = GetLastQuery.builder().build();
        String result = this.syncAndRead(gson.toJson((Object)getLastQuery));
        return (MasterChainInfo)gson.fromJson(result, MasterChainInfo.class);
    }

    public LiteServerVersion getLiteServerVersion() {
        GetLiteServerInfoQuery getLiteServerQuery = GetLiteServerInfoQuery.builder().build();
        String result = this.syncAndRead(gson.toJson((Object)getLiteServerQuery));
        return (LiteServerVersion)gson.fromJson(result, LiteServerVersion.class);
    }

    public MasterChainInfo getMasterChainInfo() {
        return this.getLast();
    }

    public Shards getShards(BlockIdExt id) {
        GetShardsQuery getShardsQuery = GetShardsQuery.builder().id(id).build();
        String result = this.syncAndRead(gson.toJson((Object)getShardsQuery));
        return (Shards)gson.fromJson(result, Shards.class);
    }

    public Shards getShards(long seqno, long lt, long unixtime) {
        if (seqno <= 0L && lt <= 0L && unixtime <= 0L) {
            throw new Error("Seqno, LT or unixtime should be defined");
        }
        long wc = -1L;
        long shard = Long.MIN_VALUE;
        BlockIdExt fullblock = this.lookupBlock(seqno, wc, shard, lt, unixtime);
        GetShardsQuery getShardsQuery = GetShardsQuery.builder().id(fullblock).build();
        String result = this.syncAndRead(gson.toJson((Object)getShardsQuery));
        return (Shards)gson.fromJson(result, Shards.class);
    }

    public Key createNewKey() {
        NewKeyQuery newKeyQuery = NewKeyQuery.builder().build();
        String result = this.syncAndRead(gson.toJson((Object)newKeyQuery));
        return (Key)gson.fromJson(result, Key.class);
    }

    public Data encrypt(String data, String secret) {
        EncryptQuery encryptQuery = EncryptQuery.builder().decrypted_data(data).secret(secret).build();
        String result = this.syncAndRead(gson.toJson((Object)encryptQuery));
        return (Data)gson.fromJson(result, Data.class);
    }

    public Data decrypt(String data, String secret) {
        DecryptQuery decryptQuery = DecryptQuery.builder().encrypted_data(data).secret(secret).build();
        String result = this.syncAndRead(gson.toJson((Object)decryptQuery));
        return (Data)gson.fromJson(result, Data.class);
    }

    public BlockHeader getBlockHeader(BlockIdExt fullblock) {
        BlockHeaderQuery blockHeaderQuery = BlockHeaderQuery.builder().id(fullblock).build();
        String result = this.syncAndRead(gson.toJson((Object)blockHeaderQuery));
        return (BlockHeader)gson.fromJson(result, BlockHeader.class);
    }

    public RawTransactions getRawTransactions(String address, BigInteger fromTxLt, String fromTxHash) {
        if (Objects.isNull(fromTxLt) || Objects.isNull(fromTxHash)) {
            RawAccountState fullAccountState = this.getRawAccountState((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build());
            fromTxLt = fullAccountState.getLast_transaction_id().getLt();
            fromTxHash = fullAccountState.getLast_transaction_id().getHash();
        }
        GetRawTransactionsQuery getRawTransactionsQuery = GetRawTransactionsQuery.builder().account_address((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build()).from_transaction_id(LastTransactionId.builder().lt(fromTxLt).hash(fromTxHash).build()).build();
        String result = this.syncAndRead(gson.toJson((Object)getRawTransactionsQuery));
        return (RawTransactions)gson.fromJson(result, RawTransactions.class);
    }

    public RawTransactions getRawTransactionsV2(String address, BigInteger fromTxLt, String fromTxHash, int count, boolean tryDecodeMessage) {
        if (Objects.isNull(fromTxLt) || Objects.isNull(fromTxHash)) {
            RawAccountState fullAccountState = this.getRawAccountState((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build());
            fromTxLt = fullAccountState.getLast_transaction_id().getLt();
            fromTxHash = fullAccountState.getLast_transaction_id().getHash();
        }
        GetRawTransactionsV2Query getRawTransactionsQuery = GetRawTransactionsV2Query.builder().account_address((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build()).from_transaction_id(LastTransactionId.builder().lt(fromTxLt).hash(fromTxHash).build()).count(count).try_decode_message(tryDecodeMessage).build();
        String result = this.syncAndRead(gson.toJson((Object)getRawTransactionsQuery));
        return (RawTransactions)gson.fromJson(result, RawTransactions.class);
    }

    public RawTransactions getRawTransactions(String address, BigInteger fromTxLt, String fromTxHash, int limit) {
        GetRawTransactionsQuery getRawTransactionsQuery;
        String result;
        RawTransactions rawTransactions;
        if (Objects.isNull(fromTxLt) || Objects.isNull(fromTxHash)) {
            RawAccountState rawAccountState = this.getRawAccountState((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build());
            fromTxLt = rawAccountState.getLast_transaction_id().getLt();
            fromTxHash = rawAccountState.getLast_transaction_id().getHash();
        }
        if (Objects.isNull((rawTransactions = (RawTransactions)gson.fromJson(result = this.syncAndRead(gson.toJson((Object)(getRawTransactionsQuery = GetRawTransactionsQuery.builder().account_address((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build()).from_transaction_id(LastTransactionId.builder().lt(fromTxLt).hash(fromTxHash).build()).build()))), RawTransactions.class)).getTransactions())) {
            throw new Error("lite-server cannot return any transactions");
        }
        if (limit > rawTransactions.getTransactions().size()) {
            limit = rawTransactions.getTransactions().size();
        }
        return RawTransactions.builder().previous_transaction_id(rawTransactions.getPrevious_transaction_id()).transactions(rawTransactions.getTransactions().subList(0, limit)).build();
    }

    public RawTransactions getAllRawTransactions(String address, BigInteger fromTxLt, String fromTxHash, int historyLimit) {
        RawTransactions rawTransactions = this.getRawTransactions(address, fromTxLt, fromTxHash);
        if (Objects.isNull(rawTransactions.getTransactions())) {
            throw new Error("lite-server cannot return any transactions");
        }
        ArrayList<RawTransaction> transactions = new ArrayList<RawTransaction>(rawTransactions.getTransactions());
        while (rawTransactions.getPrevious_transaction_id().getLt().compareTo(BigInteger.ZERO) != 0) {
            if (Objects.isNull((rawTransactions = this.getRawTransactions(address, rawTransactions.getPrevious_transaction_id().getLt(), rawTransactions.getPrevious_transaction_id().getHash())).getTransactions()) && !transactions.isEmpty()) {
                return RawTransactions.builder().transactions(transactions).build();
            }
            transactions.addAll(rawTransactions.getTransactions());
            if (transactions.size() <= historyLimit) continue;
            return RawTransactions.builder().transactions(transactions.subList(0, historyLimit)).build();
        }
        if (historyLimit > transactions.size()) {
            return RawTransactions.builder().transactions(transactions).build();
        }
        return RawTransactions.builder().transactions(transactions.subList(0, historyLimit)).build();
    }

    public BlockTransactions getBlockTransactions(BlockIdExt fullblock, long count, long afterLt, String afterHash) {
        AccountTransactionId afterTx = AccountTransactionId.builder().account(afterHash).lt(afterLt).build();
        return this.getBlockTransactions(fullblock, count, afterTx);
    }

    public BlockTransactions getBlockTransactions(BlockIdExt fullblock, long count) {
        return this.getBlockTransactions(fullblock, count, null);
    }

    public BlockTransactions getBlockTransactions(BlockIdExt fullblock, long count, AccountTransactionId afterTx) {
        int mode = 7;
        if (Objects.nonNull(afterTx)) {
            mode = 135;
        }
        if (Objects.isNull(afterTx)) {
            afterTx = AccountTransactionId.builder().account("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=").lt(0L).build();
        }
        GetBlockTransactionsQuery getBlockTransactionsQuery = GetBlockTransactionsQuery.builder().id(fullblock).mode(mode).count(count).after(afterTx).build();
        String result = this.syncAndRead(gson.toJson((Object)getBlockTransactionsQuery));
        return (BlockTransactions)gson.fromJson(result, BlockTransactions.class);
    }

    public BlockTransactionsExt getBlockTransactionsExt(BlockIdExt fullblock, long count, AccountTransactionId afterTx) {
        int mode = 7;
        if (Objects.nonNull(afterTx)) {
            mode = 135;
        }
        if (Objects.isNull(afterTx)) {
            afterTx = AccountTransactionId.builder().account("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=").lt(0L).build();
        }
        GetBlockTransactionsExtQuery getBlockTransactionsExtQuery = GetBlockTransactionsExtQuery.builder().id(fullblock).mode(mode).count(count).after(afterTx).build();
        String result = this.syncAndRead(gson.toJson((Object)getBlockTransactionsExtQuery));
        return (BlockTransactionsExt)gson.fromJson(result, BlockTransactionsExt.class);
    }

    public Map<String, RawTransactions> getAllBlockTransactions(BlockIdExt fullblock, long count, AccountTransactionId afterTx) {
        HashMap<String, RawTransactions> totalTxs = new HashMap<String, RawTransactions>();
        BlockTransactions blockTransactions = this.getBlockTransactions(fullblock, count, afterTx);
        for (ShortTxId tx : blockTransactions.getTransactions()) {
            String addressHex = Utils.base64ToHexString((String)tx.getAccount());
            String address = Address.of((String)(fullblock.getWorkchain() + ":" + addressHex)).toString(false);
            RawTransactions rawTransactions = this.getRawTransactions(address, BigInteger.valueOf(tx.getLt()), tx.getHash());
            totalTxs.put(address + "|" + tx.getLt(), rawTransactions);
        }
        return totalTxs;
    }

    public RawAccountState getRawAccountState(AccountAddressOnly address) {
        GetRawAccountStateQueryOnly getAccountStateQuery = GetRawAccountStateQueryOnly.builder().account_address(address).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateQuery));
        return (RawAccountState)gson.fromJson(result, RawAccountState.class);
    }

    public RawAccountState getRawAccountState(Address address) {
        Object accountAddressOnly = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address.toString(false))).build();
        GetRawAccountStateQueryOnly getAccountStateQuery = GetRawAccountStateQueryOnly.builder().account_address((AccountAddressOnly)accountAddressOnly).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateQuery));
        return (RawAccountState)gson.fromJson(result, RawAccountState.class);
    }

    public RawAccountState getRawAccountState(Address address, BlockIdExt blockId) {
        if (StringUtils.isEmpty((CharSequence)blockId.getRoot_hash())) {
            if (StringUtils.isEmpty((CharSequence)(blockId = this.lookupBlock(blockId.getSeqno(), blockId.getWorkchain(), blockId.getShard(), 0L)).getRoot_hash())) {
                throw new Error("Cannot lookup block for hashes by seqno. Probably block not in db. Try to specify block's root and file hashes manually in base64 format.");
            }
            log.info("got hashes " + String.valueOf(blockId));
        }
        Object accountAddressOnly = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address.toString(false))).build();
        GetRawAccountStateQueryOnly getAccountStateQuery = GetRawAccountStateQueryOnly.builder().account_address((AccountAddressOnly)accountAddressOnly).build();
        RawGetAccountStateOnlyWithBlockQuery rawGetAccountStateOnlyWithBlockQuery = RawGetAccountStateOnlyWithBlockQuery.builder().id(blockId).function(getAccountStateQuery).build();
        String result = this.syncAndRead(gson.toJson((Object)rawGetAccountStateOnlyWithBlockQuery));
        if (Objects.isNull(result) || result.contains("@type") && result.contains("error")) {
            throw new Error("Cannot getRawAccountState, error" + result);
        }
        return (RawAccountState)gson.fromJson(result, RawAccountState.class);
    }

    public String getRawAccountStatus(Address address) {
        Object accountAddressOnly = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address.toString(false))).build();
        GetRawAccountStateQueryOnly getAccountStateQuery = GetRawAccountStateQueryOnly.builder().account_address((AccountAddressOnly)accountAddressOnly).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateQuery));
        RawAccountState state = (RawAccountState)gson.fromJson(result, RawAccountState.class);
        if (StringUtils.isEmpty((CharSequence)state.getCode())) {
            if (StringUtils.isEmpty((CharSequence)state.getFrozen_hash())) {
                return "uninitialized";
            }
            return "frozen";
        }
        return "active";
    }

    public FullAccountState getAccountState(AccountAddressOnly address) {
        GetAccountStateQueryOnly getAccountStateQuery = GetAccountStateQueryOnly.builder().account_address(address).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateQuery));
        return (FullAccountState)gson.fromJson(result, FullAccountState.class);
    }

    public FullAccountState getAccountState(Address address) {
        Object accountAddressOnly = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address.toString(false))).build();
        GetAccountStateQueryOnly getAccountStateQuery = GetAccountStateQueryOnly.builder().account_address((AccountAddressOnly)accountAddressOnly).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateQuery));
        return (FullAccountState)gson.fromJson(result, FullAccountState.class);
    }

    public FullAccountState getAccountState(Address address, BlockIdExt blockId) {
        if (StringUtils.isEmpty((CharSequence)blockId.getRoot_hash())) {
            if (StringUtils.isEmpty((CharSequence)(blockId = this.lookupBlock(blockId.getSeqno(), blockId.getWorkchain(), blockId.getShard(), 0L)).getRoot_hash())) {
                throw new Error("Cannot lookup block for hashes by seqno. Probably block not in db. Try to specify block's root and file hashes manually in base64 format.");
            }
            log.info("got hashes " + String.valueOf(blockId));
        }
        Object accountAddressOnly = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address.toString(false))).build();
        GetAccountStateQueryOnly getAccountStateQuery = GetAccountStateQueryOnly.builder().account_address((AccountAddressOnly)accountAddressOnly).build();
        GetAccountStateOnlyWithBlockQuery getAccountStateOnlyWithBlockQuery = GetAccountStateOnlyWithBlockQuery.builder().id(blockId).function(getAccountStateQuery).build();
        String result = this.syncAndRead(gson.toJson((Object)getAccountStateOnlyWithBlockQuery));
        if (Objects.isNull(result) || result.contains("@type") && result.contains("error")) {
            throw new Error("Cannot getAccountState, error" + result);
        }
        return (FullAccountState)gson.fromJson(result, FullAccountState.class);
    }

    public String getAccountStatus(Address address) {
        RawAccountState state = this.getRawAccountState(address);
        if (Objects.nonNull(state) && StringUtils.isEmpty((CharSequence)state.getCode())) {
            if (StringUtils.isEmpty((CharSequence)state.getFrozen_hash())) {
                return "uninitialized";
            }
            return "frozen";
        }
        return "active";
    }

    public BigInteger getAccountBalance(Address address) {
        String balance = this.getRawAccountState(address).getBalance();
        if (Objects.isNull(balance) || balance.equals("-1")) {
            return BigInteger.ZERO;
        }
        return new BigInteger(balance);
    }

    public String getAccountStatus(Address address, BlockIdExt blockId) {
        RawAccountState state = this.getRawAccountState(address, blockId);
        if (Objects.nonNull(state) && StringUtils.isEmpty((CharSequence)state.getCode())) {
            if (StringUtils.isEmpty((CharSequence)state.getFrozen_hash())) {
                return "uninitialized";
            }
            return "frozen";
        }
        return "active";
    }

    public String getAccountBalance(Address address, BlockIdExt blockId) {
        return this.getRawAccountState(address, blockId).getBalance();
    }

    public Cell getConfigAll(int mode) {
        GetConfigAllQuery configParamQuery = GetConfigAllQuery.builder().mode(mode).build();
        String result = this.syncAndRead(gson.toJson((Object)configParamQuery));
        ConfigInfo ci = (ConfigInfo)gson.fromJson(result, ConfigInfo.class);
        return CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)ci.getConfig().getBytes())).endCell();
    }

    public Cell getConfigParam(BlockIdExt id, long param) {
        GetConfigParamQuery configParamQuery = GetConfigParamQuery.builder().id(id).param(param).build();
        String result = this.syncAndRead(gson.toJson((Object)configParamQuery));
        ConfigInfo ci = (ConfigInfo)gson.fromJson(result, ConfigInfo.class);
        return CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)ci.getConfig().getBytes())).endCell();
    }

    public ConfigParams0 getConfigParam0() {
        return ConfigParams0.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 0L)));
    }

    public ConfigParams1 getConfigParam1() {
        return ConfigParams1.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 1L)));
    }

    public ConfigParams2 getConfigParam2() {
        return ConfigParams2.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 2L)));
    }

    public ConfigParams3 getConfigParam3() {
        try {
            return ConfigParams3.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 3L)));
        }
        catch (Error e) {
            log.error("Error getting config params 3, use config 1");
            return ConfigParams3.builder().feeCollectorAddr(BigInteger.ONE.negate()).build();
        }
    }

    public ConfigParams4 getConfigParam4() {
        return ConfigParams4.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 4L)));
    }

    public ConfigParams5 getConfigParam5() {
        return ConfigParams5.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 5L)));
    }

    public ConfigParams6 getConfigParam6() {
        return ConfigParams6.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 6L)));
    }

    public ConfigParams8 getConfigParam8() {
        return ConfigParams8.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 8L)));
    }

    public ConfigParams9 getConfigParam9() {
        return ConfigParams9.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 9L)));
    }

    public ConfigParams10 getConfigParam10() {
        return ConfigParams10.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 10L)));
    }

    public ConfigParams11 getConfigParam11() {
        return ConfigParams11.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 11L)));
    }

    public ConfigParams12 getConfigParam12() {
        return ConfigParams12.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 12L)));
    }

    public ConfigParams13 getConfigParam13() {
        return ConfigParams13.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 13L)));
    }

    public ConfigParams14 getConfigParam14() {
        return ConfigParams14.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 14L)));
    }

    public ConfigParams15 getConfigParam15() {
        return ConfigParams15.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 15L)));
    }

    public ConfigParams16 getConfigParam16() {
        return ConfigParams16.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 16L)));
    }

    public ConfigParams17 getConfigParam17() {
        return ConfigParams17.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 17L)));
    }

    public ConfigParams18 getConfigParam18() {
        return ConfigParams18.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 18L)));
    }

    public ConfigParams19 getConfigParam19() {
        return ConfigParams19.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 19L)));
    }

    public ConfigParams20 getConfigParam20() {
        return ConfigParams20.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 20L)));
    }

    public ConfigParams21 getConfigParam21() {
        return ConfigParams21.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 21L)));
    }

    public ConfigParams22 getConfigParam22() {
        return ConfigParams22.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 22L)));
    }

    public ConfigParams23 getConfigParam23() {
        return ConfigParams23.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 23L)));
    }

    public ConfigParams24 getConfigParam24() {
        return ConfigParams24.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 24L)));
    }

    public ConfigParams25 getConfigParam25() {
        return ConfigParams25.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 25L)));
    }

    public ConfigParams28 getConfigParam28() {
        return ConfigParams28.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 28L)));
    }

    public ConfigParams29 getConfigParam29() {
        return ConfigParams29.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 29L)));
    }

    public ConfigParams31 getConfigParam31() {
        return ConfigParams31.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 31L)));
    }

    public ConfigParams32 getConfigParam32() {
        try {
            return ConfigParams32.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 32L)));
        }
        catch (Error e) {
            return ConfigParams32.builder().prevValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams33 getConfigParam33() {
        try {
            return ConfigParams33.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 33L)));
        }
        catch (Error e) {
            return ConfigParams33.builder().prevTempValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams34 getConfigParam34() {
        try {
            return ConfigParams34.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 34L)));
        }
        catch (Error e) {
            return ConfigParams34.builder().currValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams35 getConfigParam35() {
        try {
            return ConfigParams35.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 35L)));
        }
        catch (Error e) {
            return ConfigParams35.builder().currTempValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams36 getConfigParam36() {
        try {
            return ConfigParams36.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 36L)));
        }
        catch (Error e) {
            return ConfigParams36.builder().nextValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams37 getConfigParam37() {
        try {
            return ConfigParams37.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 37L)));
        }
        catch (Error e) {
            return ConfigParams37.builder().nextTempValidatorSet((ValidatorSet)Validators.builder().build()).build();
        }
    }

    public ConfigParams39 getConfigParam39() {
        try {
            return ConfigParams39.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 39L)));
        }
        catch (Error e) {
            return ConfigParams39.builder().validatorSignedTemp(new TonHashMapE(0)).build();
        }
    }

    public ConfigParams40 getConfigParam40() {
        try {
            return ConfigParams40.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 40L)));
        }
        catch (Error e) {
            log.error("Error getting config params 40");
            return ConfigParams40.builder().build();
        }
    }

    public ConfigParams44 getConfigParam44() {
        return ConfigParams44.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 44L)));
    }

    public ConfigParams45 getConfigParam45() {
        return ConfigParams45.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 45L)));
    }

    public ConfigParams71 getConfigParam71() {
        return ConfigParams71.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 71L)));
    }

    public ConfigParams72 getConfigParam72() {
        return ConfigParams72.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 72L)));
    }

    public ConfigParams73 getConfigParam73() {
        try {
            return ConfigParams73.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 73L)));
        }
        catch (Error e) {
            return ConfigParams73.builder().polygonBridge(OracleBridgeParams.builder().build()).build();
        }
    }

    public ConfigParams79 getConfigParam79() {
        return ConfigParams79.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 79L)));
    }

    public ConfigParams81 getConfigParam81() {
        return ConfigParams81.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 81L)));
    }

    public ConfigParams82 getConfigParam82() {
        try {
            return ConfigParams82.deserialize((CellSlice)CellSlice.beginParse((Cell)this.getConfigParam(this.getLast().getLast(), 82L)));
        }
        catch (Error e) {
            return ConfigParams82.builder().polygonTonTokenBridge((JettonBridgeParams)JettonBridgeParamsV1.builder().build()).build();
        }
    }

    public long loadContract(AccountAddressOnly address) {
        LoadContractQuery loadContractQuery = LoadContractQuery.builder().account_address(address).build();
        String result = this.syncAndRead(gson.toJson((Object)loadContractQuery));
        return ((LoadContract)gson.fromJson(result, LoadContract.class)).getId();
    }

    public long loadContract(AccountAddressOnly address, long seqno) {
        BlockIdExt fullBlock = seqno != 0L ? this.lookupBlock(seqno, -1L, Long.MIN_VALUE, 0L) : this.getMasterChainInfo().getLast();
        LoadContractQuery loadContractQuery = LoadContractQuery.builder().account_address(address).build();
        LoadContractWithBlockQuery loadContractWithBlockQuery = LoadContractWithBlockQuery.builder().id(fullBlock).function(loadContractQuery).build();
        String result = this.syncAndRead(gson.toJson((Object)loadContractWithBlockQuery));
        return ((LoadContract)gson.fromJson(result, LoadContract.class)).getId();
    }

    public long loadContract(AccountAddressOnly address, BlockIdExt blockId) {
        if (StringUtils.isEmpty((CharSequence)blockId.getRoot_hash())) {
            blockId = this.lookupBlock(blockId.getSeqno(), blockId.getWorkchain(), blockId.getShard(), 0L);
        }
        LoadContractQuery loadContractQuery = LoadContractQuery.builder().account_address(address).build();
        LoadContractWithBlockQuery loadContractWithBlockQuery = LoadContractWithBlockQuery.builder().id(blockId).function(loadContractQuery).build();
        String result = this.syncAndRead(gson.toJson((Object)loadContractWithBlockQuery));
        return ((LoadContract)gson.fromJson(result, LoadContract.class)).getId();
    }

    public RunResult runMethod(Address contractAddress, String methodName) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build());
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodName, null);
    }

    public RunResult runMethod(Address contractAddress, String methodName, BlockIdExt blockId) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build(), blockId);
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodName, null);
    }

    public RunResult runMethod(Address contractAddress, String methodName, long seqno) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build(), seqno);
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodName, null);
    }

    public RunResult runMethod(Address contractAddress, String methodName, Deque<String> stackData) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build());
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodName, stackData);
    }

    public RunResult runMethod(Address contractAddress, long methodId) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build());
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodId, null);
    }

    public RunResult runMethod(Address contractAddress, long methodId, Deque<String> stackData) {
        long contractId = this.loadContract((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(contractAddress.toString(false))).build());
        if (contractId == -1L) {
            System.err.println("cannot load contract " + String.valueOf(AccountAddressOnly.builder().account_address(contractAddress.toString(false))));
            return null;
        }
        return this.runMethod(contractId, methodId, stackData);
    }

    public RunResult runMethod(long contractId, String methodName, Deque<String> stackData) {
        Deque<TvmStackEntry> stack = null;
        if (Objects.nonNull(stackData)) {
            stack = ParseRunResult.renderTvmStack(stackData);
        }
        RunMethodStrQuery runMethodQuery = RunMethodStrQuery.builder().id(contractId).method(MethodString.builder().name(methodName).build()).stack(stack).build();
        String result = this.syncAndRead(gson.toJson((Object)runMethodQuery));
        return new RunResultParser().parse(result);
    }

    public RunResult runMethod(long contractId, long methodId, Deque<String> stackData) {
        Deque<TvmStackEntry> stack = null;
        if (Objects.nonNull(stackData)) {
            stack = ParseRunResult.renderTvmStack(stackData);
        }
        RunMethodIntQuery runMethodQuery = RunMethodIntQuery.builder().id(contractId).method(MethodNumber.builder().number(methodId).build()).stack(stack).build();
        String result = this.syncAndRead(gson.toJson((Object)runMethodQuery));
        return new RunResultParser().parse(result);
    }

    public long getSeqno(Address address) {
        RunResult result = this.runMethod(address, "seqno");
        if (result.getExit_code() != 0L) {
            throw new Error("can't get result by executing seqno method, exit code " + result.getExit_code());
        }
        TvmStackEntryNumber seqno = (TvmStackEntryNumber)result.getStack().get(0);
        return seqno.getNumber().longValue();
    }

    public BigInteger getPublicKey(Address address) {
        RunResult result = this.runMethod(address, "get_public_key");
        if (result.getExit_code() != 0L) {
            throw new Error("can't get result by executing get_public_key method, exit code " + result.getExit_code());
        }
        TvmStackEntryNumber pubKey = (TvmStackEntryNumber)result.getStack().get(0);
        return pubKey.getNumber();
    }

    public long getSubWalletId(Address address) {
        RunResult result = this.runMethod(address, "get_subwallet_id");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_subwallet_id returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber seqno = (TvmStackEntryNumber)result.getStack().get(0);
        return seqno.getNumber().longValue();
    }

    public ExtMessageInfo sendRawMessage(String serializedBoc) {
        SendRawMessageQuery sendMessageQuery = SendRawMessageQuery.builder().body(serializedBoc).build();
        String result = this.syncAndRead(gson.toJson((Object)sendMessageQuery));
        if (Objects.isNull(result) || result.contains("@type") && result.contains("error")) {
            TonlibError error = (TonlibError)gson.fromJson(result, TonlibError.class);
            return ExtMessageInfo.builder().error(error).build();
        }
        ExtMessageInfo extMessageInfo = (ExtMessageInfo)gson.fromJson(result, ExtMessageInfo.class);
        extMessageInfo.setError(TonlibError.builder().code(0L).build());
        return extMessageInfo;
    }

    public void sendRawMessageOnly(String serializedBoc) {
        SendRawMessageQuery sendMessageQuery = SendRawMessageQuery.builder().body(serializedBoc).build();
        String query = gson.toJson((Object)sendMessageQuery);
        String queryExtraId = StringUtils.substringBetween((String)query, (String)"@extra\":\"", (String)"\"}");
        if (StringUtils.isNotEmpty((CharSequence)queryExtraId)) {
            this.sent.put(queryExtraId, "");
        }
        tonlibJson.tonlib_client_json_send(tonlib, query);
    }

    public RawTransaction sendRawMessageWithConfirmation(String serializedBoc, Address account) {
        SendRawMessageQuery sendMessageQuery = SendRawMessageQuery.builder().body(serializedBoc).build();
        String result = this.syncAndRead(gson.toJson((Object)sendMessageQuery));
        if (Objects.isNull(result) || result.contains("@type") && result.contains("error")) {
            TonlibError error = (TonlibError)gson.fromJson(result, TonlibError.class);
            throw new Error("Cannot send message. Error " + error.toString());
        }
        ExtMessageInfo extMessageInfo = (ExtMessageInfo)gson.fromJson(result, ExtMessageInfo.class);
        extMessageInfo.setError(TonlibError.builder().code(0L).build());
        log.info("Message has been successfully sent. Waiting for delivery of message with hash {}", (Object)extMessageInfo.getHash());
        RawTransactions rawTransactions = null;
        for (int i = 0; i < 12; ++i) {
            rawTransactions = this.getRawTransactions(account.toRaw(), null, null);
            for (RawTransaction tx : rawTransactions.getTransactions()) {
                if (!Objects.nonNull(tx.getIn_msg()) || !tx.getIn_msg().getHash().equals(extMessageInfo.getHash())) continue;
                log.info("Message has been delivered.");
                return tx;
            }
            Utils.sleep((long)5L);
        }
        return null;
    }

    public QueryFees estimateFees(String destinationAddress, String body, String initCode, String initData, boolean ignoreChksig) {
        QueryInfo queryInfo = this.createQuery(destinationAddress, body, initCode, initData);
        EstimateFeesQuery estimateFeesQuery = EstimateFeesQuery.builder().queryId(queryInfo.getId()).ignore_chksig(ignoreChksig).build();
        String result = this.syncAndRead(gson.toJson((Object)estimateFeesQuery));
        return (QueryFees)gson.fromJson(result, QueryFees.class);
    }

    public QueryFees estimateFees(String destinationAddress, String body) {
        return this.estimateFees(destinationAddress, body, null, null, true);
    }

    public QueryInfo createQuery(String destinationAddress, String body, String initCode, String initData) {
        CreateQuery createQuery = CreateQuery.builder().init_code(initCode).init_data(initData).body(body).destination(Destination.builder().account_address(destinationAddress).build()).build();
        String result = this.syncAndRead(gson.toJson((Object)createQuery));
        if (result.contains("@type") && result.contains("error")) {
            return QueryInfo.builder().id(-1L).build();
        }
        return (QueryInfo)gson.fromJson(result, QueryInfo.class);
    }

    public boolean sendQuery(QueryInfo queryInfo) {
        SendQuery createQuery = SendQuery.builder().id(queryInfo.getId()).build();
        String result = this.syncAndRead(gson.toJson((Object)createQuery));
        if (Objects.isNull(result)) {
            return false;
        }
        if (result.contains("@type") && result.contains("error")) {
            return false;
        }
        try {
            Ok ok = (Ok)gson.fromJson(result, Ok.class);
            log.info(ok.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean createAndSendQuery(String destinationAddress, String body, String initCode, String initData) {
        QueryInfo queryInfo = this.createQuery(destinationAddress, body, initCode, initData);
        return this.sendQuery(queryInfo);
    }

    public boolean createAndSendMessage(String destinationAddress, String body, String initialAccountState) {
        CreateAndSendRawMessageQuery createAndSendRawMessageQuery = CreateAndSendRawMessageQuery.builder().destination((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(destinationAddress)).build()).initial_account_state(initialAccountState).data(body).build();
        String result = this.syncAndRead(gson.toJson((Object)createAndSendRawMessageQuery));
        if (Objects.isNull(result)) {
            return false;
        }
        if (result.contains("@type") && result.contains("error")) {
            return false;
        }
        try {
            Ok ok = (Ok)gson.fromJson(result, Ok.class);
            log.info(ok.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RawTransaction tryLocateTxByIncomingMessage(Address source, Address destination, long creationLt) {
        Shards shards = this.getShards(0L, creationLt, 0L);
        for (BlockIdExt shardData : shards.getShards()) {
            for (int b = 0; b < 3; ++b) {
                BlockIdExt block = this.lookupBlock(0L, shardData.getWorkchain(), shardData.getShard(), creationLt + (long)b * 1000000L);
                BlockTransactions txs = this.getBlockTransactions(block, 40L);
                Pair candidate = null;
                int count = 0;
                for (ShortTxId tx : txs.getTransactions()) {
                    if (!tx.getAccount().equals(Utils.bytesToBase64((byte[])destination.hashPart))) continue;
                    ++count;
                    if (!Objects.isNull(candidate) && (Long)candidate.getRight() >= tx.getLt()) continue;
                    candidate = Pair.of((Object)tx.getHash(), (Object)tx.getLt());
                }
                if (!Objects.nonNull(candidate)) continue;
                RawTransactions transactions = this.getRawTransactions(destination.toString(false), BigInteger.valueOf((Long)candidate.getRight()), (String)candidate.getLeft(), Math.max(count, 10));
                for (RawTransaction tx : transactions.getTransactions()) {
                    RawMessage in_msg = tx.getIn_msg();
                    String txSource = in_msg.getSource().getAccount_address();
                    if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{txSource}) || !Address.of((String)txSource).toString(false).equals(source.toString(false)) || in_msg.getCreated_lt() != creationLt) continue;
                    return tx;
                }
            }
        }
        throw new Error("Transaction not found");
    }

    private RawTransaction getTxByMessageHash(String address, String msgHashBase64) {
        RawTransactions rawTransactions = this.getRawTransactions(address, null, null);
        for (RawTransaction tx : rawTransactions.getTransactions()) {
            if (!Objects.nonNull(tx.getIn_msg()) || !tx.getIn_msg().getHash().equals(msgHashBase64)) continue;
            return tx;
        }
        return null;
    }

    public RawTransaction getRawTransaction(byte workchain, ShortTxId tx) {
        String addressHex = Utils.base64ToHexString((String)tx.getAccount());
        String address = Address.of((String)(workchain + ":" + addressHex)).toString(false);
        GetRawTransactionsV2Query getRawTransactionsQuery = GetRawTransactionsV2Query.builder().account_address((AccountAddressOnly)((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address(address)).build()).from_transaction_id(LastTransactionId.builder().lt(BigInteger.valueOf(tx.getLt())).hash(tx.getHash()).build()).count(1).try_decode_message(false).build();
        Utils.disableNativeOutput((int)this.verbosityLevel.ordinal());
        String result = this.syncAndRead(gson.toJson((Object)getRawTransactionsQuery));
        Utils.enableNativeOutput((int)this.verbosityLevel.ordinal());
        RawTransactions res = (RawTransactions)gson.fromJson(result, RawTransactions.class);
        List<RawTransaction> t = res.getTransactions();
        if (t.size() >= 1) {
            return t.get(0);
        }
        return RawTransaction.builder().build();
    }

    public RawTransaction tryLocateTxByOutcomingMessage(Address source, Address destination, long creationLt) {
        Shards shards = this.getShards(0L, creationLt, 0L);
        for (BlockIdExt shardData : shards.getShards()) {
            BlockIdExt block = this.lookupBlock(0L, shardData.getWorkchain(), shardData.getShard(), creationLt);
            BlockTransactions txs = this.getBlockTransactions(block, 40L);
            Pair candidate = null;
            int count = 0;
            for (ShortTxId tx : txs.getTransactions()) {
                if (!tx.getAccount().equals(Utils.bytesToBase64((byte[])source.hashPart))) continue;
                ++count;
                if (!Objects.isNull(candidate) && (Long)candidate.getRight() >= tx.getLt()) continue;
                candidate = Pair.of((Object)tx.getHash(), (Object)tx.getLt());
            }
            if (!Objects.nonNull(candidate)) continue;
            RawTransactions transactions = this.getRawTransactions(source.toString(false), BigInteger.valueOf((Long)candidate.getRight()), (String)candidate.getLeft(), Math.max(count, 10));
            for (RawTransaction tx : transactions.getTransactions()) {
                for (RawMessage out_msg : tx.getOut_msgs()) {
                    String txDestination = out_msg.getDestination().getAccount_address();
                    if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{txDestination}) || !Address.of((String)txDestination).toString(false).equals(destination.toString(false)) || out_msg.getCreated_lt() != creationLt) continue;
                    return tx;
                }
            }
        }
        throw new Error("Transaction not found");
    }

    public DnsResolved dnsResolve(String name, AccountAddressOnly addr) {
        if (addr == null) {
            addr = ((AccountAddressOnly.AccountAddressOnlyBuilder)AccountAddressOnly.builder().account_address("-1:E56754F83426F69B09267BD876AC97C44821345B7E266BD956A7BFBFB98DF35C")).build();
        }
        byte[] category = new byte[32];
        Arrays.fill(category, (byte)0);
        DnsResolveQuery query = DnsResolveQuery.builder().account_address(addr).name(name).category(Utils.bytesToBase64((byte[])category)).ttl(1).build();
        String result = this.syncAndRead(gson.toJson((Object)query));
        return (DnsResolved)gson.fromJson(result, DnsResolved.class);
    }

    public SmcLibraryResult getLibraries(List<String> librariesHashes) {
        GetLibrariesQuery getLibrariesQuery = GetLibrariesQuery.builder().library_list(librariesHashes).build();
        String result = this.syncAndRead(gson.toJson((Object)getLibrariesQuery));
        return new LibraryResultParser().parse(result);
    }

    public SmcLibraryResult getLibrariesExt(List<SmcLibraryQueryExt> librariesHashes) {
        GetLibrariesExtQuery getLibrariesQuery = GetLibrariesExtQuery.builder().list(librariesHashes).build();
        String result = this.syncAndRead(gson.toJson((Object)getLibrariesQuery));
        return new LibraryResultParser().parse(result);
    }

    public boolean isDeployed(Address address) {
        return StringUtils.isNotEmpty((CharSequence)this.getRawAccountState(address).getCode());
    }

    public void waitForDeployment(Address address, int timeoutSeconds) {
        log.info("Waiting for deployment (up to {}s) - {} ({})", new Object[]{timeoutSeconds, this.testnet ? address.toBounceableTestnet() : address.toBounceable(), address.toRaw()});
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Can't deploy contract within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (!this.isDeployed(address));
    }

    public void waitForBalanceChange(Address address, int timeoutSeconds) {
        log.info("Waiting for balance change (up to {}s) - {} ({})", new Object[]{timeoutSeconds, this.testnet ? address.toBounceableTestnet() : address.toBounceable(), address.toRaw()});
        BigInteger initialBalance = this.getAccountBalance(address);
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance of " + address.toRaw() + "was not changed within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (initialBalance.equals(this.getAccountBalance(address)));
    }

    public void waitForBalanceChangeWithTolerance(Address address, int timeoutSeconds, BigInteger tolerateNanoCoins) {
        BigInteger currentBalance;
        long diff;
        BigInteger initialBalance = this.getAccountBalance(address);
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance was not changed by +/- " + Utils.formatNanoValue((BigInteger)tolerateNanoCoins) + " within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while ((diff = Math.max((currentBalance = this.getAccountBalance(address)).longValue(), initialBalance.longValue()) - Math.min(currentBalance.longValue(), initialBalance.longValue())) < tolerateNanoCoins.longValue());
    }

    public boolean isTestnet() {
        return this.testnet;
    }

    public void updateInitBlock() {
        this.updateInitBlock(this.pathToGlobalConfig);
    }

    public void updateInitBlock(String pathToGlobalConfig) {
        try {
            if (Files.exists(new File(pathToGlobalConfig).toPath(), new LinkOption[0])) {
                MasterChainInfo masterChainInfo = this.getLast();
                BlockHeader blockHeader = this.getBlockHeader(masterChainInfo.getLast());
                BlockIdExt blockIdExt = this.lookupBlock(blockHeader.getPrev_key_block_seqno(), -1L, Long.MIN_VALUE, 0L);
                String content = FileUtils.readFileToString((File)new File(pathToGlobalConfig), (Charset)StandardCharsets.UTF_8);
                TonGlobalConfig tonGlobalConfig = (TonGlobalConfig)gson.fromJson(content, TonGlobalConfig.class);
                tonGlobalConfig.getValidator().getInit_block().setSeqno(blockIdExt.getSeqno());
                tonGlobalConfig.getValidator().getInit_block().setShard(blockIdExt.getShard());
                tonGlobalConfig.getValidator().getInit_block().setWorkchain(blockIdExt.getWorkchain());
                tonGlobalConfig.getValidator().getInit_block().setFile_hash(blockIdExt.getFile_hash());
                tonGlobalConfig.getValidator().getInit_block().setRoot_hash(blockIdExt.getRoot_hash());
                Gson gs = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                FileUtils.writeStringToFile((File)new File(pathToGlobalConfig), (String)gs.toJson((Object)tonGlobalConfig), (Charset)Charset.defaultCharset());
                log.info("init-block updated");
            }
        }
        catch (Exception e) {
            log.error("cannot update init-block in " + pathToGlobalConfig);
        }
    }

    public long getTps(long periodInMinutes) {
        long delta;
        log.info("calculating tps...");
        LinkedList<Long> totalInRange = new LinkedList<Long>();
        MasterChainInfo masterChainInfo = this.getLast();
        BlockIdExt last0 = masterChainInfo.getLast();
        long i = 0L;
        do {
            BlockIdExt last = this.lookupBlock(last0.getSeqno() - i++, last0.getWorkchain(), last0.getShard(), 0L, 0L);
            Shards shards = this.getShards(last.getSeqno(), 0L, 0L);
            shards.getShards().add(last);
            for (BlockIdExt shard : shards.getShards()) {
                BlockTransactionsExt txs = this.getBlockTransactionsExt(shard, 10000L, null);
                for (RawTransaction tx : txs.getTransactions()) {
                    Transaction txi = Transaction.deserialize((CellSlice)CellSlice.beginParse((Cell)Cell.fromBocBase64((String)tx.getData())));
                    totalInRange.add(txi.getNow());
                }
            }
            Collections.sort(totalInRange);
            delta = (Long)totalInRange.getLast() - (Long)totalInRange.getFirst();
        } while ((delta = delta == 0L ? 1L : delta) < periodInMinutes * 60L);
        double tps = (double)totalInRange.size() / (double)delta;
        return new BigDecimal(tps).setScale(0, RoundingMode.HALF_UP).toBigInteger().longValue();
    }

    public long getTpsOneBlock() {
        log.info("calculating tps...");
        LinkedList<Long> totalInRange = new LinkedList<Long>();
        MasterChainInfo masterChainInfo = this.getLast();
        BlockIdExt last0 = masterChainInfo.getLast();
        BlockIdExt last = this.lookupBlock(last0.getSeqno(), last0.getWorkchain(), last0.getShard(), 0L, 0L);
        Shards shards = this.getShards(last.getSeqno(), 0L, 0L);
        shards.getShards().add(last);
        for (BlockIdExt shard : shards.getShards()) {
            BlockTransactionsExt txs = this.getBlockTransactionsExt(shard, 10000L, null);
            for (RawTransaction tx : txs.getTransactions()) {
                Transaction txi = Transaction.deserialize((CellSlice)CellSlice.beginParse((Cell)Cell.fromBocBase64((String)tx.getData())));
                totalInRange.add(txi.getNow());
            }
        }
        Collections.sort(totalInRange);
        long delta = (Long)totalInRange.getLast() - (Long)totalInRange.getFirst();
        delta = delta == 0L ? 1L : delta;
        double tps = (double)totalInRange.size() / (double)delta;
        return new BigDecimal(tps).setScale(0, RoundingMode.HALF_UP).toBigInteger().longValue();
    }

    public List<Participant> getElectionParticipants() {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        RunResult result = this.runMethod(ELECTION_ADDRESS, "participant_list");
        TvmStackEntryList listResult = (TvmStackEntryList)result.getStack().get(0);
        for (Object o : listResult.getList().getElements()) {
            TvmStackEntryTuple t = (TvmStackEntryTuple)o;
            TvmTuple tuple = t.getTuple();
            TvmStackEntryNumber addr = (TvmStackEntryNumber)tuple.getElements().get(0);
            TvmStackEntryNumber stake = (TvmStackEntryNumber)tuple.getElements().get(1);
            participants.add(Participant.builder().address(addr.getNumber()).stake(stake.getNumber()).build());
        }
        return participants;
    }

    public BigInteger getElectionId() {
        RunResult result = this.runMethod(ELECTION_ADDRESS, "active_election_id");
        TvmStackEntryNumber electionId = (TvmStackEntryNumber)result.getStack().get(0);
        return electionId.getNumber();
    }

    public BigInteger getReturnedStake(String validatorWalletHex) {
        ArrayDeque<String> params = new ArrayDeque<String>();
        params.offer("[num," + String.valueOf(new BigInteger(validatorWalletHex.toLowerCase(), 16)) + "]");
        RunResult result = this.runMethod(ELECTION_ADDRESS, "compute_returned_stake", params);
        TvmStackEntryNumber stake = (TvmStackEntryNumber)result.getStack().get(0);
        return stake.getNumber();
    }

    Tonlib(String pathToTonlibSharedLib, String pathToGlobalConfig, String globalConfigAsString, TonGlobalConfig globalConfigAsObject, VerbosityLevel verbosityLevel, Boolean ignoreCache, boolean testnet, boolean keystoreInMemory, String keystorePath, Integer liteServerIndex, Boolean usingAllLiteServers, int receiveRetryTimes, double receiveTimeout, Boolean printInfo, Map<String, String> sent, Map<String, String> received) {
        this.pathToTonlibSharedLib = pathToTonlibSharedLib;
        this.pathToGlobalConfig = pathToGlobalConfig;
        this.globalConfigAsString = globalConfigAsString;
        this.globalConfigAsObject = globalConfigAsObject;
        this.verbosityLevel = verbosityLevel;
        this.ignoreCache = ignoreCache;
        this.testnet = testnet;
        this.keystoreInMemory = keystoreInMemory;
        this.keystorePath = keystorePath;
        this.liteServerIndex = liteServerIndex;
        this.usingAllLiteServers = usingAllLiteServers;
        this.receiveRetryTimes = receiveRetryTimes;
        this.receiveTimeout = receiveTimeout;
        this.printInfo = printInfo;
        this.sent = sent;
        this.received = received;
    }

    static {
        gson = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).create();
    }

    private static class CustomTonlibBuilder
    extends TonlibBuilder {
        private CustomTonlibBuilder() {
        }

        @Override
        public Tonlib build() {
            try {
                if (Objects.isNull(this.printInfo)) {
                    this.printInfo = true;
                }
                this.sent = new ConcurrentHashMap<String, String>();
                this.received = new ConcurrentHashMap<String, String>();
                if (Objects.isNull(this.pathToTonlibSharedLib)) {
                    this.pathToTonlibSharedLib = Utils.getOS() == Utils.OS.WINDOWS || Utils.getOS() == Utils.OS.WINDOWS_ARM ? Utils.detectAbsolutePath((String)"tonlibjson", (boolean)true) : Utils.detectAbsolutePath((String)"libtonlibjson", (boolean)true);
                    if (Objects.nonNull(this.pathToTonlibSharedLib) && this.pathToTonlibSharedLib.contains("INFO:") || Objects.isNull(this.pathToTonlibSharedLib)) {
                        throw new Error("tonlibjson shared library not found.\nYou can specify full path via Tonlib.builder().pathToTonlibSharedLib(Utils.getTonlibGithubUrl()).");
                    }
                } else {
                    this.pathToTonlibSharedLib = Utils.getLocalOrDownload((String)this.pathToTonlibSharedLib);
                }
                if (Objects.isNull(this.verbosityLevel)) {
                    this.verbosityLevel = VerbosityLevel.FATAL;
                }
                if (Objects.isNull(this.keystorePath)) {
                    this.keystorePath = ".";
                }
                if (Objects.isNull(this.liteServerIndex)) {
                    this.liteServerIndex = -1;
                }
                this.keystorePath = this.keystorePath.replace("\\", "/");
                if (this.receiveRetryTimes == 0) {
                    this.receiveRetryTimes = 5;
                }
                if (this.receiveTimeout == 0.0) {
                    this.receiveTimeout = 10.0;
                }
                if (Objects.isNull(this.ignoreCache)) {
                    this.ignoreCache = false;
                }
                if (Objects.nonNull(this.globalConfigAsString)) {
                    originalGlobalConfigStr = this.globalConfigAsString;
                } else if (Objects.isNull(this.globalConfigAsObject)) {
                    this.pathToGlobalConfig = this.resolvePathToGlobalConfig();
                    originalGlobalConfigStr = FileUtils.readFileToString((File)new File(this.pathToGlobalConfig), (Charset)StandardCharsets.UTF_8);
                }
                TonGlobalConfig globalConfigCurrent = Objects.nonNull(this.globalConfigAsObject) ? this.globalConfigAsObject : (TonGlobalConfig)gson.fromJson(originalGlobalConfigStr, TonGlobalConfig.class);
                TonGlobalConfig tonGlobalConfig = originalGlobalConfigInternal = Objects.nonNull(this.globalConfigAsObject) ? this.globalConfigAsObject : (TonGlobalConfig)gson.fromJson(originalGlobalConfigStr, TonGlobalConfig.class);
                if (this.liteServerIndex != -1) {
                    this.usingAllLiteServers = false;
                    if (this.liteServerIndex > globalConfigCurrent.getLiteservers().length - 1) {
                        throw new RuntimeException("Specified lite-server index is greater than total number of lite-servers in config.");
                    }
                } else {
                    this.liteServerIndex = 0;
                    this.usingAllLiteServers = true;
                }
                LiteServers[] liteServers = originalGlobalConfigInternal.getLiteservers();
                LiteServers[] newLiteServers = new LiteServers[]{liteServers[this.liteServerIndex]};
                globalConfigCurrent.setLiteservers(newLiteServers);
                tonlibJson = (TonlibJsonI)Native.load((String)this.pathToTonlibSharedLib, TonlibJsonI.class);
                Utils.disableNativeOutput((int)this.verbosityLevel.ordinal());
                tonlib = tonlibJson.tonlib_client_json_create();
                tonlibJson.tonlib_client_set_verbosity_level(this.verbosityLevel.ordinal());
                Utils.enableNativeOutput((int)this.verbosityLevel.ordinal());
                if (this.printInfo.booleanValue()) {
                    log.info(String.format("Java Tonlib configuration:\nLocation: %s\nVerbosity level: %s (%s)\nKeystore in memory: %s\nKeystore path: %s\nPath to global config: %s\nGlobal config as string: %s\nlite-servers found: %s\ndht-nodes found: %s\ninit-block seqno: %s\n%s\nIgnore cache: %s\nTestnet: %s\nReceive timeout: %s seconds\nReceive retry times: %s%n", this.pathToTonlibSharedLib, this.verbosityLevel, this.verbosityLevel.ordinal(), this.keystoreInMemory, this.keystorePath, Objects.isNull(this.pathToGlobalConfig) ? "not specified" : this.pathToGlobalConfig, Objects.nonNull(this.globalConfigAsString) && this.globalConfigAsString.length() > 33 ? "yes" : "", originalGlobalConfigInternal.getLiteservers().length, globalConfigCurrent.getDht().getStatic_nodes().getNodes().length, globalConfigCurrent.getValidator().getInit_block().getSeqno(), this.usingAllLiteServers != false ? "using lite-servers: all" : "using lite-server at index: " + this.liteServerIndex + " (" + Utils.int2ip((long)globalConfigCurrent.getLiteservers()[0].getIp()) + ")", this.ignoreCache, this.testnet, this.receiveTimeout, this.receiveRetryTimes));
                }
                this.initTonlibConfig(globalConfigCurrent);
                if (this.usingAllLiteServers.booleanValue() && this.printInfo.booleanValue()) {
                    log.info("Using lite-server at index: " + this.liteServerIndex + " (" + Utils.int2ip((long)globalConfigCurrent.getLiteservers()[0].getIp()) + ")");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException("Error creating tonlib instance: " + e.getMessage());
            }
            return super.build();
        }

        private String resolvePathToGlobalConfig() {
            String globalConfigPath;
            if (Objects.isNull(this.pathToGlobalConfig)) {
                if (this.testnet) {
                    try {
                        globalConfigPath = Utils.getLocalOrDownload((String)Utils.getGlobalConfigUrlTestnet());
                    }
                    catch (Error e) {
                        globalConfigPath = Utils.getLocalOrDownload((String)Utils.getGlobalConfigUrlTestnetGithub());
                    }
                } else {
                    try {
                        globalConfigPath = Utils.getLocalOrDownload((String)Utils.getGlobalConfigUrlMainnet());
                    }
                    catch (Error e) {
                        globalConfigPath = Utils.getLocalOrDownload((String)Utils.getGlobalConfigUrlMainnetGithub());
                    }
                }
            } else {
                globalConfigPath = Utils.getLocalOrDownload((String)this.pathToGlobalConfig);
            }
            if (!Files.exists(Paths.get(globalConfigPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("Global config is not found in path: " + this.pathToGlobalConfig);
            }
            return globalConfigPath;
        }

        private void initTonlibConfig(TonGlobalConfig tonGlobalConfig) {
            TonlibSetup tonlibSetup = TonlibSetup.builder().type("init").options(TonlibOptions.builder().type("options").config(TonlibConfig.builder().type("config").config(gson.toJson((Object)tonGlobalConfig)).use_callbacks_for_network(false).blockchain_name("").ignore_cache(this.ignoreCache).build()).keystore_type(this.keystoreInMemory ? KeyStoreTypeMemory.builder().type("keyStoreTypeInMemory").build() : KeyStoreTypeDirectory.builder().type("keyStoreTypeDirectory").directory(this.keystorePath.equals(".") ? "." : this.keystorePath).build()).build()).build();
            Utils.disableNativeOutput((int)this.verbosityLevel.ordinal());
            tonlibJson.tonlib_client_json_send(tonlib, gson.toJson((Object)tonlibSetup));
            tonlibJson.tonlib_client_json_receive(tonlib, this.receiveTimeout);
            Utils.enableNativeOutput((int)this.verbosityLevel.ordinal());
        }
    }

    public static class TonlibBuilder {
        private String pathToTonlibSharedLib;
        private String pathToGlobalConfig;
        private String globalConfigAsString;
        private TonGlobalConfig globalConfigAsObject;
        private VerbosityLevel verbosityLevel;
        private Boolean ignoreCache;
        private boolean testnet;
        private boolean keystoreInMemory;
        private String keystorePath;
        private Integer liteServerIndex;
        private Boolean usingAllLiteServers;
        private int receiveRetryTimes;
        private double receiveTimeout;
        private Boolean printInfo;
        private Map<String, String> sent;
        private Map<String, String> received;

        TonlibBuilder() {
        }

        public TonlibBuilder pathToTonlibSharedLib(String pathToTonlibSharedLib) {
            this.pathToTonlibSharedLib = pathToTonlibSharedLib;
            return this;
        }

        public TonlibBuilder pathToGlobalConfig(String pathToGlobalConfig) {
            this.pathToGlobalConfig = pathToGlobalConfig;
            return this;
        }

        public TonlibBuilder globalConfigAsString(String globalConfigAsString) {
            this.globalConfigAsString = globalConfigAsString;
            return this;
        }

        public TonlibBuilder globalConfigAsObject(TonGlobalConfig globalConfigAsObject) {
            this.globalConfigAsObject = globalConfigAsObject;
            return this;
        }

        public TonlibBuilder verbosityLevel(VerbosityLevel verbosityLevel) {
            this.verbosityLevel = verbosityLevel;
            return this;
        }

        public TonlibBuilder ignoreCache(Boolean ignoreCache) {
            this.ignoreCache = ignoreCache;
            return this;
        }

        public TonlibBuilder testnet(boolean testnet) {
            this.testnet = testnet;
            return this;
        }

        public TonlibBuilder keystoreInMemory(boolean keystoreInMemory) {
            this.keystoreInMemory = keystoreInMemory;
            return this;
        }

        public TonlibBuilder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public TonlibBuilder liteServerIndex(Integer liteServerIndex) {
            this.liteServerIndex = liteServerIndex;
            return this;
        }

        public TonlibBuilder usingAllLiteServers(Boolean usingAllLiteServers) {
            this.usingAllLiteServers = usingAllLiteServers;
            return this;
        }

        public TonlibBuilder receiveRetryTimes(int receiveRetryTimes) {
            this.receiveRetryTimes = receiveRetryTimes;
            return this;
        }

        public TonlibBuilder receiveTimeout(double receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        public TonlibBuilder printInfo(Boolean printInfo) {
            this.printInfo = printInfo;
            return this;
        }

        public TonlibBuilder sent(Map<String, String> sent) {
            this.sent = sent;
            return this;
        }

        public TonlibBuilder received(Map<String, String> received) {
            this.received = received;
            return this;
        }

        public Tonlib build() {
            return new Tonlib(this.pathToTonlibSharedLib, this.pathToGlobalConfig, this.globalConfigAsString, this.globalConfigAsObject, this.verbosityLevel, this.ignoreCache, this.testnet, this.keystoreInMemory, this.keystorePath, this.liteServerIndex, this.usingAllLiteServers, this.receiveRetryTimes, this.receiveTimeout, this.printInfo, this.sent, this.received);
        }

        public String toString() {
            return "Tonlib.TonlibBuilder(pathToTonlibSharedLib=" + this.pathToTonlibSharedLib + ", pathToGlobalConfig=" + this.pathToGlobalConfig + ", globalConfigAsString=" + this.globalConfigAsString + ", globalConfigAsObject=" + String.valueOf(this.globalConfigAsObject) + ", verbosityLevel=" + String.valueOf(this.verbosityLevel) + ", ignoreCache=" + this.ignoreCache + ", testnet=" + this.testnet + ", keystoreInMemory=" + this.keystoreInMemory + ", keystorePath=" + this.keystorePath + ", liteServerIndex=" + this.liteServerIndex + ", usingAllLiteServers=" + this.usingAllLiteServers + ", receiveRetryTimes=" + this.receiveRetryTimes + ", receiveTimeout=" + this.receiveTimeout + ", printInfo=" + this.printInfo + ", sent=" + String.valueOf(this.sent) + ", received=" + String.valueOf(this.received) + ")";
        }
    }
}

