/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v1;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.types.WalletV1R2Config;
import org.ton.java.smartcontract.utils.MsgUtils;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.utils.Utils;

public class WalletV1R2
implements Contract {
    TweetNaclFast.Signature.KeyPair keyPair;
    long initialSeqno;
    byte[] publicKey;
    private Tonlib tonlib;
    private long wc;

    public static WalletV1R2Builder builder() {
        return new CustomWalletV1R2Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "V1R2";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.initialSeqno, 32).storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey()).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.V1R2.getValue()).endCell();
    }

    public Cell createDeployMessage() {
        return CellBuilder.beginCell().storeUint(this.initialSeqno, 32).endCell();
    }

    public Cell createTransferBody(WalletV1R2Config config) {
        Cell order = MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(config.getBounce()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(config.getDestination().wc).address(config.getDestination().toBigInteger()).build()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).body(Objects.isNull(config.getBody()) && Objects.nonNull(config.getComment()) ? CellBuilder.beginCell().storeUint(0, 32).storeString(config.getComment()).endCell() : config.getBody()).build().toCell();
        return CellBuilder.beginCell().storeUint(BigInteger.valueOf(config.getSeqno()), 32).storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8).storeRef(order).endCell();
    }

    public ExtMessageInfo send(WalletV1R2Config config) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config).toCell().toBase64());
    }

    public RawTransaction sendWithConfirmation(WalletV1R2Config config) {
        return this.tonlib.sendRawMessageWithConfirmation(this.prepareExternalMsg(config).toCell().toBase64(), this.getAddress());
    }

    public Message prepareExternalMsg(WalletV1R2Config config) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(this.keyPair, this.getAddress(), null, body);
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg().toCell().toBase64());
    }

    public ExtMessageInfo deploy(byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsg(byte[] signedBodyHash) {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(body).endCell()).build();
    }

    public ExtMessageInfo send(WalletV1R2Config config, byte[] signedBodyHash) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config, signedBodyHash).toCell().toBase64());
    }

    public Message prepareExternalMsg(WalletV1R2Config config, byte[] signedBodyHash) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(signedBodyHash, this.getAddress(), null, body);
    }

    @Override
    public Message prepareDeployMsg() {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
    }

    public Cell createInternalSignedBody(WalletV1R2Config config) {
        Cell body = this.createTransferBody(config);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell();
    }

    public Message prepareInternalMsg(WalletV1R2Config config) {
        Cell body = this.createInternalSignedBody(config);
        return Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().srcAddr((MsgAddressInt)this.getAddressIntStd()).dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).body(body).build();
    }

    public MessageRelaxed prepareInternalMsgRelaxed(WalletV1R2Config config) {
        Cell body = this.createInternalSignedBody(config);
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).body(body).build();
    }

    WalletV1R2(TweetNaclFast.Signature.KeyPair keyPair, long initialSeqno, byte[] publicKey, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.initialSeqno = initialSeqno;
        this.publicKey = publicKey;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getInitialSeqno() {
        return this.initialSeqno;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomWalletV1R2Builder
    extends WalletV1R2Builder {
        private CustomWalletV1R2Builder() {
        }

        @Override
        public WalletV1R2 build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class WalletV1R2Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long initialSeqno;
        private byte[] publicKey;
        private Tonlib tonlib;
        private long wc;

        WalletV1R2Builder() {
        }

        public WalletV1R2Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public WalletV1R2Builder initialSeqno(long initialSeqno) {
            this.initialSeqno = initialSeqno;
            return this;
        }

        public WalletV1R2Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public WalletV1R2Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public WalletV1R2Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public WalletV1R2 build() {
            return new WalletV1R2(this.keyPair, this.initialSeqno, this.publicKey, this.tonlib, this.wc);
        }

        public String toString() {
            return "WalletV1R2.WalletV1R2Builder(keyPair=" + String.valueOf(this.keyPair) + ", initialSeqno=" + this.initialSeqno + ", publicKey=" + Arrays.toString(this.publicKey) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

