/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.OutList;

public class HighloadV3InternalMessageBody {
    long magic;
    BigInteger queryId;
    OutList actions;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(BigInteger.valueOf(2923619748L), 32).storeUint(this.queryId, 64).storeRef(this.actions.toCell()).endCell();
    }

    public static HighloadV3InternalMessageBody deserialize(CellSlice cs) {
        return HighloadV3InternalMessageBody.builder().magic(cs.loadUint(32).longValue()).queryId(cs.loadUint(64)).actions(OutList.deserialize((CellSlice)CellSlice.beginParse((Cell)cs.loadRef()))).build();
    }

    HighloadV3InternalMessageBody(long magic, BigInteger queryId, OutList actions) {
        this.magic = magic;
        this.queryId = queryId;
        this.actions = actions;
    }

    public static HighloadV3InternalMessageBodyBuilder builder() {
        return new HighloadV3InternalMessageBodyBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public BigInteger getQueryId() {
        return this.queryId;
    }

    public OutList getActions() {
        return this.actions;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setQueryId(BigInteger queryId) {
        this.queryId = queryId;
    }

    public void setActions(OutList actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HighloadV3InternalMessageBody)) {
            return false;
        }
        HighloadV3InternalMessageBody other = (HighloadV3InternalMessageBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$queryId = this.getQueryId();
        BigInteger other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !((Object)this$queryId).equals(other$queryId)) {
            return false;
        }
        OutList this$actions = this.getActions();
        OutList other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !this$actions.equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HighloadV3InternalMessageBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        BigInteger $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : ((Object)$queryId).hashCode());
        OutList $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : $actions.hashCode());
        return result;
    }

    public String toString() {
        return "HighloadV3InternalMessageBody(magic=" + this.getMagic() + ", queryId=" + String.valueOf(this.getQueryId()) + ", actions=" + String.valueOf(this.getActions()) + ")";
    }

    public static class HighloadV3InternalMessageBodyBuilder {
        private long magic;
        private BigInteger queryId;
        private OutList actions;

        HighloadV3InternalMessageBodyBuilder() {
        }

        public HighloadV3InternalMessageBodyBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public HighloadV3InternalMessageBodyBuilder queryId(BigInteger queryId) {
            this.queryId = queryId;
            return this;
        }

        public HighloadV3InternalMessageBodyBuilder actions(OutList actions) {
            this.actions = actions;
            return this;
        }

        public HighloadV3InternalMessageBody build() {
            return new HighloadV3InternalMessageBody(this.magic, this.queryId, this.actions);
        }

        public String toString() {
            return "HighloadV3InternalMessageBody.HighloadV3InternalMessageBodyBuilder(magic=" + this.magic + ", queryId=" + String.valueOf(this.queryId) + ", actions=" + String.valueOf(this.actions) + ")";
        }
    }
}

