/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.ft;

import java.math.BigInteger;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.JettonWalletData;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class JettonWalletStableCoin
implements Contract {
    Address address;
    private Tonlib tonlib;
    private long wc;

    public static JettonWalletStableCoinBuilder builder() {
        return new CustomJettonWalletStableCoinBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "jettonWalletStableCoin";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.jettonWalletStableCoin.getValue()).endCell();
    }

    public static Cell createTransferBody(long queryId, BigInteger jettonAmount, Address toAddress, Address responseAddress, BigInteger forwardAmount, Cell forwardPayload) {
        return CellBuilder.beginCell().storeUint(260734629, 32).storeUint(queryId, 64).storeCoins(jettonAmount).storeAddress(toAddress).storeAddress(responseAddress).storeBit(Boolean.valueOf(false)).storeCoins(forwardAmount).storeRefMaybe(forwardPayload).endCell();
    }

    public static Cell createBurnBody(long queryId, BigInteger jettonAmount, Address responseAddress) {
        return CellBuilder.beginCell().storeUint(1499400124, 32).storeUint(queryId, 64).storeCoins(jettonAmount).storeAddress(responseAddress).endCell();
    }

    public static Cell createStatusBody(long queryId, int status) {
        return CellBuilder.beginCell().storeUint(new BigInteger("eed236d3", 16), 32).storeUint(queryId, 64).storeUint(status, 4).endCell();
    }

    public static Cell createCallToBody(long queryId, Address destination, BigInteger tonAmount, Cell payload) {
        return CellBuilder.beginCell().storeUint(593276754, 32).storeUint(queryId, 64).storeAddress(destination).storeCoins(tonAmount).storeRef(payload).endCell();
    }

    public JettonWalletData getData() {
        RunResult result = this.tonlib.runMethod(this.address, "get_wallet_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_wallet_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber balanceNumber = (TvmStackEntryNumber)result.getStack().get(0);
        BigInteger balance = balanceNumber.getNumber();
        TvmStackEntrySlice ownerAddr = (TvmStackEntrySlice)result.getStack().get(1);
        Address ownerAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)ownerAddr.getSlice().getBytes())).endCell());
        TvmStackEntrySlice jettonMinterAddr = (TvmStackEntrySlice)result.getStack().get(2);
        Address jettonMinterAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)jettonMinterAddr.getSlice().getBytes())).endCell());
        TvmStackEntryCell jettonWallet = (TvmStackEntryCell)result.getStack().get(3);
        Cell jettonWalletCode = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)jettonWallet.getCell().getBytes())).endCell();
        return JettonWalletData.builder().balance(balance).ownerAddress(ownerAddress).jettonMinterAddress(jettonMinterAddress).jettonWalletCode(jettonWalletCode).build();
    }

    @Override
    public BigInteger getBalance() {
        RunResult result = this.tonlib.runMethod(this.address, "get_wallet_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_wallet_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber balanceNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return balanceNumber.getNumber();
    }

    JettonWalletStableCoin(Address address, Tonlib tonlib, long wc) {
        this.address = address;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomJettonWalletStableCoinBuilder
    extends JettonWalletStableCoinBuilder {
        private CustomJettonWalletStableCoinBuilder() {
        }

        @Override
        public JettonWalletStableCoin build() {
            return super.build();
        }
    }

    public static class JettonWalletStableCoinBuilder {
        private Address address;
        private Tonlib tonlib;
        private long wc;

        JettonWalletStableCoinBuilder() {
        }

        public JettonWalletStableCoinBuilder address(Address address) {
            this.address = address;
            return this;
        }

        public JettonWalletStableCoinBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public JettonWalletStableCoinBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public JettonWalletStableCoin build() {
            return new JettonWalletStableCoin(this.address, this.tonlib, this.wc);
        }

        public String toString() {
            return "JettonWalletStableCoin.JettonWalletStableCoinBuilder(address=" + String.valueOf(this.address) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

