/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.lockup;

import com.iwebpp.crypto.TweetNaclFast;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.TonPfxHashMapE;
import org.ton.java.smartcontract.types.LockupConfig;
import org.ton.java.smartcontract.types.LockupWalletV1Config;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.utils.MsgUtils;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

public class LockupWalletV1
implements Contract {
    public static final String LOCKUP_R1_CODE_HEX = "B5EE9C7241021E01000261000114FF00F4A413F4BCF2C80B010201200203020148040501F2F28308D71820D31FD31FD31F802403F823BB13F2F2F003802251A9BA1AF2F4802351B7BA1BF2F4801F0BF9015410C5F9101AF2F4F8005057F823F0065098F823F0062071289320D74A8E8BD30731D4511BDB3C12B001E8309229A0DF72FB02069320D74A96D307D402FB00E8D103A4476814154330F004ED541D0202CD0607020120131402012008090201200F100201200A0B002D5ED44D0D31FD31FD3FFD3FFF404FA00F404FA00F404D1803F7007434C0C05C6C2497C0F83E900C0871C02497C0F80074C7C87040A497C1383C00D46D3C00608420BABE7114AC2F6C2497C338200A208420BABE7106EE86BCBD20084AE0840EE6B2802FBCBD01E0C235C62008087E4055040DBE4404BCBD34C7E00A60840DCEAA7D04EE84BCBD34C034C7CC0078C3C412040DD78CA00C0D0E00130875D27D2A1BE95B0C60000C1039480AF00500161037410AF0050810575056001010244300F004ED540201201112004548E1E228020F4966FA520933023BB9131E2209835FA00D113A14013926C21E2B3E6308003502323287C5F287C572FFC4F2FFFD00007E80BD00007E80BD00326000431448A814C4E0083D039BE865BE803444E800A44C38B21400FE809004E0083D10C06002012015160015BDE9F780188242F847800C02012017180201481B1C002DB5187E006D88868A82609E00C6207E00C63F04EDE20B30020158191A0017ADCE76A268699F98EB85FFC00017AC78F6A268698F98EB858FC00011B325FB513435C2C7E00017B1D1BE08E0804230FB50F620002801D0D3030178B0925B7FE0FA4031FA403001F001A80EDAA4";
    TweetNaclFast.Signature.KeyPair keyPair;
    long walletId;
    long initialSeqno;
    byte[] publicKey;
    LockupConfig lockupConfig;
    private Tonlib tonlib;
    private long wc;

    public static LockupWalletV1Builder builder() {
        return new CustomLockupWalletV1Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "lockupR1";
    }

    public Cell createDeployMessage() {
        return CellBuilder.beginCell().storeUint(this.walletId, 32).storeInt(-1, 32).storeUint(this.initialSeqno, 32).endCell();
    }

    public Cell createTransferBody(LockupWalletV1Config config) {
        Cell order = Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().bounce(Boolean.valueOf(config.isBounce())).srcAddr((MsgAddressInt)this.getAddressIntStd()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(config.getDestination().wc).address(config.getDestination().toBigInteger()).build()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).init(config.getStateInit()).body(Objects.isNull(config.getBody()) && Objects.nonNull(config.getComment()) ? CellBuilder.beginCell().storeUint(0, 32).storeString(config.getComment()).endCell() : config.getBody()).build().toCell();
        return CellBuilder.beginCell().storeUint(config.getWalletId(), 32).storeUint(config.getValidUntil() == 0L ? Instant.now().getEpochSecond() + 60L : config.getValidUntil(), 32).storeUint(config.getSeqno(), 32).storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8).storeRef(order).endCell();
    }

    @Override
    public Cell createDataCell() {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(0, 32);
        cell.storeUint(this.walletId, 32);
        cell.storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey());
        cell.storeBytes(Utils.hexToSignedBytes((String)this.lockupConfig.getConfigPublicKey()));
        int dictKeySize = 267;
        TonPfxHashMapE dictAllowedDestinations = new TonPfxHashMapE(dictKeySize);
        if (Objects.nonNull(this.lockupConfig.getAllowedDestinations()) && !this.lockupConfig.getAllowedDestinations().isEmpty()) {
            for (String addr : this.lockupConfig.getAllowedDestinations()) {
                dictAllowedDestinations.elements.put(Address.of((String)addr), (byte)1);
            }
        }
        Cell cellDict = dictAllowedDestinations.serialize(k -> CellBuilder.beginCell().storeAddress((Address)k).endCell().getBits(), v -> CellBuilder.beginCell().storeUint((short)((Byte)v).byteValue(), 8).endCell());
        cell.storeDict(cellDict);
        cell.storeCoins(Objects.isNull(this.lockupConfig.getTotalLockedValue()) ? BigInteger.ZERO : this.lockupConfig.getTotalLockedValue());
        cell.storeBit(Boolean.valueOf(false));
        cell.storeCoins(Objects.isNull(this.lockupConfig.getTotalRestrictedValue()) ? BigInteger.ZERO : this.lockupConfig.getTotalRestrictedValue());
        cell.storeBit(Boolean.valueOf(false));
        return cell.endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.lockup.getValue()).endCell();
    }

    public long getWalletId() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "wallet_id");
        TvmStackEntryNumber subWalletId = (TvmStackEntryNumber)result.getStack().get(0);
        return subWalletId.getNumber().longValue();
    }

    public String getPublicKey() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_public_key");
        TvmStackEntryNumber pubkey = (TvmStackEntryNumber)result.getStack().get(0);
        return pubkey.getNumber().toString(16);
    }

    public boolean check_destination(String destination) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        CellBuilder c = CellBuilder.beginCell();
        c.storeAddress(Address.of((String)destination));
        stack.offer((CallSite)((Object)("[slice, " + c.endCell().toHex(true) + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "check_destination", stack);
        TvmStackEntryNumber found = (TvmStackEntryNumber)result.getStack().get(0);
        return found.getNumber().intValue() == -1;
    }

    public BigInteger getLiquidBalance() {
        List<BigInteger> balances = this.getBalances();
        return balances.get(0).subtract(balances.get(1)).subtract(balances.get(2));
    }

    public BigInteger getNominalRestrictedBalance() {
        return this.getBalances().get(1);
    }

    public BigInteger getNominalLockedBalance() {
        return this.getBalances().get(2);
    }

    public List<BigInteger> getBalances() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_balances");
        TvmStackEntryNumber balance = (TvmStackEntryNumber)result.getStack().get(0);
        TvmStackEntryNumber restrictedValue = (TvmStackEntryNumber)result.getStack().get(1);
        TvmStackEntryNumber lockedValue = (TvmStackEntryNumber)result.getStack().get(2);
        return Arrays.asList(balance.getNumber(), restrictedValue.getNumber(), lockedValue.getNumber());
    }

    public ExtMessageInfo deploy() {
        Cell body = this.createDeployMessage();
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public ExtMessageInfo deploy(byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsg(byte[] signedBodyHash) {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(body).endCell()).build();
    }

    public ExtMessageInfo send(LockupWalletV1Config config, byte[] signedBodyHash) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config, signedBodyHash).toCell().toBase64());
    }

    public Message prepareExternalMsg(LockupWalletV1Config config, byte[] signedBodyHash) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(signedBodyHash, this.getAddress(), null, body);
    }

    public ExtMessageInfo send(LockupWalletV1Config config) {
        Cell body = this.createTransferBody(config);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public RawTransaction sendWithConfirmation(LockupWalletV1Config config) {
        Cell body = this.createTransferBody(config);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
        return this.tonlib.sendRawMessageWithConfirmation(externalMessage.toCell().toBase64(), this.getAddress());
    }

    LockupWalletV1(TweetNaclFast.Signature.KeyPair keyPair, long walletId, long initialSeqno, byte[] publicKey, LockupConfig lockupConfig, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.walletId = walletId;
        this.initialSeqno = initialSeqno;
        this.publicKey = publicKey;
        this.lockupConfig = lockupConfig;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getInitialSeqno() {
        return this.initialSeqno;
    }

    public LockupConfig getLockupConfig() {
        return this.lockupConfig;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomLockupWalletV1Builder
    extends LockupWalletV1Builder {
        private CustomLockupWalletV1Builder() {
        }

        @Override
        public LockupWalletV1 build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class LockupWalletV1Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long walletId;
        private long initialSeqno;
        private byte[] publicKey;
        private LockupConfig lockupConfig;
        private Tonlib tonlib;
        private long wc;

        LockupWalletV1Builder() {
        }

        public LockupWalletV1Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public LockupWalletV1Builder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public LockupWalletV1Builder initialSeqno(long initialSeqno) {
            this.initialSeqno = initialSeqno;
            return this;
        }

        public LockupWalletV1Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public LockupWalletV1Builder lockupConfig(LockupConfig lockupConfig) {
            this.lockupConfig = lockupConfig;
            return this;
        }

        public LockupWalletV1Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public LockupWalletV1Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public LockupWalletV1 build() {
            return new LockupWalletV1(this.keyPair, this.walletId, this.initialSeqno, this.publicKey, this.lockupConfig, this.tonlib, this.wc);
        }

        public String toString() {
            return "LockupWalletV1.LockupWalletV1Builder(keyPair=" + String.valueOf(this.keyPair) + ", walletId=" + this.walletId + ", initialSeqno=" + this.initialSeqno + ", publicKey=" + Arrays.toString(this.publicKey) + ", lockupConfig=" + String.valueOf(this.lockupConfig) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

