/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.dns;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.AdnlAddress;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

public class DnsUtils {
    static final String DNS_CATEGORY_NEXT_RESOLVER = "dns_next_resolver";
    static final String DNS_CATEGORY_WALLET = "wallet";
    static final String DNS_CATEGORY_SITE = "site";

    static BigInteger categoryToInt(String category) {
        if (Objects.isNull(category) || category.isEmpty()) {
            return BigInteger.ZERO;
        }
        byte[] categoryBytes = category.getBytes();
        String categoryHash = Utils.sha256((byte[])categoryBytes);
        return new BigInteger(categoryHash, 16);
    }

    public static Cell createSmartContractAddressRecord(Address smartContractAddress) {
        return CellBuilder.beginCell().storeUint(40915, 16).storeAddress(smartContractAddress).storeUint(0, 8).endCell();
    }

    public static Cell createAdnlAddressRecord(AdnlAddress adnlAddress) {
        return CellBuilder.beginCell().storeUint(44289, 16).storeBytes(adnlAddress.getClonedBytes()).storeUint(0, 8).endCell();
    }

    public static Cell createNextResolverRecord(Address smartContractAddress) {
        return CellBuilder.beginCell().storeUint(47763, 16).storeAddress(smartContractAddress).storeUint(0, 8).endCell();
    }

    private static Address parseSmartContractAddressImpl(Cell cell, int prefix0, int prefix1) {
        if ((cell.getBits().toByteArray()[0] & 0xFF) != prefix0 || (cell.getBits().toByteArray()[1] & 0xFF) != prefix1) {
            throw new Error("Invalid dns record value prefix");
        }
        Cell c = CellSlice.beginParse((Cell)cell).skipBits(16).sliceToCell();
        return NftUtils.parseAddress(c);
    }

    static Address parseSmartContractAddressRecord(Cell cell) {
        return DnsUtils.parseSmartContractAddressImpl(cell, 159, 211);
    }

    static Address parseNextResolverRecord(Cell cell) {
        return DnsUtils.parseSmartContractAddressImpl(cell, 186, 147);
    }

    static AdnlAddress parseAdnlAddressRecord(Cell cell) {
        if ((cell.getBits().toByteArray()[0] & 0xFF) != 173 || (cell.getBits().toByteArray()[1] & 0xFF) != 1) {
            throw new Error("Invalid dns record value prefix");
        }
        byte[] bytes = Arrays.copyOfRange(cell.getBits().toByteArray(), 2, 34);
        return AdnlAddress.of(bytes);
    }

    private static Object dnsResolveImpl(Tonlib tonlib, Address dnsAddress, byte[] rawDomainBytes, String category, boolean oneStep) {
        int len = rawDomainBytes.length * 8;
        CellBuilder domainCell = CellBuilder.beginCell();
        domainCell.storeBytes(rawDomainBytes);
        BigInteger categoryInteger = DnsUtils.categoryToInt(category);
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[slice, " + domainCell.endCell().toHex(true) + "]")));
        stack.offer((CallSite)((Object)("[num, " + String.valueOf(categoryInteger) + "]")));
        RunResult result = tonlib.runMethod(dnsAddress, "dnsresolve", stack);
        if (result.getStack().size() != 2) {
            throw new Error("Invalid dnsresolve response");
        }
        Cell cell = null;
        int resultLen = ((TvmStackEntryNumber)result.getStack().get(0)).getNumber().intValue();
        Object r = result.getStack().get(1);
        if (r instanceof TvmStackEntryCell) {
            TvmStackEntryCell cellResult = (TvmStackEntryCell)result.getStack().get(1);
            cell = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)cellResult.getCell().getBytes())).endCell();
        }
        if (Objects.nonNull(cell) && Objects.isNull(cell.getBits())) {
            throw new Error("Invalid dnsresolve response");
        }
        if (resultLen == 0) {
            return null;
        }
        if (resultLen % 8 != 0) {
            throw new Error("Domain split not at a component boundary");
        }
        if (resultLen > len) {
            throw new Error("Invalid response " + resultLen + "/" + len);
        }
        if (resultLen == len) {
            if (DNS_CATEGORY_NEXT_RESOLVER.equals(category)) {
                return Objects.nonNull(cell) ? DnsUtils.parseNextResolverRecord(cell) : null;
            }
            if (DNS_CATEGORY_WALLET.equals(category)) {
                return Objects.nonNull(cell) ? DnsUtils.parseSmartContractAddressRecord(cell) : null;
            }
            if (DNS_CATEGORY_SITE.equals(category)) {
                return Objects.nonNull(cell) ? DnsUtils.parseAdnlAddressRecord(cell) : null;
            }
            return null;
        }
        if (Objects.isNull(cell)) {
            return null;
        }
        Address nextAddress = DnsUtils.parseNextResolverRecord(cell);
        if (oneStep) {
            if (category.equals(DNS_CATEGORY_NEXT_RESOLVER)) {
                return nextAddress;
            }
            return null;
        }
        return DnsUtils.dnsResolveImpl(tonlib, nextAddress, Arrays.copyOfRange(rawDomainBytes, resultLen / 8, rawDomainBytes.length), category, false);
    }

    static byte[] domainToBytes(String domain) {
        int i;
        if (Objects.isNull(domain) || domain.isEmpty()) {
            throw new Error("Empty domain");
        }
        if (domain.equals(".")) {
            return new byte[]{0};
        }
        domain = domain.toLowerCase();
        for (i = 0; i < domain.length(); ++i) {
            if (domain.charAt(i) > ' ') continue;
            throw new Error("Bytes in range 0..32 are not allowed in domain names");
        }
        for (i = 0; i < domain.length(); ++i) {
            String s = domain.substring(i, i + 1);
            for (int c = 127; c <= 159; ++c) {
                if (!s.equals(String.valueOf(c))) continue;
                throw new Error("Bytes in range 127..159 are not allowed in domain names");
            }
        }
        ArrayList<String> arr = new ArrayList<String>(Arrays.asList(domain.split("\\.")));
        for (String part : arr) {
            if (!part.isEmpty()) continue;
            throw new Error("Domain name cannot have an empty component");
        }
        Collections.reverse(arr);
        String rawDomain = String.join((CharSequence)"\u0000", arr) + "\u0000";
        if (rawDomain.length() < 126) {
            rawDomain = "\u0000" + rawDomain;
        }
        return rawDomain.getBytes();
    }

    public static Object dnsResolve(Tonlib tonlib, Address rootDnsAddress, String domain, String category, boolean oneStep) {
        byte[] rawDomainBytes = DnsUtils.domainToBytes(domain);
        return DnsUtils.dnsResolveImpl(tonlib, rootDnsAddress, rawDomainBytes, category, oneStep);
    }
}

