/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.dns;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.dns.DnsItem;
import org.ton.java.smartcontract.dns.DnsUtils;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.CollectionData;
import org.ton.java.smartcontract.types.ItemData;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class DnsCollection
implements Contract {
    String dnsItemCodeHex;
    Cell collectionContent;
    Cell code;
    private Tonlib tonlib;
    private long wc;

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    public static DnsCollectionBuilder builder() {
        return new CustomDnsCollectionBuilder();
    }

    @Override
    public String getName() {
        return "dnsCollection";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeRef(this.collectionContent).storeRef(CellBuilder.beginCell().fromBoc(this.dnsItemCodeHex).endCell()).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.dnsCollection.getValue()).endCell();
    }

    public static CollectionData getCollectionData(Tonlib tonlib, Address dnsCollectionAddress) {
        RunResult result = tonlib.runMethod(dnsCollectionAddress, "get_collection_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_collection_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber nextItemIndexResult = (TvmStackEntryNumber)result.getStack().get(0);
        long nextItemIndex = nextItemIndexResult.getNumber().longValue();
        TvmStackEntryCell collectionContentResult = (TvmStackEntryCell)result.getStack().get(1);
        Cell collectionContent = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)collectionContentResult.getCell().getBytes())).endCell();
        String collectionContentUri = NftUtils.parseOffChainUriCell(collectionContent);
        return CollectionData.builder().collectionContentUri(collectionContentUri).collectionContentCell(collectionContent).ownerAddress(null).nextItemIndex(nextItemIndex).build();
    }

    public static ItemData getNftItemContent(Tonlib tonlib, Address dnsItemAddress) {
        return DnsItem.getData(tonlib, dnsItemAddress);
    }

    public static Address getNftItemAddressByIndex(Tonlib tonlib, Address collectionAddress, BigInteger index) {
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + index.toString() + "]")));
        RunResult result = tonlib.runMethod(collectionAddress, "get_nft_address_by_index", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_nft_address_by_index, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice addr = (TvmStackEntrySlice)result.getStack().get(0);
        return NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)addr.getSlice().getBytes())).endCell());
    }

    public static Address getNftItemAddressByDomain(Tonlib tonlib, Address dnsCollectionAddress, String domain) {
        Cell cell = CellBuilder.beginCell().storeString(domain).endCell();
        String cellHash = Utils.bytesToHex((byte[])cell.hash());
        return DnsCollection.getNftItemAddressByIndex(tonlib, dnsCollectionAddress, new BigInteger(cellHash, 16));
    }

    public static Object resolve(Tonlib tonlib, Address dnsCollectionAddress, String domain, String category, boolean oneStep) {
        return DnsUtils.dnsResolve(tonlib, dnsCollectionAddress, domain, category, oneStep);
    }

    DnsCollection(String dnsItemCodeHex, Cell collectionContent, Cell code, Tonlib tonlib, long wc) {
        this.dnsItemCodeHex = dnsItemCodeHex;
        this.collectionContent = collectionContent;
        this.code = code;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public String getDnsItemCodeHex() {
        return this.dnsItemCodeHex;
    }

    public Cell getCollectionContent() {
        return this.collectionContent;
    }

    public Cell getCode() {
        return this.code;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomDnsCollectionBuilder
    extends DnsCollectionBuilder {
        private CustomDnsCollectionBuilder() {
        }

        @Override
        public DnsCollection build() {
            if (Objects.isNull(this.collectionContent)) {
                throw new Error("Required collectionContent cell");
            }
            if (Objects.isNull(this.dnsItemCodeHex)) {
                throw new Error("Required dnsItemCodeHex field");
            }
            return super.build();
        }
    }

    public static class DnsCollectionBuilder {
        private String dnsItemCodeHex;
        private Cell collectionContent;
        private Cell code;
        private Tonlib tonlib;
        private long wc;

        DnsCollectionBuilder() {
        }

        public DnsCollectionBuilder dnsItemCodeHex(String dnsItemCodeHex) {
            this.dnsItemCodeHex = dnsItemCodeHex;
            return this;
        }

        public DnsCollectionBuilder collectionContent(Cell collectionContent) {
            this.collectionContent = collectionContent;
            return this;
        }

        public DnsCollectionBuilder code(Cell code) {
            this.code = code;
            return this;
        }

        public DnsCollectionBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public DnsCollectionBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public DnsCollection build() {
            return new DnsCollection(this.dnsItemCodeHex, this.collectionContent, this.code, this.tonlib, this.wc);
        }

        public String toString() {
            return "DnsCollection.DnsCollectionBuilder(dnsItemCodeHex=" + this.dnsItemCodeHex + ", collectionContent=" + String.valueOf(this.collectionContent) + ", code=" + String.valueOf(this.code) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

